package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

import java.util.List;
import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemRyuuTama extends Item
{
	
	//龍の玉を投げつけて、落下地点に雷を落とす
	
	public ItemRyuuTama(int i)
	{
		super(i);
		setMaxDamage(300);//最大耐久値だが、ここではチャージ値として扱う
		maxStackSize = 1;
		setCreativeTab(CreativeTabs.tabCombat);//クリエイティブの武器タブに登録
		setNoRepair();//修理不可
	}

	//右クリック時に呼び出されるメソッド
	@Override
   	public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityPlayer)
    {
    	float f = 20F;
    	double px, py, pz;
    	double xVector, yVector, zVector;
    	float[] r = {1.0F, 0.1F, 0.1F, 1.0F, 1.0F};
    	float[] g = {0.1F, 1.0F, 0.1F, 1.0F, 0.1F};
    	float[] b = {0.1F, 0.1F, 1.0F, 0.1F, 1.0F};
    	EntityLiving entityplayer = (EntityLiving)entityPlayer;
    	
    	EntityRyuuLightningBolt[] entityryuutama = new EntityRyuuLightningBolt[5];
    	if(!entityplayer.isSneaking() && itemstack.getItemDamageForDisplay() < 229)//受けているダメージが229よりちいさいなら　つまり耐久値が70/300より大きいなら
    	{
    		px = entityplayer.posX - (double)MathHelper.sin((entityplayer.rotationYaw) / 180F * 3.141593F) * (double)MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 2.0D;
    		py = entityplayer.posY - (double)MathHelper.sin(entityplayer.rotationPitch / 180F * 3.141593F) + entityplayer.getEyeHeight();
    		pz = entityplayer.posZ + (double)MathHelper.cos((entityplayer.rotationYaw) / 180F * 3.141593F) * (double)MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 2.0D;
    		xVector = - (double)MathHelper.sin((entityplayer.rotationYaw) / 180F * 3.141593F) * (double)MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 1.2D;
    		yVector = - (double)MathHelper.sin(entityplayer.rotationPitch / 180F * 3.141593F) * 0.5D + 0.2D;
    		zVector =   (double)MathHelper.cos((entityplayer.rotationYaw) / 180F * 3.141593F) * (double)MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 1.2D;
    		Random random = new Random();
    		int rand = random.nextInt(5);
    		entityryuutama[0] = new EntityRyuuLightningBolt(world,entityplayer, px, py, pz, xVector, yVector, zVector, r[rand], g[rand], b[rand]);
       		world.playSoundAtEntity(entityplayer, "random.orb", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
       		if(!world.isRemote)
       		{
           		world.spawnEntityInWorld(entityryuutama[0]);//龍の頸の玉を発射
       			itemstack.damageItem(70, entityplayer);//耐久を70減らす
       		}
    	}
    	else if(entityplayer.isSneaking() && itemstack.getItemDamageForDisplay() < 1)//スニーク時は５つ同時発射　5色の雷を落とす
    	{
    		float angle = -40F;
    		for(int i = 0; i < 5; i++)
    		{
    			px = entityplayer.posX - (double)MathHelper.sin((entityplayer.rotationYaw+angle) / 180F * 3.141593F) * (double)MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 2.0D;
    			py = entityplayer.posY - (double)MathHelper.sin(entityplayer.rotationPitch / 180F * 3.141593F) + entityplayer.getEyeHeight();
    			pz = entityplayer.posZ + (double)MathHelper.cos((entityplayer.rotationYaw+angle) / 180F * 3.141593F) * (double)MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 2.0D;
    			xVector = - (double)MathHelper.sin((entityplayer.rotationYaw+angle) / 180F * 3.141593F) * (double)MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 1.2D;
    			yVector = - (double)MathHelper.sin(entityplayer.rotationPitch / 180F * 3.141593F) * 0.5D + 0.2D;
    			zVector =   (double)MathHelper.cos((entityplayer.rotationYaw+angle) / 180F * 3.141593F) * (double)MathHelper.cos(entityplayer.rotationPitch / 180F * 3.141593F) * 1.2D;
    			entityryuutama[i] = new EntityRyuuLightningBolt(world, entityPlayer, px, py, pz, xVector, yVector, zVector, r[i], g[i], b[i]);
    			angle += 20F;
    		}
       		world.playSoundAtEntity(entityplayer, "random.orb", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
       		if(!world.isRemote)
       		{
       			for(int i = 0; i < 5; i++)
       			{
           			world.spawnEntityInWorld(entityryuutama[i]);//龍の頸の玉を発射
       			}
       			itemstack.damageItem(299, entityplayer);//耐久を299減らす
       		}
    	}
		//if(world.getBlockID == 0)
		//{
			
		//}
    		
       	return itemstack;
    }
	
	//インベントリにあるかぎり呼び出されるメソッド
	//@SideOnly(Side.CLIENT)
	@Override
	public void onUpdate(ItemStack itemstack, World world, Entity entity, int i, boolean flag)
    {
    	//耐久が減っていたら徐々に回復
    	if( entity.ticksExisted % 5 == 0 && itemstack.isItemDamaged() == true)//ダメージを受けているなら
    	{
    		if(!world.isRemote)
    		{
    			itemstack.damageItem(-5, (EntityLiving)entity);//毎フレーム耐久を1回復
    		}
    	}  
    }
	
	//アイテムを発光させる。 trueなら発光
	@SideOnly(Side.CLIENT)
	@Override
	public boolean hasEffect(ItemStack itemstack)
	{   
		return true;
    }
}