package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;

import java.util.List;
import java.util.Random;

public class ItemSakuyaWatch extends Item
{

	//周囲の時間を止めるアイテム　止まるのは基本移動のみ
	
	public ItemSakuyaWatch(int itemID)
	{
		super(itemID);
		maxStackSize = 1;
		setCreativeTab(CreativeTabs.tabMisc);//クリエイティブのその他タブに登録
	}
	
	//右クリックを押したときに呼び出されるメソッド
	@Override
   	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	if(entityPlayer.getFoodStats().getFoodLevel() > 0)//空腹ゲージ２以上で使用可能
    	{
    		int mode = 0;
    		if(entityPlayer.isSneaking())//スニークなら低速モード　　通常は停止モード
    		{
    			mode = 1;
    		}
    		EntityPrivateSquare entityPrivateSquare = new EntityPrivateSquare(world, entityPlayer, mode);
    		world.playSoundAtEntity(entityPlayer, "random.click", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));
       		if(!world.isRemote)
       		{
         		world.spawnEntityInWorld(entityPrivateSquare);//時間停止空間を生み出す
       			itemStack.stackSize--;//スタックから消滅させる
       		}
    	}
    		
       	return itemStack;
    }
}