package net.minecraft.thKaguyaMod;

import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Icon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemSilverKnife extends Item
{
	//咲夜の銀のナイフ　　投げてよし、切ってよし
	
	public static final String knifeColorNames[] =
    {
        "Silver Knife blue", "Silver Knife red"
    };
	public static final String knifeIconName[] =
	{
		"silverKnife_Blue", "silverKnife_Red"
	};
	
    @SideOnly(Side.CLIENT)
    private Icon[] icon;
	
	public ItemSilverKnife(int itemID)
	{
		super(itemID);
		maxStackSize = 64;
		setHasSubtypes(true);
		setMaxDamage(0);
		setCreativeTab(CreativeTabs.tabCombat);//クリエイティブの武器タブに登録
	}
	
	@SideOnly(Side.CLIENT)
	//ダメージ値によってアイテムアイコンを変える
    public Icon getIconFromDamage(int damage)
    {
        int i = MathHelper.clamp_int(damage, 0, 1);
        return this.icon[i];
    }
	
	@SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister iconRegister)
    {
        this.icon = new Icon[knifeIconName.length];

        for (int i = 0; i < knifeIconName.length; ++i)
        {
            this.icon[i] = iconRegister.registerIcon(knifeIconName[i]);
        }
    }
	
	//Entityに対して与えるダメージを返す
	@Override
    public int getDamageVsEntity(Entity entity)
    {
        return 3;//普通に攻撃したときはハート1.5個分ダメージ　投げても1.5ダメージ
    }
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	double xVec,yVec,zVec;
    	EntitySilverKnife entitySilverKnife;

    	xVec = -(double)MathHelper.sin(entityPlayer.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F);//X方向　水平方向
    	yVec = -(double)MathHelper.sin(entityPlayer.rotationPitch / 180F * 3.141593F);//Y方向　上下
    	zVec =  (double)MathHelper.cos(entityPlayer.rotationYaw / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F);//Z方向　水平方向
   		entitySilverKnife = new EntitySilverKnife(world, (EntityLiving)entityPlayer, xVec * 0.5D, yVec * 0.5D, zVec * 0.5D, 0.5D, itemStack.getItemDamage());
       	
    	world.playSoundAtEntity(entityPlayer, "random.bow", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
       	
    	if(!world.isRemote)
       	{
          		world.spawnEntityInWorld(entitySilverKnife);//銀のナイフを出現させる
       	}
    	
    	itemStack.stackSize--;//一つ消費
    	
    	entityPlayer.swingItem();//投げる動作をさせる
        
    	return itemStack;
    }
	
	@SideOnly(Side.CLIENT)
	//クリエイトモードのアイテム欄に、ダメージ値の違うアイテムも表示できるようにする
    public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List)
    {
        for (int i = 0; i < 2; i++)
        {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }
}