package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.StringTranslate;
import net.minecraft.client.renderer.texture.IconRegister;

import java.util.List;
import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemSpellCard extends Item
{
	
	//スペルカード
	private String spellCardName[] = {
		"霊符「夢想封印」",
		"恋符「マスタースパーク」",
		"死蝶「華胥の永眠」",
		"星符「メテオニックシャワー」",
		"境符「波と粒の境界」"};
	
	private String spellCardNameEn[] = {
		"Spirit Sign \"Fantasy Seal\"",
		"Love Sign \"Master Spark\"",
		"Deadly Butterfly \"Everlasting Nap\"",
		"Star Sign \"Meteonic Shower\"",
		"Boundary Sign \"Boundary between Wave and Particle\""
	};
	
	public static final String spellCardIconNames[] =
	{
		"0", "1", "2", "3", "4"
	};
	
	@SideOnly(Side.CLIENT)
    private Icon[] icon;
	
	public ItemSpellCard(int i)
	{
		super(i);
		maxStackSize = 1;
		setCreativeTab(mod_thKaguya.tabSpellCard);//クリエイティブのスペルカードタブに登録
	}
	
	public String getUnlocalizedName(ItemStack itemStack)
    {
        int i = MathHelper.clamp_int(itemStack.getItemDamage(), 0, 15);
        return super.getUnlocalizedName() + "." + spellCardNameEn[i];
    }
	
	@SideOnly(Side.CLIENT)
	//ダメージ値によってアイテムアイコンを変える
    public Icon getIconFromDamage(int damage)
    {
        int i = MathHelper.clamp_int(damage, 0, 6);
        return this.icon[i];
    }
	
	@SideOnly(Side.CLIENT)
    public void registerIcons(IconRegister par1IconRegister)
    {
        this.icon = new Icon[spellCardIconNames.length];

        for (int i = 0; i < spellCardIconNames.length; ++i)
        {
            this.icon[i] = par1IconRegister.registerIcon("spellCard/" + spellCardIconNames[i]);
        }
    }
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {	
    	double angleX = -(double)MathHelper.sin(entityPlayer.rotationYaw   / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F);
    	double angleY = -(double)MathHelper.sin(entityPlayer.rotationPitch / 180F * 3.141593F);
    	double angleZ =  (double)MathHelper.cos(entityPlayer.rotationYaw   / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F);
    	//始点を登録
    	Vec3 vec3d = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX, entityPlayer.posY + entityPlayer.getEyeHeight(), entityPlayer.posZ);
    	//終点を登録
    	Vec3 vec3d1 = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX + angleX * 32.0D, entityPlayer.posY + angleY * 32.0D, entityPlayer.posZ + angleZ * 32.0D);
        //始点と終点からブロックとの衝突を取得
    	MovingObjectPosition movingObjectPosition = world.rayTraceBlocks(vec3d, vec3d1);
    	//始点を登録
    	vec3d = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX, entityPlayer.posY + entityPlayer.getEyeHeight(), entityPlayer.posZ);
    	//終点を登録
    	vec3d1 = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX + angleX * 32.0D, entityPlayer.posY + angleY * 32.0D, entityPlayer.posZ + angleZ * 32.0D);
        //ブロックと衝突していたなら
    	if (movingObjectPosition != null)
        {
        	//終点を衝突した点に変更
        	vec3d1 = world.getWorldVec3Pool().getVecFromPool(movingObjectPosition.hitVec.xCoord, movingObjectPosition.hitVec.yCoord, movingObjectPosition.hitVec.zCoord);
        }
    	Entity entity = null;

    	//このEntityから移動後までの線分に、指定分の範囲を追加した直方体と衝突するEntityのリストを取得
        List list = world.getEntitiesWithinAABBExcludingEntity(entityPlayer, entityPlayer.boundingBox.addCoord(angleX * 32.0D, angleY * 32.0D, angleZ * 32.0D).expand(1.0D, 1.0D, 1.0D));
        double d = 0.0D;
        for (int j = 0; j < list.size(); j++)
        {
        	// 衝突リストから、i番目のEntityを取得
            Entity entity1 = (Entity)list.get(j);

    		if(entity1.canBeCollidedWith() && entity1 instanceof EntityLiving)
    		{
        		float f2 = 0.3F;
            	AxisAlignedBB axisalignedbb = entity1.boundingBox.expand(f2, f2, f2);
            	MovingObjectPosition movingObjectPosition1 = axisalignedbb.calculateIntercept(vec3d, vec3d1);
        		//Entityとの衝突がないなら、このEntityはパスする
            	if (movingObjectPosition1 != null)
            	{
        			//始点からEntityに衝突した点までの距離を取得
            		double d1 = vec3d.distanceTo(movingObjectPosition1.hitVec);
        			//今までで一番近いEntityなら、Entityと距離を記憶する
            		if (d1 < d || d == 0.0D)
            		{		
                		entity = entity1;
                		d = d1;
            		}
            	}
            }
        }

    	//Entityに当たっていたなら
        if (entity != null)
        {
            movingObjectPosition = new MovingObjectPosition(entity);
        }
    	
    	/*if (movingObjectPosition != null && movingObjectPosition.entityHit != null && movingObjectPosition.entityHit instanceof EntityPlayer)
        {
        	EntityPlayer entityPlayer2 = (EntityPlayer)movingObjectPosition.entityHit;

            if (entityPlayer2.capabilities.disableDamage)
            {
            	movingObjectPosition = null;
            }
        }*/
    	
    	if (movingObjectPosition != null && movingObjectPosition.entityHit != null && itemPossessionCheck(world, entityPlayer, itemStack.getItemDamage()))
        {
	    	EntitySpellCard entitySpellCard;
	    	entitySpellCard = new EntitySpellCard(world, entityPlayer, (EntityLiving)movingObjectPosition.entityHit, itemStack.getItemDamage());
	    	world.playSoundAtEntity(entityPlayer, "random.spellcard", mod_thKaguya.SpellCardVol, 1.0F);
	       	if(!world.isRemote)
	       	{
	        	world.spawnEntityInWorld(entitySpellCard);//スペルカードを出現させる
	       		/*StringTranslate strTrans = new StringTranslate("ja_JP");
	       		if(strTrans.getCurrentLanguage() == "ja_JP")
	       		{
	       			entityPlayer.addChatMessage( spellCardName[itemStack.getItemDamage()] );
	       		}
	       		else*/
	       		{
	       			entityPlayer.addChatMessage( spellCardName[itemStack.getItemDamage()] );
	       			//entityPlayer.addChatMessage( spellCardNameEn[itemStack.getItemDamage()] );
	       		}
	       		itemStack.stackSize--;//スタックから消滅させる
	       	}
        }
    	
    	return itemStack;
   	}
	
	private boolean itemPossessionCheck(World world, EntityPlayer entityPlayer, int nomber)
	{
		/*switch(nomber)
		{
			case 1:*/
		return true;		
	}
	
	public String getItemDisplayName(ItemStack itemStack)
	{
		return spellCardName[itemStack.getItemDamage()];
	}
	
	@SideOnly(Side.CLIENT)
	//クリエイトモードのアイテム欄に、ダメージ値の違うアイテムも表示できるようにする
    public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List)
    {
        for (int i = 0; i < spellCardName.length; i++)
        {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }
	

}