package net.minecraft.thKaguyaMod;

import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class ItemSukima extends Item
{
	
	//スキマを設置する
	//同じ色のスキマ同士を行き来することができるようになる
	//シフトで使うと瞬間的に見た場所に移動できるスキマを作る
	//Entityを見て使うとそのEntityを取り寄せる
	
	public ItemSukima(int i)
	{
		super(i);
		maxStackSize = 64;
		setCreativeTab(CreativeTabs.tabMisc);//クリエイティブのその他タブに登録
	}
	
	//右クリックを押したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	//通常世界なら使用可能  ここで-1にするとネザーということになる　　また、プレイヤーが何かに乗っているときは使用できない
    	//旧バージョンの効果*****************************************************************//
    	/*if(par3EntityPlayer.dimension == 0 && par3EntityPlayer.ridingEntity == null)
    	{
    		ChunkCoordinates chunkcoordinates = par2World.getSpawnPoint();
    		ChunkCoordinates chunkcoordinates2 = chunkcoordinates;
    		chunkcoordinates = par3EntityPlayer.verifyRespawnCoordinates(par2World, chunkcoordinates);
    		if( chunkcoordinates == null)
    		{
    			chunkcoordinates = chunkcoordinates2;
    		}
	    	par3EntityPlayer.posX = chunkcoordinates.posX+0.5F;
	    	par3EntityPlayer.posY = chunkcoordinates.posY-0.5F;
	    	par3EntityPlayer.posZ = chunkcoordinates.posZ+0.5F;
	    	par3EntityPlayer.fallDistance = 0.0F;
	    	//par3EntityPlayer.setPosition(par3EntityPlayer.posX,par3EntityPlayer.posY,par3EntityPlayer.posZ);

	    	par3EntityPlayer.preparePlayerToSpawn();
	    	
	    	//par3EntityPlayer.respawnPlayer();
	    	par2World.playSoundAtEntity(par3EntityPlayer, "mob.endermen.portal", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));
	    	par1ItemStack.stackSize--;
    	}*/
    	//************************************************************************************//
    	
    	double sx = entityPlayer.posX - (double)MathHelper.sin(entityPlayer.rotationYaw   / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F) * 2.0D;
    	double sy = entityPlayer.posY - (double)MathHelper.sin(entityPlayer.rotationPitch / 180F * 3.141593F) * 2.0D + entityPlayer.getEyeHeight() / 2.0D;
    	double sz = entityPlayer.posZ + (double)MathHelper.cos(entityPlayer.rotationYaw   / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F)* 2.0D;
    	//if(par2World.isAirBlock((int)sx, (int)sy, (int)sz))
    	if(!world.isBlockNormalCube((int)sx, (int)sy, (int)sz))
    	{
    		EntitySukima entitySukima;
    		EntitySukima entitySukima2;
    		double hitX = entityPlayer.posX;
    		double hitY = entityPlayer.posY;
    		double hitZ = entityPlayer.posZ;
    		if(!entityPlayer.isSneaking())
    		{
    			entitySukima = new EntitySukima(world, entityPlayer, sx, sy, sz);
    		}
    		else
    		{
    			double xVecMax = -(double)MathHelper.sin(entityPlayer.rotationYaw   / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F) * 128.0D;
    			double yVecMax = -(double)MathHelper.sin(entityPlayer.rotationPitch / 180F * 3.141593F) * 128.0D;
    			double zVecMax =  (double)MathHelper.cos(entityPlayer.rotationYaw   / 180F * 3.141593F) * (double)MathHelper.cos(entityPlayer.rotationPitch / 180F * 3.141593F) * 128.0D;
    			//始点（現在地）
    			Vec3 vec3d = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX, entityPlayer.posY + entityPlayer.getEyeHeight(), entityPlayer.posZ);
    			//Vec3 vec3d = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX, entityPlayer.posY, entityPlayer.posZ);
    			//終点（現在地に移動量を足した点）
    			Vec3 vec3d1 = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX + xVecMax, entityPlayer.posY + entityPlayer.getEyeHeight() + yVecMax, entityPlayer.posZ + zVecMax);
    			//Vec3 vec3d1 = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX + xVecMax, entityPlayer.posY + yVecMax, entityPlayer.posZ + zVecMax);
        		//始点と終点からブロックとの当たりを取得
    			MovingObjectPosition movingObjectPosition = world.rayTraceBlocks(vec3d, vec3d1);
    			vec3d = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX, entityPlayer.posY + entityPlayer.getEyeHeight(), entityPlayer.posZ);
    			vec3d1 = world.getWorldVec3Pool().getVecFromPool(entityPlayer.posX + xVecMax, entityPlayer.posY + entityPlayer.getEyeHeight() + yVecMax, entityPlayer.posZ + zVecMax);
    			//何らかのブロックに当たっているなら
        		if (movingObjectPosition != null)
        		{
        			//終点を当たった点に変更
        			vec3d1 = world.getWorldVec3Pool().getVecFromPool(movingObjectPosition.hitVec.xCoord, movingObjectPosition.hitVec.yCoord, movingObjectPosition.hitVec.zCoord);
        			hitX = movingObjectPosition.hitVec.xCoord;
        			hitY = movingObjectPosition.hitVec.yCoord;
        			hitZ = movingObjectPosition.hitVec.zCoord;
        			double xz_sq = (hitX - sx) * (hitX - sx) + (hitZ - sz) * (hitZ - sz);//平面方向の平方
        			//５m以下の距離なら無効
        			if(Math.sqrt( xz_sq + (hitY - sy) * (hitY - sy)) <= 5.0D)
        			{
        				return itemStack;
        			}
        		}
    			else
    			{
    				return itemStack;
    			}
    			Entity entity = null;

    			//このEntityから移動後までの線分に、指定分の範囲を追加した直方体と衝突するEntityのリストを取得
        		List list = world.getEntitiesWithinAABBExcludingEntity(entityPlayer, entityPlayer.boundingBox.addCoord(xVecMax, yVecMax, zVecMax).expand(1.0D, 1.0D, 1.0D));
        		double d = 0.0D;
		        for (int j = 0; j < list.size(); j++)
		        {
		        	// 衝突リストから、i番目のEntityを取得
		            Entity entity1 = (Entity)list.get(j);

		    		if(entity1.canBeCollidedWith())
		    		{
		        		float f2 = 0.3F;
		            	AxisAlignedBB axisalignedbb = entity1.boundingBox.expand(f2, f2, f2);
		            	MovingObjectPosition movingObjectPosition1 = axisalignedbb.calculateIntercept(vec3d, vec3d1);
		        		//Entityとの衝突がないなら、このEntityはパスする
		            	if (movingObjectPosition1 != null)
		            	{
		        			//始点からEntityに衝突した点までの距離を取得
		            		double d1 = vec3d.distanceTo(movingObjectPosition1.hitVec);
		        			//今までで一番近いEntity、かつ、５m以上離れているなら、Entityと距離を記憶する
		            		if((d1 < d || d == 0.0D) && d1 > 5.0D)
		            		{		
		                		entity = entity1;
		                		d = d1;
		            		}
		            	}
		            }
		        }

		    	//Entityに当たっていたなら
		        if (entity != null)
		        {
		            movingObjectPosition = new MovingObjectPosition(entity);
		        	movingObjectPosition.entityHit = entity;
		        }
		    	
		    	/*if (movingObjectPosition != null && movingObjectPosition.entityHit != null && movingObjectPosition.entityHit instanceof EntityPlayer)
		        {
		        	EntityPlayer entityPlayer2 = (EntityPlayer)movingObjectPosition.entityHit;

		            if (entityPlayer2.capabilities.disableDamage)
		            {
		            	movingObjectPosition = null;
		            }
		        }*/
		    	
		    	if (movingObjectPosition != null && movingObjectPosition.entityHit != null)
		        {
		        	if(movingObjectPosition.entityHit instanceof EntityLiving)
		        	{
		        		EntityLiving hitEntityLiving = (EntityLiving)movingObjectPosition.entityHit;
		        		hitX = hitEntityLiving.posX;
		        		hitY = hitEntityLiving.posY + hitEntityLiving.yOffset / 2.0D;
		        		hitZ = hitEntityLiving.posZ;
		        		sy += 1.0D;
		        	}
		        	else
		        	{
		        		hitX = movingObjectPosition.entityHit.posX;
		        		hitY = movingObjectPosition.entityHit.posY + 0.75D;
		        		hitZ = movingObjectPosition.entityHit.posZ;
		        	}
		        }
    			/*else
    			{
    				return itemStack;
    			}*/
    			entitySukima = new EntitySukima(world, entityPlayer, sx, sy, sz,
    											0.0D,
    											0.0D,
    											0.0D);
    			entitySukima2 = new EntitySukima(world, entityPlayer, hitX, hitY, hitZ,
    											0.0D,
    											0.0D,
    											0.0D);
    			if(!world.isRemote)
    			{
    				world.spawnEntityInWorld(entitySukima2);//スキマを生み出す
    			}
    		}
    		world.playSoundAtEntity(entityPlayer, "mob.endermen.portal", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));
    		if(!world.isRemote)
    		{
    			world.spawnEntityInWorld(entitySukima);//スキマを生み出す
    			itemStack.stackSize--;//スタックを一つ減らす
    		}
    	}
        return itemStack;
    }
}