package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import java.util.Random;

public class ItemYuukaParasol extends ItemBow
{
	//幽香の傘
	
	public ItemYuukaParasol(int itemID)
	{
		super(itemID);
		setMaxDamage(60);
	}
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
    	ArrowNockEvent event = new ArrowNockEvent(entityPlayer, itemStack);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled())
        {
            return event.result;
        }
    	entityPlayer.setItemInUse(itemStack, getMaxItemUseDuration(itemStack));//アイテムの使用継続時間を記憶させる
    	/*if(entityPlayer.isSneaking())
    	{
    		EntityYuukaParasol entityYuukaParasol = new EntityYuukaParasol(world, entityPlayer, itemStack.getItemDamageForDisplay());
    		if(!world.isRemote)
    		{
    			world.spawnEntityInWorld(entityYuukaParasol);
    		}
    		itemStack.stackSize--;
    	}*/
    	return itemStack;
    }
	
	//右クリックを離したときに呼び出される
	@Override
	public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer entityPlayer, int usedTime)
	{
		int shotPower = 10 + getMaxItemUseDuration(itemStack)-usedTime;
		ArrowLooseEvent event = new ArrowLooseEvent(entityPlayer, itemStack, shotPower);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled())
        {
            return;
        }
		double shotPower2 = (float)shotPower / 10.0D;
		if(shotPower2 > 4.0D)
		{
			shotPower2 = 5.0D;
		}
    	float transDegree = 3.141593F / 180F;
    	double ax,ay,az;
    	//EntityUrokoShot entityUrokoShot;
    	EntityTHShot entityTHShot;
		Random random = new Random();
    	float angle = (float)random.nextInt(36000)/100F;
    	float angle2 = 0.0F;
    	int shotNum = 45;
    	float angleSpan = (360F / (float)shotNum) * transDegree;
    	float angle2Span = angleSpan * 20F;
		int color = 24 + random.nextInt(2);
		if(color == 25)
		{
			color = 27;
		}
    	for(int i = 0; i < shotNum; i++)
    	{
    		ax = -(double)MathHelper.sin(angle);//X方向　水平方向
    		az =  (double)MathHelper.cos(angle);//Z方向　水平方向
   			//entityUrokoShot = new EntityUrokoShot(world, (EntityLiving)entityPlayer, ax * shotPower2, 1.4F, az * shotPower2,
   			//	0.23D - (double)MathHelper.sin(angle2) * 0.02D, 7, color, 0.3F, true);
    		double speed = 0.23D - (double)MathHelper.sin(angle2) * 0.02D;
    		entityTHShot = new EntityTHShot(world, (EntityLiving)entityPlayer, entityPlayer, 
    			entityPlayer.posX, entityPlayer.posY, entityPlayer.posZ, 
    			ax * shotPower2, 1.4F, az * shotPower2,
    			speed, speed, 1.0D, 0.0D, -0.02D, 0.0D, 7, color, 0.3F, 120, 1);
    		if(!world.isRemote)
       		{
          		world.spawnEntityInWorld(entityTHShot);//鱗弾を出現させる
       		}
    		angle += angleSpan;
    		angle2 += angle2Span;
    	}
    	
    	shotNum = (int)((float)shotNum * 0.25F);
    	angleSpan  = (360F / (float)shotNum) * transDegree;
		shotPower2 *= 0.66D;
    	for(int i = 0 ;i < shotNum; i++)
    	{
    		ax = -(double)MathHelper.sin(angle);//X方向　水平方向
    		az =  (double)MathHelper.cos(angle);//Z方向　水平方向
    		//entityUrokoShot = new EntityUrokoShot(world, (EntityLiving)entityPlayer, ax * shotPower2, 1.1F, az * shotPower2, 0.23D, 7, color, 0.3F, true);
       		entityTHShot = new EntityTHShot(world, (EntityLiving)entityPlayer, entityPlayer, 
       			entityPlayer.posX, entityPlayer.posY, entityPlayer.posZ, 
       			ax * shotPower2, 1.1F, az * shotPower2,
    			0.23D, 0.23D, 1.0D, 0.0D, -0.02D, 0.0D, 7, color, 0.3F, 120, 1);
    		if(!world.isRemote)
       		{
          		world.spawnEntityInWorld(entityTHShot);//鱗弾を出現させる
       		}
    		angle += angleSpan;
    	}
    	world.playSoundAtEntity(entityPlayer, "random.bow", 0.5F, 0.4F / (itemRand.nextFloat() * 4F + 0.8F));//音を出す
		itemStack.damageItem(1, entityPlayer);
    }
	
	//Entityに当たった時に呼び出される
	@Override
    public boolean hitEntity(ItemStack par1ItemStack, EntityLiving par2EntityLiving, EntityLiving par3EntityLiving)
    {
    	//Entityを吹っ飛ばす
    	double disX = par2EntityLiving.posX - par3EntityLiving.posX;
    	double disY = par2EntityLiving.posY - par3EntityLiving.posY;
    	double disZ = par2EntityLiving.posZ - par3EntityLiving.posZ;
    	float toEntityYaw = (float)Math.atan2(disX, disZ);
    	float toEntityPitch = (float)Math.atan2(disY, Math.sqrt(disX * disX + disZ * disZ));
    	double power = 3.0D;
    	par2EntityLiving.motionX = MathHelper.sin(toEntityYaw) * MathHelper.cos(toEntityPitch) * power;
    	par2EntityLiving.motionY = MathHelper.sin(toEntityPitch) * power + 1.0D;
    	par2EntityLiving.motionZ = MathHelper.cos(toEntityYaw) * MathHelper.cos(toEntityPitch) * power;
    	par1ItemStack.damageItem(1, par3EntityLiving);
    	
        return true;
    }
	
	//アイテムを使ったときのアクションを指定
	@Override
	public EnumAction getItemUseAction(ItemStack par1ItemStack)
    {
        return EnumAction.block;//右クリック時は剣のガードアクション
    }
	
	//Entityへのダメージ
	@Override
    public int getDamageVsEntity(Entity par1Entity)
    {
        return 7;
    }
	
	//エンチャント
	@Override
    public int getItemEnchantability()
    {
        return 0;//エンチャントできない
    }

}