package net.minecraft.thKaguyaMod;

import net.minecraftforge.common.MinecraftForge;
import net.minecraft.item.*;
import net.minecraft.world.World;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

import java.util.List;
import java.util.Random;

public class ItemYuyukoFan extends ItemBow
{
	
	//幽々子の扇
	//死に誘う扇
	//蝶の弾幕をいくらでも出せるが、どんどん腹が減る
	//
	
	public ItemYuyukoFan(int itemID)
	{
		super(itemID);
		setMaxDamage(444);
	}
	
	//右クリックを押したときの処理
	@Override
	public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer)
    {
        ArrowNockEvent event = new ArrowNockEvent(entityPlayer, itemStack);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled())
        {
            return event.result;
        }
        
        entityPlayer.setItemInUse(itemStack, this.getMaxItemUseDuration(itemStack));

        return itemStack;
    }
	
	//右クリックを終了したときに呼び出されるメソッド
	@Override
	public void onPlayerStoppedUsing(ItemStack itemStack, World world, EntityPlayer entityPlayer, int usedTime)
    {
    	int i,j,rand,shotNum,shotNum3;
    	shotNum = 32 + getMaxItemUseDuration(itemStack) - usedTime;//発射される弾数を代入。　最低32発。　getMaxItemUseDuration(itemStack)-usedTimeは右クリック継続時間で変化する部分
    	if(shotNum > 72)
    	{
    		shotNum = 72;//最大でも72発まで
    	}
    	else if(shotNum % 3 != 0)
    	{
    		shotNum = (int)(shotNum / 3) * 3;
    	}
    	shotNum3 = shotNum / 3;
    	double X1,X2,Z1,Z2,angleXZ = 0,angleY = 0,ay,ax,az;
		Vec3 lookAt = entityPlayer.getLookVec();
		lookAt.rotateAroundY((float)Math.PI*2);
    	float f = 20F, angle = 0F, spanAngle;
    	spanAngle = 1080F/(float)shotNum; //あらゆる弾数でも360度飛ぶように、弾の間隔を代入
    	Random random = new Random();
    	EntityTHShot[] entityTHShot = new EntityTHShot[72];
    	
    	if(entityPlayer.isSneaking())//スニーク状態なら
    	{
    		//弾幕を発射。　単純な全方位ではなく、弾速の違う３つをセットに全方位に放つ
    		for( j = 0 ; j < 3; j++)
    		{
    			rand = 33 + random.nextInt(4);//弾の色をランダムで決める
    			for(i = 0; i < shotNum3; i++)
    			{	
    				//飛ぶ方向を設定
					angleXZ = angle;//横の角度　0=正面　+1ごとに左にずれていき360で正面に戻る
					angleY = 0;//縦の角度　0=正面　+1ごとに上にずれていき360で正面に戻る
    				
					angleXZ = angle;//横の角度　0=正面　+1ごとに左にずれていき360で正面に戻る
					angleY = 0;//縦の角度　0=正面　+1ごとに上にずれていき360で正面に戻る
    				
					X1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.cos(entityPlayer.rotationYaw/ 180.0F * Math.PI);
					Z1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.sin(entityPlayer.rotationYaw/ 180.0F * Math.PI);
					X2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch)/ 180.0F * Math.PI) * Math.sin(entityPlayer.rotationYaw/ 180.0F * Math.PI);
					Z2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch)/ 180.0F * Math.PI) * Math.cos(entityPlayer.rotationYaw/ 180.0F * Math.PI);
					
					ay = -Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch - angleY)/ 180.0F * Math.PI);//Y方向　上下
					ax =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord + X1 - X2;//X方向　水平方向
					az =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord + Z1 + Z2;//Z方向　水平方向
    				
    				entityTHShot[j * shotNum3 + i] = new EntityTHShot(world, entityPlayer, ax, ay, az, 0.1D + (double)(j * 0.1), 3,rand, 0.6F);//蝶弾の配列に方向、色などを代入
   					
    				angle += spanAngle;
   				}
    		}
    	}
    	else//スニーク状態でないなら
    	{
    		angle = -30F;
    		spanAngle = spanAngle / 6F;
    		rand = 33 + random.nextInt(4);//弾の色をランダムで決める
    		//こっちは前方集中
    		for(i = 0; i < shotNum / 3 + 1; i++)
    		{		
    			//飛ぶ方向を設定
				angleXZ = angle;//横の角度　0=正面　+1ごとに左にずれていき360で正面に戻る
				angleY = 0;//縦の角度　0=正面　+1ごとに上にずれていき360で正面に戻る
    			
				X1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.cos(entityPlayer.rotationYaw/ 180.0F * Math.PI);
				Z1 =  Math.sin(angleXZ/ 180.0F * Math.PI) * Math.sin(entityPlayer.rotationYaw/ 180.0F * Math.PI);
				X2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch)/ 180.0F * Math.PI) * Math.sin(entityPlayer.rotationYaw/ 180.0F * Math.PI);
				Z2 =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin(angleY/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch)/ 180.0F * Math.PI) * Math.cos(entityPlayer.rotationYaw/ 180.0F * Math.PI);
				
				ay = -Math.cos(angleXZ/ 180.0F * Math.PI) * Math.sin((entityPlayer.rotationPitch - angleY)/ 180.0F * Math.PI);//Y方向　上下
				ax =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.xCoord + X1 - X2;//X方向　水平方向
				az =  Math.cos(angleXZ/ 180.0F * Math.PI) * Math.cos(angleY/ 180.0F * Math.PI) * lookAt.zCoord + Z1 + Z2;//Z方向　水平方向
    			
    			entityTHShot[i] = new EntityTHShot(world, entityPlayer, ax, ay, az, 0.1D, 3, rand, 0.6F);//蝶弾の配列に方向、色などを代入
				
    			angle += spanAngle;//飛ばす方向を360/弾数分増やす
			}
    	}
		
		if(!world.isRemote)
		{
			if(entityPlayer.isSneaking())
			{
				for(i = 0; i < shotNum; i++)
				{
					world.spawnEntityInWorld(entityTHShot[i]);//配列に保存した設定で蝶弾を出現させる
				}
			}
			else
			{
				for(i = 0; i < shotNum / 3 + 1; i++)
				{
					world.spawnEntityInWorld(entityTHShot[i]);//配列に保存した設定で蝶弾を出現させる
				}
			}
		}
		
		if(!entityPlayer.capabilities.isCreativeMode)//クリエイティブでないなら
		{
			entityPlayer.addExhaustion(1.5F);//使うたびに少し腹が減る
		}
		world.playSoundAtEntity(entityPlayer, "random.orb", 0.5F, 1.0F);//音を出す
		itemStack.damageItem(1, entityPlayer);//
   	}
	
	//アイテムを使ったときのアクションを指定
	@Override
	public EnumAction getItemUseAction(ItemStack itemStack)
    {
        return EnumAction.block;//右クリック時は剣のガードアクション
    }
	
	//アイテムを発光させる。 trueなら発光
	@Override
	public boolean hasEffect(ItemStack itemStack)
	{   
		return true;
    }
	
	//アイテムを大きく表示する
	@Override
	public boolean isFull3D()
    {
        return true;
    }
    
    //エンチャント不可
    @Override
    public int getItemEnchantability()
    {
        return 0;
    }
}