package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;


import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderButterflyShot extends Render
{
	
	//蝶弾の描画
	private Random random = new Random();

    public RenderButterflyShot()
    {
    }

    public void doRenderButterflyShot(EntityButterflyShot entityButterflyShot, double x, double y, double z,
            float yaw, float f1)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
    	
    	GL11.glEnable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_NORMALIZE);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
    	
        float size = 1.0F;
        GL11.glScalef(size, size, size);
        loadTexture("/textures/ButterflyShot.png");
        Tessellator tessellator = Tessellator.instance;
    	int color = entityButterflyShot.getShotColor();
        float minU = (float)(color * 32 +  0) / 128F;
        float maxU = (float)(color * 32 + 32) / 128F;
        float minV = 0F;
        float maxV = 1F;
    	float pitch = entityButterflyShot.rotationPitch;
    	if(pitch > 90F)
    	{
    		pitch = 90F - pitch % 90F;
    	}
    	else if(pitch < -90F)
    	{
    		pitch = -90F - pitch % 90F;
    	}
    	GL11.glRotatef(yaw, 0.0F, 1.0F, 0.0F);
    	GL11.glRotatef(-pitch, 1.0F, 0.0F, 0.0F);
    	GL11.glRotatef(entityButterflyShot.getWingAngle(), 0.0F, 0.0F, 1.0F);
        tessellator.setNormal(0.0F, 1.0F, 0.0F);
    	//for(int i = 0; i < 3; i++)
    	{
	    	tessellator.startDrawingQuads();
	        tessellator.addVertexWithUV(0.0F, 0.0F,  0.5D, maxU, minV);
	        tessellator.addVertexWithUV(0.5F, 0.0F,  0.5D, minU, minV);
	        tessellator.addVertexWithUV(0.5F, 0.0F, -0.5D, minU, maxV);
	        tessellator.addVertexWithUV(0.0F, 0.0F, -0.5D, maxU, maxV);
	        tessellator.draw();
    	}	
    	GL11.glRotatef(-entityButterflyShot.getWingAngle() * 2F, 0.0F, 0.0F, 1.0F);
    	//for(int i = 0; i < 3; i++)
    	{
	    	tessellator.startDrawingQuads();
	        tessellator.addVertexWithUV( 0.0F, 0.0F,  0.5D, maxU, minV);
	        tessellator.addVertexWithUV(-0.5F, 0.0F,  0.5D, minU, minV);
	        tessellator.addVertexWithUV(-0.5F, 0.0F, -0.5D, minU, maxV);
	        tessellator.addVertexWithUV( 0.0F, 0.0F, -0.5D, maxU, maxV);
	        tessellator.draw();
    	}
        GL11.glDisable(GL11.GL_BLEND);
    	GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
        GL11.glDisable(GL11.GL_LIGHTING);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double d, double d1, double d2,
            float f, float f1)
    {
    	EntityButterflyShot entityButterflyShot = (EntityButterflyShot)entity;
        doRenderButterflyShot(entityButterflyShot, d, d1, d2, f, f1);
    }
}
