package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderHisou extends Render
{
	
	//緋想の剣の描画
	
    /** instance of ModelBoat for rendering */
    protected ModelBase modelHisou;

    public RenderHisou()
    {
        shadowSize = 0.5F;//多分影のサイズ
        modelHisou = new ModelHisou();
    }

    /**
     * The render method used in RenderBoat that renders the boat model.
     */
    public void renderHisou(EntityHisou par1EntityHisou, double x, double y, double z, float par8, float par9)
    {
        GL11.glPushMatrix();
    	//GL11.glDisable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);
        GL11.glTranslatef((float)x, (float)y, (float)z);
    	GL11.glRotatef(par1EntityHisou.rotationPitch, -MathHelper.sin(par1EntityHisou.rotationYaw/180F * 3.141593F), 0.0F, MathHelper.cos(par1EntityHisou.rotationYaw/180F * 3.141593F));
    	GL11.glRotatef(par1EntityHisou.rotationYaw, 0.0F, 1.0F, 0.0F);

        loadTexture("/textures/HisouTexture.png");//テクスチャ画像を読み込み
        GL11.glScalef(0.3F, 0.7F, 0.3F);//倍率　縦方向 高さ　幅
    	//if(par1EntityHisou.getNum() != 8)
    	{

    		GL11.glColor4f(1.0F, 1.0F, 1.0F, (float)par1EntityHisou.getNum() * 0.125F);
    		//GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
    	}
    	
        modelHisou.render(par1EntityHisou, 0.0F, 0.0F, -0.1F, 0.0F, 0.0F, 0.0625F);
    	GL11.glDisable(GL11.GL_BLEND);
    	//GL11.glEnable(GL11.GL_LIGHTING);
        GL11.glPopMatrix();
    }

    /**
     * Actually renders the given argument. This is a synthetic bridge method, always casting down its argument and then
     * handing it off to a worker function which does the actual work. In all probabilty, the class Render is generic
     * (Render<T extends Entity) and this method has signature public void doRender(T entity, double d, double d1,
     * double d2, float f, float f1). But JAD is pre 1.5 so doesn't do that.
     */
    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9)
    {
        renderHisou((EntityHisou)par1Entity, par2, par4, par6, par8, par9);
    }
}
