package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;


import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderHomingAmulet extends Render
{
	
	//ホーミングアミュレットの描画
	private Random random = new Random();

    public RenderHomingAmulet()
    {
    }

    public void doRenderHomingAmulet(EntityHomingAmulet entityHomingAmulet, double x, double y, double z,
            float yaw, float pitch)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
    	GL11.glEnable(GL11.GL_LIGHTING);
        //GL11.glEnable(32826 /*GL_RESCALE_NORMAL_EXT*/);
    	GL11.glEnable(GL11.GL_NORMALIZE);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
    	//GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);
        float size = 0.5F;
    	if(entityHomingAmulet.getShotColor() == 1)
    	{
    		size = 1.2F;
    	}
        GL11.glScalef(size, size, size);
        loadTexture("/textures/Amulet.png");
        Tessellator tessellator = Tessellator.instance;
    	float xLength = 0.5F;
    	double zLength = 0.5F;
    	float uMin = 0.0F;
    	float uMax = 0.5F;
    	float vMin = 0.0F;
    	float vMax = 1.0F;
    	
    	float angle = (float)Math.atan2(entityHomingAmulet.motionX, entityHomingAmulet.motionZ);
    	GL11.glRotatef(-entityHomingAmulet.rotationPitch, MathHelper.sin(angle), 0.0F, MathHelper.cos(angle));
    	GL11.glRotatef(180F - (float)entityHomingAmulet.getAmuletRotation(), 0.0F, 1.0F, 0.0F);
    	//GL11.glRotatef(-entityHomingAmulet.rotationPitch, 1.0F, 0.0F, 0.0F);
        //GL11.glRotatef(180F - entityHomingAmulet.rotationPitch, 0.0F, 1.0F, 0.0F);
        //GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
    	tessellator.startDrawingQuads();  
    	tessellator.setNormal(0.0F, 1.0F, 0.0F);
        tessellator.addVertexWithUV(-xLength, 0.0F,  zLength, uMin, vMin);
        tessellator.addVertexWithUV( xLength, 0.0F,  zLength, uMax, vMin);
        tessellator.addVertexWithUV( xLength, 0.0F, -zLength, uMax, vMax);
        tessellator.addVertexWithUV(-xLength, 0.0F, -zLength, uMin, vMax);
		tessellator.draw();
    	
    	size *= 1.1F;
    	GL11.glScalef(size, size, size);
    	
    	/*float motionX = (float)entityHomingAmulet.motionX;
    	float motionY = (float)entityHomingAmulet.motionY;
    	float motionZ = (float)entityHomingAmulet.motionZ;
    	GL11.glTranslatef((float)x - motionX, (float)y - motionY, (float)z - motionZ);*/
    	tessellator.startDrawingQuads();
    	tessellator.setColorRGBA_F(1.0F, 0.1F, 0.1F, 0.3F);
        tessellator.setNormal(0.0F, 1.0F, 0.0F);
        tessellator.addVertexWithUV(-xLength, 0.0F,  zLength, uMin, vMin);
        tessellator.addVertexWithUV( xLength, 0.0F,  zLength, uMax, vMin);
        tessellator.addVertexWithUV( xLength, 0.0F, -zLength, uMax, vMax);
        tessellator.addVertexWithUV(-xLength, 0.0F, -zLength, uMin, vMax);
		tessellator.draw();
        

    	
        //GL11.glDisable(32826 /*GL_RESCALE_NORMAL_EXT*/);
        GL11.glDisable(GL11.GL_BLEND);
    	GL11.glDisable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double x, double y, double z,
            float yaw, float pitch)
    {
        doRenderHomingAmulet((EntityHomingAmulet)entity, x, y, z, yaw, pitch);
    }
}
