package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderKinkakuzi extends Render
{
	
	//金閣寺の一枚天井を描画
	
    /** instance of ModelBoat for rendering */
    protected ModelBase modelBoat;

    public RenderKinkakuzi()
    {
        shadowSize = 10.5F;//多分影のサイズ
        modelBoat = new ModelKinkakuzi();
    }

    public void renderKinkakuzi(EntityKinkakuzi par1EntityKinkakuzi, double x, double y, double z, float par8, float par9)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glRotatef(180F - par8, 0.0F, 1.0F, 0.0F);
        float f = (float)par1EntityKinkakuzi.getTimeSinceHit() - par9;
        float f1 = (float)par1EntityKinkakuzi.getDamageTaken() - par9;

        if (f1 < 0.0F)
        {
            f1 = 0.0F;
        }

        if (f > 0.0F)
        {
            GL11.glRotatef(((MathHelper.sin(f) * f * f1) / 10F) * (float)par1EntityKinkakuzi.getForwardDirection(), 0.0F, 0.0F, 0.0F);
        }

        loadTexture("/terrain.png");
        loadTexture("/textures/Kinkakuzi.png");//テクスチャ画像を読み込み
        GL11.glScalef(3F, 1F, 3F);//倍率　縦方向 高さ　幅
        modelBoat.render(par1EntityKinkakuzi, 0.0F, 0.0F, -0.1F, 0.0F, 0.0F, 0.0625F);//最後の引数以外関係ない？　最後の引数は大きさの倍率
        GL11.glPopMatrix();
    }

    /**
     * Actually renders the given argument. This is a synthetic bridge method, always casting down its argument and then
     * handing it off to a worker function which does the actual work. In all probabilty, the class Render is generic
     * (Render<T extends Entity) and this method has signature public void doRender(T entity, double d, double d1,
     * double d2, float f, float f1). But JAD is pre 1.5 so doesn't do that.
     */
    public void doRender(Entity par1Entity, double par2, double par4, double par6, float par8, float par9)
    {
        renderKinkakuzi((EntityKinkakuzi)par1Entity, par2, par4, par6, par8, par9);
    }
}
