package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderMasterSpark extends Render
{
	
	/*
	マスタースパークの描画
	*/
	
	private Random random = new Random();

    public RenderMasterSpark()
    {
    }

    public void doRenderMasterSpark(EntityMasterSpark entityMasterSpark, double xpos, double ypos, double zpos,
            float yaw, float pitch)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)zpos);
    	//GL11.glDisable(GL11.GL_TEXTURE_2D);
		GL11.glDisable(GL11.GL_LIGHTING);
        //GL11.glEnable(32826 /*GL_RESCALE_NORMAL_EXT*/);
    	//GL11.glEnable(GL11.GL_NORMALIZE);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
    	GL11.glScalef(1.0F, 1.0F, 1.0F);
        loadTexture("/textures/MasterSpark.png");
        Tessellator tessellator = Tessellator.instance;
    	
    	double size =  0.01D;
    	double oldSize = 0.01D;
    	double sizeAdd = 0.3D;
    	float sizeRate = 0.49067F / 2.0F;
    	float xlength = (float)size * sizeRate;//(float)size / ( (float)(Math.sin(Math.PI/8.0F) - Math.cos(Math.PI/8.0F) ) + 0.5F) / 2.0F * sizeRate;
    	float oldxlength = (float)oldSize * sizeRate;//(float)oldSize / ((float)(Math.sin(Math.PI/8.0F) - Math.cos(Math.PI/8.0F) ) + 0.5F) / 2.0F * sizeRate;
    	double speed;// = entityMasterSpark.speed;
    	/*speed = (double)MathHelper.sqrt_double( entityMasterSpark.motionX * entityMasterSpark.motionX + entityMasterSpark.motionY * entityMasterSpark.motionY + entityMasterSpark.motionZ * entityMasterSpark.motionZ);
    	if(speed < 0.0)
    	{
    		speed *= -1.0;
    	}*/
    	double pi8 = Math.PI / 32.0D;
    	double nowAngle = 0.0D;
    	double angle = pi8;
    	//Random random = new Random();
    	//int rand = random.nextInt(7);
    	int c = entityMasterSpark.ticksExisted + entityMasterSpark.inicount ;
    	float constR[] = { 255F, 255F, 255F,   0F,   0F,  76F, 128F};
    	float constG[] = {   0F, 165F, 255F, 128F,   0F,   0F,   0F};
    	float constB[] = {   0F,   0F,   0F,   0F, 255F, 130F, 128F};
    	

    	
    	//GL11.glRotatef(entityMasterSpark.rotationPitch, -(float)Math.sin((entityMasterSpark.rotationYaw-90F)/180F * 3.141593F), 0.0F, (float)Math.cos((entityMasterSpark.rotationYaw-90F)/180F * 3.141593F));
    	speed = 0.5D;
    	Random rand = new Random();
    	double zPos = (double)rand.nextInt(100) / 100D;
    	double oldZPos = zPos;
    	float color;
    	double maxLength = entityMasterSpark.getMaxLength();
    	float colorRev = 3.141593F * 5.6125F / 180F;
    	float ticks = (float)entityMasterSpark.getIniTime()*10.0F;
    	float angle3 = (float)Math.atan2(entityMasterSpark.motionX * entityMasterSpark.motionX, entityMasterSpark.motionZ * entityMasterSpark.motionZ);//水平方向の角度rad
    	float angle2 = angle3 + 3.141593F / 2F;
    	float pitchRad = -(float)Math.atan2( entityMasterSpark.motionY, Math.sqrt(entityMasterSpark.motionX * entityMasterSpark.motionX + entityMasterSpark.motionZ * entityMasterSpark.motionZ));
    	float pitchDeg = pitchRad / 3.141593F * 180F;
    	//motionPitch = motionPitch % 90F;
    	//GL11.glRotatef(-pitchDeg, MathHelper.sin(angle2) * MathHelper.cos(pitchRad), 0.0F, MathHelper.cos(angle2) * MathHelper.cos(pitchRad));
    	//GL11.glRotatef(angle3 / 3.141593F * 180F, 0.0F, 1.0F, 0.0F);
    	
    	GL11.glRotatef(entityMasterSpark.rotationYaw, 0.0F, 1.0F, 0.0F);
    	//GL11.glRotatef(-entityMasterSpark.rotationPitch, MathHelper.sin(angle3), 0.0F, MathHelper.cos(angle3));
    	GL11.glRotatef(-entityMasterSpark.rotationPitch, 1.0F, 0.0F, 0.0F);
    	//GL11.glRotatef(pitchDeg, 1.0F, 0.0F, 0.0F);
    	//GL11.glRotatef((float)Math.sin(pi8*8F) / 3.141593F * 180F, 0.0F, 0.0F, 1.0F);
    	//while(zPos < maxLength)
    	while(size > 0.0D)
    	{
    		//size = 5.0D;
    		//oldSize = 5.0D;
    		for(int i = 0; i < 64; i++)
    		{
    			GL11.glRotatef(MathHelper.sin((float)pi8) / 3.141593F * 180F, 0.0F, 0.0F, 1.0F);
    			
	    		color = ((float)angle+(float)ticks) * colorRev;
    			
    			tessellator.startDrawingQuads();
	    		tessellator.setColorRGBA_F(0.5F, 0.5F, 0.5F, 0.2F);
	    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
	        	tessellator.addVertexWithUV( -xlength * 0.8F, size*0.8F, zPos, 0.0F, 1.0F);
	        	tessellator.addVertexWithUV(  xlength * 0.8F, size*0.8F, zPos, 0.5F, 1.0F);
	        	tessellator.addVertexWithUV(  oldxlength * 0.8F, oldSize*0.8F,   oldZPos, 0.5F, 0.5F);
	        	tessellator.addVertexWithUV( -oldxlength * 0.8F, oldSize*0.8F,   oldZPos, 0.0F, 0.5F);
	    		tessellator.draw();
    			
    			tessellator.startDrawingQuads();
	    		tessellator.setColorRGBA_F(0.5F, 0.5F, 0.5F, 0.3F);
	    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
	        	tessellator.addVertexWithUV( -xlength * 0.5F, size*0.5F, zPos, 0.0F, 1.0F);
	        	tessellator.addVertexWithUV(  xlength * 0.5F, size*0.5F, zPos, 0.5F, 1.0F);
	        	tessellator.addVertexWithUV(  oldxlength * 0.5F, oldSize*0.5F,   oldZPos, 0.5F, 0.5F);
	        	tessellator.addVertexWithUV( -oldxlength * 0.5F, oldSize*0.5F,   oldZPos, 0.0F, 0.5F);
	    		tessellator.draw();
    			
    			tessellator.startDrawingQuads();
    			tessellator.setColorRGBA_F(MathHelper.sin(color), MathHelper.cos(color), -MathHelper.sin(color)*2F, 0.99F);
	    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
	        	tessellator.addVertexWithUV( -xlength, size, zPos, 0.0F, 1.0F);
	        	tessellator.addVertexWithUV(  xlength, size, zPos, 0.5F, 1.0F);
	        	tessellator.addVertexWithUV(  oldxlength, oldSize,   oldZPos, 0.5F, 0.5F);
	        	tessellator.addVertexWithUV( -oldxlength, oldSize,   oldZPos, 0.0F, 0.5F);
	    		tessellator.draw();

    			angle+=1.0F;
    			nowAngle += pi8;
    			
	    		
	    		c++;
    		}
    		ticks++;
    		oldZPos = zPos;
    		zPos += speed;
    		if(zPos > maxLength)
    		{
    			if(sizeAdd < 0.3D)
    			{
    				sizeAdd += 0.01D;
    			}
    			size -= sizeAdd;
    		}
    		else if(entityMasterSpark.getIniTime() > 20)
    		{
    			oldSize = size;
    			if(size < 5.0D)
    			{
    				//size += 0.12D / size;
    				if(sizeAdd > 0.0D)
    				{
    					sizeAdd -= 0.01D;
    				}
    				//size += 1.0D + sizeAdd;
    				//size += 0.03D;
    				size += sizeAdd;
    				//size += 1F - (float)ticks/3F;
    				//size += 1F - (float)ticks/10F;
    			}
    			xlength = (float)size * sizeRate;//(float)size / ( (float)(Math.sin(Math.PI/8.0F) - Math.cos(Math.PI/8.0F) ) + 0.5F) / 2.0F * sizeRate;
    			oldxlength = (float)oldSize * sizeRate;//(float)oldSize / ((float)(Math.sin(Math.PI/8.0F) - Math.cos(Math.PI/8.0F) ) + 0.5F) / 2.0F * sizeRate;
    		}
    		else
    		{
    			oldSize = size;
    			if(size < 0.03D)
    			{
    				size += 0.01D;
    			}
    			xlength = (float)size * sizeRate;//(float)size / ( (float)(Math.sin(Math.PI/8.0F) - Math.cos(Math.PI/8.0F) ) + 0.5F) / 2.0F * 1.0F;
    			oldxlength = (float)size * sizeRate;//(float)oldSize / ((float)(Math.sin(Math.PI/8.0F) - Math.cos(Math.PI/8.0F) ) + 0.5F) / 2.0F * 1.0F;
    		}
    		
    	}
    	
    	GL11.glDisable(GL11.GL_BLEND);
        //GL11.glDisable(32826 /*GL_RESCALE_NORMAL_EXT*/);
    	GL11.glEnable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
    	//GL11.glEnable(GL11.GL_TEXTURE_2D);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double xpos, double ypos, double zpos,
            float yaw, float pitch)
    {
        doRenderMasterSpark((EntityMasterSpark)entity, xpos, ypos, zpos, yaw, pitch);
    }
}
