package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderMiniHakkero extends Render
{
	
   /*
   ミニ八卦炉の描画
   */
   
    /** instance of ModelBoat for rendering */
    protected ModelBase modelMiniHakkero,modelMiniHakkero2;

    public RenderMiniHakkero()
    {
        shadowSize = 0.5F;//多分影のサイズ
        modelMiniHakkero = new ModelMiniHakkero();
        modelMiniHakkero2 = new ModelMiniHakkero2();
    }

    /**
     * The render method used in RenderBoat that renders the boat model.
     */
    public void renderMiniHakkero(EntityMiniHakkero par1EntityMiniHakkero, double x, double y, double z, float par8, float par9)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
       GL11.glRotatef(par1EntityMiniHakkero.rotationPitch, -MathHelper.sin((par1EntityMiniHakkero.rotationYaw-90F)/180F * 3.141593F), 0.0F, MathHelper.cos((par1EntityMiniHakkero.rotationYaw-90F)/180F * 3.141593F));
       GL11.glRotatef(180F - par1EntityMiniHakkero.rotationYaw, 0.0F, 1.0F, 0.0F);

        loadTexture("/textures/MiniHakkeroTexture.png");//テクスチャ画像を読み込み
        GL11.glScalef(0.5F, 0.5F, 0.5F);//倍率　縦方向 高さ　幅
       modelMiniHakkero.render(par1EntityMiniHakkero, 0.0F, 0.0F, -0.1F, 0.0F, 0.0F, 0.0625F);
       GL11.glDisable(GL11.GL_LIGHTING);
       GL11.glEnable(GL11.GL_BLEND);
       GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);
       Tessellator tessellator = Tessellator.instance;
       float constR[] = { 255F, 255F, 255F,   0F,   0F,  76F, 128F};
       float constG[] = {   0F, 165F, 255F, 128F,   0F,   0F,   0F};
       float constB[] = {   0F,   0F,   0F,   0F, 255F, 130F, 128F};
       float u_min  = 0F;
       float v_min  = 0F;
       float u_max  = 1F / 2F;
       float v_max  = 1F / 4F;
       
       float angle = par1EntityMiniHakkero.getCircleAngle();
       float pi18 = (float)Math.PI / 9F;
       int c = par1EntityMiniHakkero.count;
       GL11.glRotatef(MathHelper.sin(angle) / 3.141593F * 180F, 0.0F, 0.0F, 1.0F);
       for(int i = 0; i < 19; i++)
       {
          //手前リング
          GL11.glRotatef(MathHelper.sin(pi18) / 3.141593F * 180F, 0.0F, 0.0F, 1.0F);
          tessellator.startDrawingQuads();
          tessellator.setColorRGBA_F(constR[c % 7]/255F * 0.5F,constG[c % 7]/255F * 0.5F, constB[c % 7]/255F * 0.5F, 0.6F);
          tessellator.addVertexWithUV(  0.77F,  4.5F, -6.0D, u_min, v_min);
           tessellator.addVertexWithUV( -0.77F,  4.5F, -6.0D, u_max, v_min);
           tessellator.addVertexWithUV( -0.77F,   4.5F,  -4.0, u_max, v_max);
           tessellator.addVertexWithUV(  0.77F,   4.5F,  -4.0D, u_min, v_max);
           tessellator.draw();
          tessellator.startDrawingQuads();
          tessellator.setColorRGBA_F(constR[c % 7]/255F * 0.5F,constG[c % 7]/255F * 0.5F, constB[c % 7]/255F * 0.5F, 0.6F);
           tessellator.addVertexWithUV( -0.77F,  4.5F, -6.0D, u_min, v_min);
           tessellator.addVertexWithUV(  0.77F,  4.5F, -6.0D, u_max, v_min);
           tessellator.addVertexWithUV(  0.77F,   4.5F,  -4.0D, u_max, v_max);
           tessellator.addVertexWithUV( -0.77F,   4.5F,  -4.0D, u_min, v_max);
          tessellator.draw();
          //奥リング
          tessellator.startDrawingQuads();
          tessellator.setColorRGBA_F(constR[(c+3) % 7]/255F * 0.5F,constG[(c+3) % 7]/255F * 0.5F, constB[(c+3) % 7]/255F * 0.5F, 0.6F);
          tessellator.addVertexWithUV(  1.11F,  6.5F, -12.0D, u_min, v_min);
           tessellator.addVertexWithUV( -1.11F,  6.5F, -12.0D, u_max, v_min);
           tessellator.addVertexWithUV( -1.11F,   6.5F, -10.0D, u_max, v_max);
           tessellator.addVertexWithUV(  1.11F,   6.5F, -10.0D, u_min, v_max);
           tessellator.draw();
          tessellator.startDrawingQuads();
          tessellator.setColorRGBA_F(constR[(c+3) % 7]/255F * 0.5F,constG[(c+3) % 7]/255F * 0.5F, constB[(c+3) % 7]/255F * 0.5F, 0.6F);
           tessellator.addVertexWithUV( -1.11F,  6.5F, -12.0D, u_min, v_min);
           tessellator.addVertexWithUV(  1.11F,  6.5F, -12.0D, u_max, v_min);
           tessellator.addVertexWithUV(  1.11F,   6.5F, -10.0D, u_max, v_max);
           tessellator.addVertexWithUV( -1.11F,   6.5F, -10.0D, u_min, v_max);
           tessellator.draw();
          angle += pi18;
       }
       
        
       GL11.glDisable(GL11.GL_BLEND);
       GL11.glEnable(GL11.GL_LIGHTING);
        GL11.glPopMatrix();
    }
    
    
    public void renderMiniHakkero2(EntityMiniHakkero par1EntityMiniHakkero, double x, double y, double z, float par8, float par9)
    {
       GL11.glPushMatrix();
       GL11.glTranslatef((float)x, (float)y, (float)z);
       GL11.glRotatef(par1EntityMiniHakkero.rotationPitch, -MathHelper.sin((par1EntityMiniHakkero.rotationYaw-90F)/180F * 3.141593F), 0.0F, MathHelper.cos((par1EntityMiniHakkero.rotationYaw-90F)/180F * 3.141593F));
       GL11.glRotatef(180F - par1EntityMiniHakkero.rotationYaw, 0.0F, 1.0F, 0.0F);

        loadTexture("/textures/MiniHakkeroTexture.png");//テクスチャ画像を読み込み
        
        //ずらした部分はここの倍率を変えて補う
        GL11.glScalef(0.501F, 0.501F, 0.501F);//倍率　縦方向 高さ　幅
       
       //modelMiniHakkero2.render(par1EntityMiniHakkero, 0.0F, 0.0F, -0.1F, 0.0F, 0.0F, 0.0625F);
    	modelMiniHakkero2.render(par1EntityMiniHakkero, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0625F);
       GL11.glDisable(GL11.GL_LIGHTING);
       GL11.glEnable(GL11.GL_BLEND);
       GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);
       Tessellator tessellator = Tessellator.instance;
       
        GL11.glPopMatrix();
    }

    /**
     * Actually renders the given argument. This is a synthetic bridge method, always casting down its argument and then
     * handing it off to a worker function which does the actual work. In all probabilty, the class Render is generic
     * (Render<T extends Entity) and this method has signature public void doRender(T entity, double d, double d1,
     * double d2, float f, float f1). But JAD is pre 1.5 so doesn't do that.
     */
    public void doRender(Entity par1Entity, double x, double y, double z, float par8, float par9)
    {
        renderMiniHakkero ((EntityMiniHakkero)par1Entity, x, y, z, par8, par9);
        renderMiniHakkero2((EntityMiniHakkero)par1Entity, x, y, z, par8, par9);
    }
}
