package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderMiracleCircle extends Render
{
	
	//ミラクルサークルの描画
	private Random random = new Random();

    public RenderMiracleCircle()
    {
    }

    public void doRenderMiracleCircle(EntityMiracleCircle entityMiracleCircle, double x, double y, double z,
            float f, float f1)
    {
    	//紫、黄、赤、青、緑
    	float colorR[] = {0.7F, 0.7F, 0.9F, 0.3F, 0.2F};
    	float colorG[] = {0.1F, 0.7F, 0.1F, 0.3F, 0.9F};
    	float colorB[] = {0.9F, 0.1F, 0.2F, 0.9F, 0.2F};
    	//int color = (int)(entityMiracleCircle.ticksExisted / 1000000);//entityMiracleCircle.getColorPattern();
    	int color = entityMiracleCircle.getColor();
    	
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
    	//GL11.glDisable(GL11.GL_TEXTURE_2D);
    	GL11.glEnable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_NORMALIZE);
        //GL11.glEnable(32826 /*GL_RESCALE_NORMAL_EXT*/);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
        GL11.glScalef(1.0F, 1.0F, 1.0F);
    	
        loadTexture("/textures/MiracleCircle.png");
        Tessellator tessellator = Tessellator.instance;
    	GL11.glRotatef(180F - renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
    	GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
    	GL11.glRotatef(entityMiracleCircle.turnAngle, 0.0F, 0.0F, 1.0F);
    	
    	int i, j;
    	float umin = 0.5F;
    	float umax = 0.625F;
    	float vmin = 0.0F;
    	float vmax = 1.0F;
    	float angle = -108F;
    	float length = 3.0F;
    	float width = 0.10F;
    	float py =  length / (2.0F * MathHelper.cos(0.3141593F) );
    	float px = 0F;//-length / 2F;
    	float nextpx = px + MathHelper.cos(angle / 180F * 3.141593F) * length;
    	float nextpy = py + MathHelper.sin(angle / 180F * 3.141593F) * length;
    	float widthX;
    	float widthY;
    	float nextY;
    	double zbuf;
    	int lastLine = entityMiracleCircle.getNumberOfDrewLine() - 1;
    	int starNum = color;
    	j = color;

    	//最後の１本を除く線を描く
    	for(i = 0; i < lastLine; i++)
    	{
    		zbuf = 0.001D * (double)i;
    		widthX = MathHelper.cos( (angle+90F) / 180F * 3.141593F) * width;
    		widthY = MathHelper.sin( (angle+90F) / 180F * 3.141593F) * width;
    		tessellator.startDrawingQuads();
    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
    		tessellator.setColorRGBA_F(colorR[j], colorG[j], colorB[j], 0.5F);
        	tessellator.addVertexWithUV( px - widthX,  py - widthY,       zbuf, umin, vmax);
        	tessellator.addVertexWithUV( px + widthX,  py + widthY,       zbuf, umax, vmax);
        	tessellator.addVertexWithUV( nextpx + widthX,  nextpy + widthY, zbuf, umax, vmin);
        	tessellator.addVertexWithUV( nextpx - widthX,  nextpy - widthY, zbuf, umin, vmin);
        	tessellator.draw();
    		angle += 144F;
    		px = nextpx;
    		py = nextpy;
    		nextpx = px + MathHelper.cos(angle / 180F * 3.141593F) * length;
    		nextpy = py + MathHelper.sin(angle / 180F * 3.141593F) * length;
    	}
    	//最後の1本
    		float lastLineLength = length * (float)entityMiracleCircle.getLastLineTime() / 10F;
    	    nextpx = px + MathHelper.cos(angle / 180F * 3.141593F) * lastLineLength;
    		nextpy = py + MathHelper.sin(angle / 180F * 3.141593F) * lastLineLength;
    	    zbuf = 0.001D * (double)i;
    		widthX = MathHelper.cos( (angle+90F) / 180F * 3.141593F) * width;
    		widthY = MathHelper.sin( (angle+90F) / 180F * 3.141593F) * width;
    		tessellator.startDrawingQuads();
    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
    		tessellator.setColorRGBA_F(colorR[j], colorG[j], colorB[j], 0.5F);
        	tessellator.addVertexWithUV( px - widthX,  py - widthY,       zbuf, umin, vmax);
        	tessellator.addVertexWithUV( px + widthX,  py + widthY,       zbuf, umax, vmax);
        	tessellator.addVertexWithUV( nextpx + widthX,  nextpy + widthY, zbuf, umax, vmin);
        	tessellator.addVertexWithUV( nextpx - widthX,  nextpy - widthY, zbuf, umin, vmin);
        	tessellator.draw();
    	
        //GL11.glDisable(32826 /*GL_RESCALE_NORMAL_EXT*/);
        GL11.glDisable(GL11.GL_BLEND);
    	GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
        GL11.glDisable(GL11.GL_LIGHTING);
    	//GL11.glEnable(GL11.GL_TEXTURE_2D);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double x, double y, double z,
            float f, float f1)
    {
        doRenderMiracleCircle((EntityMiracleCircle)entity, x, y, z, f, f1);
    }
}
