package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderMusouFuuin extends Render
{
	
	//夢想封印の光弾の描画
	private Random random = new Random();

    public RenderMusouFuuin()
    {
    }

    public void doRenderMusouFuuin(EntityMusouFuuin entityMusouFuuin, double d, double d1, double d2,
            float f, float f1)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)d, (float)d1, (float)d2);
		GL11.glDisable(GL11.GL_LIGHTING);
    	//GL11.glEnable(GL11.GL_NORMALIZE);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
    	float size = entityMusouFuuin.getShotSize();
        GL11.glScalef(size, size, size);
        loadTexture("/textures/MusouFuuin.png");
        Tessellator tessellator = Tessellator.instance;
    	
    	int color = entityMusouFuuin.getShotColor();
    	float colorR[] = { 255F, 255F, 255F,   0F,   0F,   0F, 255F};
    	float colorG[] = {   0F, 165F, 255F, 255F,   0F, 255F,   0F};
    	float colorB[] = {   0F,   0F,   0F,   0F, 255F, 255F, 255F};
    	int pattern = entityMusouFuuin.ticksExisted % 2;
        float umin = (float)((pattern % 32) * 32 + 0) / 64F;
        float umax = (float)((pattern % 32) * 32 + 32) / 64F;
        float vmin = 0.0F;//(float)((color / 16) * 16 + 0) / 32F;
        float vmax = 1.0F;//(float)((color / 16) * 16 + 16) / 32F;
    	
        GL11.glRotatef(180F - renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
        GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
    	int randColor = random.nextInt(7);
    	
    	tessellator.startDrawingQuads();
    	tessellator.setColorRGBA_F(colorR[randColor], colorG[randColor], colorB[randColor], 0.3F);
        tessellator.setNormal(0.0F, 1.0F, 0.0F);
        tessellator.addVertexWithUV(-0.6F, -0.6F, 0.0D, umin, vmax);
        tessellator.addVertexWithUV( 0.6F, -0.6F, 0.0D, umax, vmax);
        tessellator.addVertexWithUV( 0.6F,  0.6F, 0.0D, umax, vmin);
        tessellator.addVertexWithUV(-0.6F,  0.6F, 0.0D, umin, vmin);
        tessellator.draw();
        tessellator.startDrawingQuads();
    	tessellator.setColorRGBA_F(colorR[color], colorG[color], colorB[color], 0.7F);
        tessellator.setNormal(0.0F, 1.0F, 0.0F);
        tessellator.addVertexWithUV(-0.5F, -0.5F, 0.001D, umin, vmax);
        tessellator.addVertexWithUV( 0.5F, -0.5F, 0.001D, umax, vmax);
        tessellator.addVertexWithUV( 0.5F,  0.5F, 0.001D, umax, vmin);
        tessellator.addVertexWithUV(-0.5F,  0.5F, 0.001D, umin, vmin);
        tessellator.draw();
    	tessellator.startDrawingQuads();
    	tessellator.setColorRGBA_F(1.0F, 1.0F, 1.0F, 0.9F);
        tessellator.setNormal(0.0F, 1.0F, 0.0F);
        tessellator.addVertexWithUV(-0.4F, -0.4F, 0.002D, umin, vmax);
        tessellator.addVertexWithUV( 0.4F, -0.4F, 0.002D, umax, vmax);
        tessellator.addVertexWithUV( 0.4F,  0.4F, 0.002D, umax, vmin);
        tessellator.addVertexWithUV(-0.4F,  0.4F, 0.002D, umin, vmin);
        tessellator.draw();
    	
    	GL11.glDisable(GL11.GL_BLEND);
    	GL11.glEnable(GL11.GL_LIGHTING);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double d, double d1, double d2,
            float f, float f1)
    {
        doRenderMusouFuuin((EntityMusouFuuin)entity, d, d1, d2, f, f1);
    }
}
