package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderPendulum extends Render
{
	
	//ナズーリンペンデュラムの描画

    public RenderPendulum()
    {
        shadowSize = 0.5F;//多分影のサイズ
    }

    /**
     * The render method used in RenderBoat that renders the boat model.
     */
    public void renderPendulum(EntityPendulum par1EntityPendulum, double x, double y, double z, float par8, float par9)
    {
    	GL11.glPushMatrix();
    	float rotationLength = (float)par1EntityPendulum.getSearchCount() /8.0F;
    	float xDrawPos =  -MathHelper.sin(par1EntityPendulum.getSearchAngle() / 180F * 3.141593F) * rotationLength;
    	float zDrawPos =   MathHelper.cos(par1EntityPendulum.getSearchAngle() / 180F * 3.141593F) * rotationLength;
        GL11.glTranslatef(	(float)x + xDrawPos,
        					(float)y,
        					(float)z + zDrawPos);
    	
    	GL11.glEnable(GL11.GL_LIGHTING);
    	//GL11.glEnable(GL11.GL_NORMALIZE);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
    	
    	GL11.glRotatef(180F - par8, 0.0F, 1.0F, 0.0F);

    	int i, j;
    	
    	float u_min = 16F/64F;
    	float v_min = 20F/32F;
    	float u_max = 28F/64F;
    	float v_max = 32F/32F;
    	
    	float top_p1_u = 12F/64F;
    	float top_p1_v =  4F/32F;
    	float top_p2_u =  1F/64F;
    	float top_p2_v = 19F/32F;
    	float top_p3_u = 22F/64F;
    	float top_p3_v = 19F/32F;
    	
    	float down_p1_u = 33F/64F;
    	float down_p1_v =  0F/32F;
    	float down_p2_u = 55F/64F;
    	float down_p2_v =  0F/32F;
    	float down_p3_u = 44F/64F;
    	float down_p3_v = 31F/32F;
        //loadTexture("/terrain.png");
    	Tessellator tessellator = Tessellator.instance;
        float rate = 0.2F;
        GL11.glScalef(rate, rate, rate);
        loadTexture("/textures/PendulumTexture.png");//テクスチャ画像を読み込み
    	//tessellator.setColorRGBA_F(1.0F, 0.0F, 0.0F, 1.0F);


    	for(i = 0; i < 4; i++)
    	{
    		GL11.glRotatef(90F, 0.0F, 1.0F, 0.0F);
    		tessellator.startDrawingQuads();
		    tessellator.addVertexWithUV( 0.0F,  1.75F,  0.0D, top_p1_u, top_p1_v);
	        tessellator.addVertexWithUV( 0.0F,  1.75F,  0.0D, top_p1_u, top_p1_v);
	        tessellator.addVertexWithUV( 0.3F,  1.25F, -0.3D, top_p3_u, top_p3_v);
	        tessellator.addVertexWithUV(-0.3F,  1.25F, -0.3D, top_p2_u, top_p2_v);
	        tessellator.draw();
    		tessellator.startDrawingQuads();
		    tessellator.addVertexWithUV(-0.3F,  1.25F, -0.3D, down_p1_u, down_p1_v);
	        tessellator.addVertexWithUV( 0.3F,  1.25F, -0.3D, down_p2_u, down_p2_v);
	        tessellator.addVertexWithUV( 0.0F,  0.25F,  0.0D, down_p3_u, down_p3_v);
	        tessellator.addVertexWithUV( 0.0F,  0.25F,  0.0D, down_p3_u, down_p3_v);
	        tessellator.draw();
    	}
    	GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
    	for(i = 0; i < 4; i++)
    	{
    		GL11.glRotatef(45F, 0.0F, 1.0F, 0.0F);
    		tessellator.startDrawingQuads();
			tessellator.addVertexWithUV(-0.2F,  1.90F,  0.0D, u_min, v_max);
	    	tessellator.addVertexWithUV( 0.2F,  1.90F,  0.0D, u_max, v_max);
	    	tessellator.addVertexWithUV( 0.2F,  1.60F,  0.0D, u_max, v_min);
	    	tessellator.addVertexWithUV(-0.2F,  1.60F,  0.0D, u_min, v_min);
	    	tessellator.draw();
    	}
    	GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
        //GL11.glScalef(0.2F, 0.1F, 0.2F);//倍率　縦方向 高さ　幅
        //modelPendulum.render(par1EntityPendulum, 0.0F, 0.0F, -0.1F, 0.0F, 0.0F, 0.0625F);//最後の引数以外関係ない？　最後の引数は大きさの倍率
    	
    	GL11.glDisable(GL11.GL_BLEND);
        GL11.glDisable(GL11.GL_LIGHTING);
    	
        GL11.glPopMatrix();
    }

    /**
     * Actually renders the given argument. This is a synthetic bridge method, always casting down its argument and then
     * handing it off to a worker function which does the actual work. In all probabilty, the class Render is generic
     * (Render<T extends Entity) and this method has signature public void doRender(T entity, double d, double d1,
     * double d2, float f, float f1). But JAD is pre 1.5 so doesn't do that.
     */
    public void doRender(Entity par1Entity, double x, double y, double z, float par8, float par9)
    {
        renderPendulum((EntityPendulum)par1Entity, x, y, z, par8, par9);
    }
}
