package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

@SideOnly(Side.CLIENT)
public class RenderSilverKnife extends Render
{
	
	//銀のナイフの描画
	
    protected ModelBase modelSilverKnife;

    public RenderSilverKnife()
    {
        shadowSize = 0.3F;//多分影のサイズ
        modelSilverKnife = new ModelSilverKnife();
    }

    public void renderSilverKnife(EntitySilverKnife entitySilverKnife, double x, double y, double z, float yaw, float pitch)
    {

        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
    	GL11.glRotatef( 180F - entitySilverKnife.rotationYaw,   0F, 1F, 0F);
    	GL11.glRotatef(-entitySilverKnife.rotationPitch, 1F, 0F, 0F);
    	GL11.glRotatef( entitySilverKnife.getKnifeZAngle(), 0F, 0F, 1F);

    	switch(entitySilverKnife.getKnifeColor())
    	{
    		case 0:
        		loadTexture("/textures/SilverKnifeTexture.png");
    			break;
    		case 1:
    			loadTexture("/textures/SilverKnifeTexture2.png");
    			break;
    		case 2:
    			loadTexture("/textures/SilverKnifeTexture3.png");
    			break;
    		default:
    			loadTexture("/textures/SilverKnifeTexture4.png");
    			break;
    	}
    	GL11.glScalef(0.5F, 0.5F, 0.5F);//倍率　縦方向 高さ　幅
		//modelSilverKnife.render(entitySilverKnife, 0.0F, 0.0F, -0.1F, 0.0F, 0.0F, 0.0625F);
    	//最後の引数がサイズの倍率
    	modelSilverKnife.render(entitySilverKnife, 0.0F, 0.0F, -0.1F, 0.0F, 0.0F, 0.0625F);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double x, double y, double z, float yaw, float pitch)
    {
        renderSilverKnife((EntitySilverKnife)entity, x, y, z, yaw, pitch);
    }
}
