package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderSpellCard extends Render
{
	
	//スペルカードの描画
	private Random random = new Random();

    public RenderSpellCard()
    {
    }

    public void doRenderSpellCard(EntitySpellCard entitySpellCard, double x, double y, double z,
            float f, float f1)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
    	GL11.glDisable(GL11.GL_LIGHTING);
        GL11.glEnable(32826 /*GL_RESCALE_NORMAL_EXT*/);
        float sizeRate = 1.0F;
        GL11.glScalef(sizeRate, sizeRate, sizeRate);
    	int cardNo = entitySpellCard.getSpellCardNumber();
    	String cardName = "/textures/items/spellCard/" + cardNo + ".png";
        loadTexture(cardName);
        Tessellator tessellator = Tessellator.instance;
    	int color2 = 0;
    	float rvl = 14F / 128F;
    	float rul = 0.0F;
    	float rvr = 114F/ 128F;
    	float rur = 1.00F;
    	float fvl = 0.25F;
    	float ful = 0.0F;
    	float fvr = 0.50F;
    	float fur = 0.75F;
    	GL11.glRotatef((float)entitySpellCard.ticksExisted * 21F, 0.0F, 1.0F, 0.0F);
    	GL11.glRotatef(30F, 0.0F, 0.0F, 1.0F);
    	
    	//裏面
    	tessellator.startDrawingQuads();
    	tessellator.setNormal(0.0F, 1.0F, 0.0F);
        tessellator.addVertexWithUV(  0.2F,  0.3F, 0.0D, rvl, rul);
        tessellator.addVertexWithUV( -0.2F,  0.3F, 0.0D, rvr, rul);
        tessellator.addVertexWithUV( -0.2F, -0.3F, 0.0D, rvr, rur);
        tessellator.addVertexWithUV(  0.2F, -0.3F, 0.0D, rvl, rur);
        tessellator.draw();
    	//表面
    	tessellator.startDrawingQuads();
    	tessellator.setNormal(0.0F, 1.0F, 0.0F);
        tessellator.addVertexWithUV( -0.2F,  0.3F, 0.0D, rvl, rul);
        tessellator.addVertexWithUV(  0.2F,  0.3F, 0.0D, rvr, rul);
        tessellator.addVertexWithUV(  0.2F, -0.3F, 0.0D, rvr, rur);
        tessellator.addVertexWithUV( -0.2F, -0.3F, 0.0D, rvl, rur);
        tessellator.draw();

        GL11.glDisable(32826 /*GL_RESCALE_NORMAL_EXT*/);
        GL11.glEnable(GL11.GL_LIGHTING);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double x, double y, double z,
            float f, float f1)
    {
        doRenderSpellCard((EntitySpellCard)entity, x, y, z, f, f1);
    }
}
