package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderTHLaser extends Render
{
	
	/*
	通常レーザーの描画
	*/
	
	private Random random = new Random();

    public RenderTHLaser()
    {
    }

    public void doRenderTHLaser(EntityTHLaser entityTHLaser, double xpos, double ypos, double zpos,
            float yaw, float pitch)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xpos, (float)ypos, (float)zpos);
		GL11.glDisable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
    	GL11.glScalef(1.0F, 1.0F, 1.0F);
        loadTexture("/textures/Laser.png");
        Tessellator tessellator = Tessellator.instance;
    	
    	int color = entityTHLaser.getShotColor();
    	float colorR[] = { 255F, 255F, 255F,   0F,   0F,   0F, 255F};
    	float colorG[] = {   0F, 165F, 255F, 255F,   0F, 255F,   0F};
    	float colorB[] = {   0F,   0F,   0F,   0F, 255F, 255F, 255F};
    	double size =  0.0D;
    	double oldSize = 0.0D;
    	float sizeRate = 0.49067F / 2.0F;
    	double maxSize = entityTHLaser.getShotSize();
    	float xlength = (float)size * sizeRate;
    	float oldxlength = (float)oldSize * sizeRate;
    	int zAngleDivNum = 16;//Z軸回転の分割数
    	double angleSpanZ = Math.PI / (double)zAngleDivNum * 2.0D;
    	double angle = angleSpanZ;
    	
    	int zDivNum = 19;//レーザーの奥方向への分割数。必ず奇数
    	double zLength = entityTHLaser.getLaserLength();//レーザーの長さ（Z方向の長さ）
    	double zDivLength = zLength / (double)(zDivNum - 1);//Z方向へ分割したときの1分割分の長さ
    	double zLength2 = zLength / 2.0D;//長さの半分
    	double zPos = -zLength2 + zDivLength;//奥行き方向の現在の描画位置
    	double oldZPos = -zLength2;//ひとつ前の描画位置
    	
    	GL11.glRotatef(entityTHLaser.rotationYaw, 0.0F, 1.0F, 0.0F);
    	GL11.glRotatef(-entityTHLaser.rotationPitch, 1.0F, 0.0F, 0.0F);

    	zPos += zDivLength * 3.0D;
    	
    	while(zPos < zLength2 - zDivLength * 4.0D)
    	{
    		xlength = (float)size * sizeRate;
    		oldxlength = (float)oldSize * sizeRate;
    		for(int i = 0; i < zAngleDivNum; i++)
    		{
    			GL11.glRotatef((float)(MathHelper.sin((float)angleSpanZ) / Math.PI * 180.0D), 0.0F, 0.0F, 1.0F);
    			//GL11.glRotatef((float)nowAngle, 0.0F, 0.0F, 1.0F);
	    		//color = ((float)angle+(float)ticks) * colorRev;
	    		tessellator.startDrawingQuads();
	    		tessellator.setColorRGBA_F(colorR[color], colorG[color], colorB[color], 0.9F);
	    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
	        	tessellator.addVertexWithUV( -xlength, size, zPos, 0.0F, 1.0F);
	        	tessellator.addVertexWithUV(  xlength, size, zPos, 0.5F, 1.0F);
	        	tessellator.addVertexWithUV(  oldxlength, oldSize,   oldZPos, 0.5F, 0.5F);
	        	tessellator.addVertexWithUV( -oldxlength, oldSize,   oldZPos, 0.0F, 0.5F);
	    		tessellator.draw();
	    			
	    		tessellator.startDrawingQuads();
	    		tessellator.setColorRGBA_F(0.5F, 0.5F, 0.5F, 0.2F);
	    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
	        	tessellator.addVertexWithUV( -xlength * 0.8F, size*0.8F, zPos, 0.0F, 1.0F);
	        	tessellator.addVertexWithUV(  xlength * 0.8F, size*0.8F, zPos, 0.5F, 1.0F);
	        	tessellator.addVertexWithUV(  oldxlength * 0.8F, oldSize*0.8F,   oldZPos, 0.5F, 0.5F);
	        	tessellator.addVertexWithUV( -oldxlength * 0.8F, oldSize*0.8F,   oldZPos, 0.0F, 0.5F);
	    		tessellator.draw();
	    			
	    		tessellator.startDrawingQuads();
	    		tessellator.setColorRGBA_F(0.5F, 0.5F, 0.5F, 0.3F);
	    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
	        	tessellator.addVertexWithUV( -xlength * 0.5F, size*0.5F, zPos, 0.0F, 1.0F);
	        	tessellator.addVertexWithUV(  xlength * 0.5F, size*0.5F, zPos, 0.5F, 1.0F);
	        	tessellator.addVertexWithUV(  oldxlength * 0.5F, oldSize*0.5F,   oldZPos, 0.5F, 0.5F);
	        	tessellator.addVertexWithUV( -oldxlength * 0.5F, oldSize*0.5F,   oldZPos, 0.0F, 0.5F);
	    		tessellator.draw();
    			angle+=1.0F;
    		}
    		oldZPos = zPos;
    		oldSize = maxSize * ( 1.0 - 4.0 * zPos * zPos / zLength );
    		zPos += zDivLength;
    		size = maxSize * ( 1.0 - 4.0 * zPos * zPos / zLength );
    		
    	}
    	
    	GL11.glDisable(GL11.GL_BLEND);
        //GL11.glDisable(32826 /*GL_RESCALE_NORMAL_EXT*/);
    	GL11.glEnable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
    	//GL11.glEnable(GL11.GL_TEXTURE_2D);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double xpos, double ypos, double zpos,
            float yaw, float pitch)
    {
        doRenderTHLaser((EntityTHLaser)entity, xpos, ypos, zpos, yaw, pitch);
    }
}
