package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderTHShot extends Render
{
	
	//弾の描画
	private Random random = new Random();
	float colorR[] = { 255F,   0F,   0F, 255F, 255F,   0F, 255F, 255F};
    float colorG[] = {   0F,   0F, 255F, 255F,   0F, 255F, 165F, 255F};
    float colorB[] = {   0F, 255F,   0F,   0F, 255F, 255F,   0F, 255F};

    public RenderTHShot()
    {
    }

    public void doRenderTHShot(EntityTHShot entityTHShot, double x, double y, double z,
            float f, float f1)
    {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
    	GL11.glDisable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_NORMALIZE);
    	GL11.glEnable(GL11.GL_BLEND);
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
    	GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE);
    	float size = entityTHShot.getShotSize();
    	float size2;
        Tessellator tessellator = Tessellator.instance;
    	int color = entityTHShot.getShotColor();
    	if(color < 24 || color >= 240)
    	{
    		GL11.glScalef(size, size, size);
    		if(color >= 240)
    		{
    			size2 = size * 1.5F;
    			GL11.glScalef(size2, size2, size2);
    		}
    		GL11.glRotatef(180F - renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
        	GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
    		renderNormalShot(tessellator, color);
    	}
    	else if(color < 32)
    	{
    		GL11.glScalef(size, size, size);
    		float angle = (float)Math.atan2(entityTHShot.motionX, entityTHShot.motionZ) + 3.141593F / 2F;
    		float motionPitch = (float)Math.atan2( entityTHShot.motionY, Math.sqrt(entityTHShot.motionX * entityTHShot.motionX + entityTHShot.motionZ * entityTHShot.motionZ)) / 3.141593F * 180F;
    		motionPitch = motionPitch % 90F;
    		GL11.glRotatef(-motionPitch, MathHelper.sin(angle), 0.0F, MathHelper.cos(angle));
    		GL11.glRotatef( f, 0.0F, 1.0F, 0.0F);
    		renderScaleShot(tessellator, color);
    		GL11.glPopMatrix();//行列を元に戻す
    		
    		GL11.glPushMatrix();
    		GL11.glTranslatef((float)x, (float)y, (float)z);
    		GL11.glRotatef(180F - renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
        	GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
    		float size3 = size * 0.9F;
    		GL11.glScalef(size3, size3, size3);
    		renderNormalShot(tessellator, color % 8);
    	}
    	else if(color < 40)
    	{
    		size2 = size * 2.0F;
    		GL11.glScalef(size2, size2, size2);
    		float wingAngle = MathHelper.sin((float)entityTHShot.ticksExisted / 3.0F) * 45F;
    		float pitch = entityTHShot.rotationPitch;
    		if(pitch > 90F)
    		{
    			pitch = 90F - pitch % 90F;
    		}
    		else if(pitch < -90F)
    		{
    			pitch = -90F - pitch % 90F;
    		}
    		GL11.glRotatef(f, 0.0F, 1.0F, 0.0F);
    		GL11.glRotatef(-pitch, 1.0F, 0.0F, 0.0F);
    		GL11.glRotatef(wingAngle, 0.0F, 0.0F, 1.0F);
    		renderButterflyShot(tessellator, color, wingAngle);
    	}
    	else if(color < 48)
    	{
    		GL11.glScalef(size, size, size);
    		GL11.glRotatef(180F - renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
        	GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
    		int count = entityTHShot.ticksExisted % 2;
    		renderLightShot(tessellator, color, entityTHShot);
    	}
    	else
    	{
    		//GL11.glRotatef(f, 0.0F, 1.0F, 0.0F);
    		//GL11.glRotatef(90F, 1.0F, 0.0F, 0.0F);
        	//GL11.glRotatef((float)entityTHShot.ticksExisted * 3.7F, 0.0F, 0.0F, 1.0F);
    		GL11.glScalef(size, size, size);
    		GL11.glRotatef(180F - renderManager.playerViewY, 0.0F, 1.0F, 0.0F);
        	GL11.glRotatef(-renderManager.playerViewX, 1.0F, 0.0F, 0.0F);
    		GL11.glRotatef((float)entityTHShot.ticksExisted * 3.7F, 0.0F, 0.0F, 1.0F);
    		renderStarShot(tessellator, color);
    	}

        GL11.glDisable(GL11.GL_BLEND);
        GL11.glEnable(GL11.GL_LIGHTING);
        GL11.glPopMatrix();
    }
	
	//円形弾の描画
	public void renderNormalShot(Tessellator tessellator, int color)
	{
		loadTexture("/textures/Shot.png");
		if(color >= 240)
		{
			float f3 = (float)((color % 16) * 32 +  0) / 256F;
	        float f4 = (float)((color % 16) * 32 + 32) / 256F;
	        float f5 = (float)((color / 16) * 32 +  0) / 256F;
	        float f6 = (float)((color / 16) * 32 + 32) / 256F;
	        float f7 = 1.0F;
	        float f8 = 0.5F;
	        float f9 = 0.25F;
	        tessellator.startDrawingQuads();
	        tessellator.setNormal(0.0F, 1.0F, 0.0F);
	        tessellator.addVertexWithUV(0.0F - f8, 0.0F - f9, 0.0D, f3, f6);
	        tessellator.addVertexWithUV(f7 - f8, 0.0F - f9, 0.0D, f4, f6);
	        tessellator.addVertexWithUV(f7 - f8, 1.0F - f9, 0.0D, f4, f5);
	        tessellator.addVertexWithUV(0.0F - f8, 1.0F - f9, 0.0D, f3, f5);
			tessellator.draw();
		}
		else
		{
			float f3 = (float)((color % 16) * 16 +  0) / 256F;
	        float f4 = (float)((color % 16) * 16 + 16) / 256F;
	        float f5 = (float)((color / 16) * 16 +  0) / 256F;
	        float f6 = (float)((color / 16) * 16 + 16) / 256F;
	        float f7 = 1.0F;
	        float f8 = 0.5F;
	        float f9 = 0.25F;
	        tessellator.startDrawingQuads();
	        tessellator.setNormal(0.0F, 1.0F, 0.0F);
	        tessellator.addVertexWithUV(0.0F - f8, 0.0F - f9, 0.0D, f3, f6);
	        tessellator.addVertexWithUV(f7 - f8, 0.0F - f9, 0.0D, f4, f6);
	        tessellator.addVertexWithUV(f7 - f8, 1.0F - f9, 0.0D, f4, f5);
	        tessellator.addVertexWithUV(0.0F - f8, 1.0F - f9, 0.0D, f3, f5);
			tessellator.draw();
		}
	}
	
	//光のエフェクトの描画
	public void renderLightShot(Tessellator tessellator, int color, EntityTHShot entityTHShot)
	{
		loadTexture("/textures/MusouFuuin.png");
		color %= 8;
		int count = entityTHShot.ticksExisted % 2;
		float size = entityTHShot.getShotSize();
		float f3 = (float)(count * 32 +  0) / 64F;
	    float f4 = (float)(count * 32 + 32) / 64F;
	    float f5 = 0F;
	    float f6 = 1F;
	    float f7 = 1.0F;
	    float f8 = 0.5F;
	    float f9 = 0.25F;
		float size2 = size * 3.6F;
		GL11.glScalef(size2, size2, size2);
	    tessellator.startDrawingQuads();
	    tessellator.setNormal(0.0F, 1.0F, 0.0F);
		tessellator.setColorRGBA_F(colorR[color]/255F, colorG[color]/255F, colorB[color]/255F, 0.5F);
	    tessellator.addVertexWithUV(0.0F - f8, 0.0F - f9, 0.0D, f3, f6);
	    tessellator.addVertexWithUV(f7 - f8, 0.0F - f9, 0.0D, f4, f6);
	    tessellator.addVertexWithUV(f7 - f8, 1.0F - f9, 0.0D, f4, f5);
	    tessellator.addVertexWithUV(0.0F - f8, 1.0F - f9, 0.0D, f3, f5);
		tessellator.draw();
		size *= 2.4F;
		GL11.glScalef(size, size, size);
		tessellator.startDrawingQuads();
	    tessellator.setNormal(0.0F, 1.0F, 0.0F);
		tessellator.setColorRGBA_F(1F, 1F, 1F, 0.8F);
	    tessellator.addVertexWithUV(0.0F - f8, 0.1F - f9, 0.01D, f3, f6);
	    tessellator.addVertexWithUV(f7 - f8, 0.1F - f9, 0.01D, f4, f6);
	    tessellator.addVertexWithUV(f7 - f8, 1.1F - f9, 0.01D, f4, f5);
	    tessellator.addVertexWithUV(0.0F - f8, 1.1F - f9, 0.01D, f3, f5);
		tessellator.draw();

	}
	
	//鱗弾の描画
	public void renderScaleShot(Tessellator tessellator, int color)
	{
		GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
		color %= 8;
		loadTexture("/textures/ScaleShot.png");
    	float xLength = 0.75F;
    	double zLength = 0.75F;
    	float uMin = 0.0F;
    	float uMax = 0.5F;
    	float vMin = 0.0F;
    	float vMax = 1.0F;
    	tessellator.startDrawingQuads();  
    	tessellator.setNormal(0.0F, 1.0F, 0.0F);
    	tessellator.setColorRGBA_F(colorR[color]/255F, colorG[color]/255F, colorB[color]/255F, 1.0F);
        tessellator.addVertexWithUV(-xLength, 0.1F,  zLength + 0.15F, uMin, vMin);
        tessellator.addVertexWithUV( xLength, 0.1F,  zLength + 0.15F, uMax, vMin);
        tessellator.addVertexWithUV( xLength, 0.1F, -zLength + 0.15F, uMax, vMax);
        tessellator.addVertexWithUV(-xLength, 0.1F, -zLength + 0.15F, uMin, vMax);
		tessellator.draw();
		GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
	}
	
	//蝶弾
	public void renderButterflyShot(Tessellator tessellator, int color, float wingAngle)
	{
		GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
		color %= 8;
		loadTexture("/textures/ButterflyShot2.png");
		float minU =  0F / 128F;
        float maxU = 32F / 128F;
        float minV = 0F;
        float maxV = 1F;
    	//for(int i = 0; i < 3; i++)
    	{
	    	tessellator.startDrawingQuads();
    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
			tessellator.setColorRGBA_F(colorR[color]/255F, colorG[color]/255F, colorB[color]/255F, 1.0F);
	        tessellator.addVertexWithUV(0.0F, 0.0F,  0.5D, maxU, minV);
	        tessellator.addVertexWithUV(0.5F, 0.0F,  0.5D, minU, minV);
	        tessellator.addVertexWithUV(0.5F, 0.0F, -0.5D, minU, maxV);
	        tessellator.addVertexWithUV(0.0F, 0.0F, -0.5D, maxU, maxV);
	        tessellator.draw();
    	}	
    	GL11.glRotatef(-wingAngle * 2F, 0.0F, 0.0F, 1.0F);
    	//for(int i = 0; i < 3; i++)
    	{
	    	tessellator.startDrawingQuads();
    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
			tessellator.setColorRGBA_F(colorR[color]/255F, colorG[color]/255F, colorB[color]/255F, 1.0F);
	        tessellator.addVertexWithUV( 0.0F, 0.0F,  0.5D, maxU, minV);
	        tessellator.addVertexWithUV(-0.5F, 0.0F,  0.5D, minU, minV);
	        tessellator.addVertexWithUV(-0.5F, 0.0F, -0.5D, minU, maxV);
	        tessellator.addVertexWithUV( 0.0F, 0.0F, -0.5D, maxU, maxV);
	        tessellator.draw();
    	}
		GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
	}

	//星弾の描画
	public void renderStarShot(Tessellator tessellator, int color)
	{
		loadTexture("/textures/StarShot.png");
		color %= 8;
		float[] topPointX = new float[11];
		float[] topPointY = new float[11];
		float angle = 0F;
		float spanAngle = (float)Math.PI * 0.2F;//36°
		for(int i = 0; i < 10; i+=2)
		{
			topPointX[i] = (float)MathHelper.cos(angle);
			topPointY[i] = (float)MathHelper.sin(angle);
			angle += spanAngle;
			topPointX[i+1] = (float)MathHelper.cos(angle) * 0.6F;
			topPointY[i+1] = (float)MathHelper.sin(angle) * 0.6F;
			angle += spanAngle;
		}
		topPointX[10] = topPointX[0];
		topPointY[10] = topPointY[0];
		for(int i = 0; i < 9; i+=2)
		{
			//星の枠部
			tessellator.startDrawingQuads();
        	tessellator.setNormal(0.0F, 1.0F, 0.0F);
			tessellator.setColorRGBA_F(colorR[color], colorG[color], colorB[color], 0.7F);
        	tessellator.addVertexWithUV(topPointX[i]  , topPointY[i]  , 0.0D, 0F, 0F);
        	tessellator.addVertexWithUV(topPointX[i+1], topPointY[i+1], 0.0D, 1F, 0F);
        	tessellator.addVertexWithUV(topPointX[i+2], topPointY[i+2], 0.0D, 1F, 1F);
			tessellator.addVertexWithUV(          0.0F,           0.0F, 0.1D, 0F, 1F);
			tessellator.draw();
			//星の中心部　白い
			tessellator.startDrawingQuads();
        	tessellator.setNormal(0.0F, 1.0F, 0.0F);
			tessellator.setColorRGBA_F(1.0F, 1.0F, 1.0F, 0.7F);
			tessellator.addVertexWithUV(topPointX[i]   * 0.7F, topPointY[i]   * 0.7F,  0.0D, 0F, 0F);
			tessellator.addVertexWithUV(topPointX[i+1] * 0.95F, topPointY[i+1] * 0.95F,  0.0D, 1F, 0F);
        	tessellator.addVertexWithUV(topPointX[i+2] * 0.7F, topPointY[i+2] * 0.7F,  0.0D, 1F, 1F);
			tessellator.addVertexWithUV(          0.0F,           0.0F, 0.21D, 0F, 1F);
			tessellator.draw();
		}
	}
	
    public void doRender(Entity entity, double d, double d1, double d2,
            float f, float f1)
    {
        doRenderTHShot((EntityTHShot)entity, d, d1, d2, f, f1);
    }
}
