package net.minecraft.thKaguyaMod.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.thKaguyaMod.*;

import java.util.Random;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(Side.CLIENT)
public class RenderYuukaParasol extends Render
{
	
	//幽香の日傘の描画
	private Random random = new Random();

    public RenderYuukaParasol()
    {
    }

    public void doRenderYuukaParasol(EntityYuukaParasol entityYuukaParasol, double x, double y, double z,
            float yaw, float pitch)
    {
    	
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
    	//GL11.glDisable(GL11.GL_TEXTURE_2D);
    	GL11.glEnable(GL11.GL_LIGHTING);
    	GL11.glEnable(GL11.GL_NORMALIZE);
        GL11.glEnable(32826 /*GL_RESCALE_NORMAL_EXT*/);
    	//GL11.glEnable(GL11.GL_BLEND);
    	GL11.glDisable(GL11.GL_CULL_FACE);//両面描画
    	GL11.glBlendFunc(GL11.GL_ONE, GL11.GL_ONE_MINUS_SRC_COLOR);
        GL11.glScalef(1.0F, 1.0F, 1.0F);
    	
        loadTexture("/textures/YuukaParasolTexture.png");
        Tessellator tessellator = Tessellator.instance;
    	
    	double stickSideLength = 0.03D;
    	double stickHeight = 2.0D;
    	float stickUMin = 0.0F;
    	float stickUMax = 3F / 64F;
    	float stickVMin = 0.0F;
    	float stickVMax = 1.0F;
    	GL11.glRotatef(0F, 0.0F, 1.0F, 0.0F);
    	for(int i = 0; i < 2; i++)
    	{
    		tessellator.startDrawingQuads();
    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
        	tessellator.addVertexWithUV( -stickSideLength,  stickHeight, 0.0D, stickUMin, stickVMax);
        	tessellator.addVertexWithUV(  stickSideLength,  stickHeight, 0.0D, stickUMax, stickVMax);
        	tessellator.addVertexWithUV(  stickSideLength,         0.0D, 0.0D, stickUMax, stickVMin);
        	tessellator.addVertexWithUV( -stickSideLength,         0.0D, 0.0D, stickUMin, stickVMin);
        	tessellator.draw();
    		GL11.glRotatef(180F, 0.0F, 1.0F, 0.0F);
    	}
    	
    	float parasolUMin = 0.25F;
    	float parasolUMax = 0.5F;
    	float parasolVMin = 0.0F;
    	float parasolVMax = 0.5F;
    	float parasolLength = 1.0F;
    	float parasolWidth = 0.5F;
    	float angleSpan = 360F / 18F;
    	//GL11.glRotatef(30F, 1.0F, 0.0F, 0.0F);
    	for(int i = 0; i < 18; i++)
    	{
    		tessellator.startDrawingQuads();
    		tessellator.setNormal(0.0F, 1.0F, 0.0F);
        	tessellator.addVertexWithUV(          0.0F,   stickHeight, 0.0D, parasolUMin, parasolVMax);
        	tessellator.addVertexWithUV(          0.0F,   stickHeight, 0.0D, parasolUMax, parasolVMax);
        	tessellator.addVertexWithUV(  parasolWidth, parasolLength, -1.3D, parasolUMax, parasolVMin);
        	tessellator.addVertexWithUV( -parasolWidth, parasolLength, -1.3D, parasolUMin, parasolVMin);
        	tessellator.draw();
    		GL11.glRotatef(angleSpan, 0.0F, 1.0F, 0.0F);
    	}
    	
    	
        GL11.glDisable(32826 /*GL_RESCALE_NORMAL_EXT*/);
        //GL11.glDisable(GL11.GL_BLEND);
    	GL11.glEnable(GL11.GL_CULL_FACE);//表綿描画
        GL11.glDisable(GL11.GL_LIGHTING);
    	//GL11.glEnable(GL11.GL_TEXTURE_2D);
        GL11.glPopMatrix();
    }

    public void doRender(Entity entity, double d, double d1, double d2,
            float f, float f1)
    {
        doRenderYuukaParasol((EntityYuukaParasol)entity, d, d1, d2, f, f1);
    }
}
