package net.minecraft.thKaguyaMod;

import java.util.logging.Level;
import java.io.File;

import net.minecraft.src.*;
import net.minecraft.item.*;
import net.minecraft.block.*;
import net.minecraft.creativetab.*;
import net.minecraftforge.client.*;
import net.minecraftforge.common.EnumHelper;

// Forge式コンフィグファイルを利用するためのAPI
import net.minecraftforge.common.Configuration;

// FMLのログに出力するAPI
import cpw.mods.fml.common.FMLLog;

// プロキシシステムのためのアノテーション
import cpw.mods.fml.common.SidedProxy;

// FMLにロードさせるためのアノテーション
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.network.NetworkMod;

// 前初期化, 初期化のイベント
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;

// Entityに関するレジストリ
import cpw.mods.fml.common.registry.EntityRegistry;

// 言語に関するレジストリ
import cpw.mods.fml.common.registry.LanguageRegistry;

// ModID   : mod固有の文字列, 
// name    : modの名前
// version : バージョン
@Mod(modid = "mod_thKaguya", name = "五つの難題MOD+", version = "2.00_1.5.2")
@NetworkMod(clientSideRequired = true, serverSideRequired = false)
public class mod_thKaguya
{
	
	
	// クライアント側とサーバー側で異なるインスタンスを生成
	@SidedProxy(clientSide = "net.minecraft.thKaguyaMod.client.ClientProxy", serverSide = "net.minecraft.thKaguyaMod.CommonProxy")
	public static CommonProxy proxy;
	
	// 自身のインスタンス
	@Mod.Instance("mod_thKaguya")
	public static mod_thKaguya instance;
	
	private int itemIdBase;
	
	//アイテム
	public static Item houraiedaItem;//蓬莱の玉の枝
	public static Item houraiPearlItem;//色真珠
	public static Item hotokehachiItem;//仏の御石の鉢
	public static Item hinezumiItem;//火鼠の皮衣
	public static Item koyasugaiItem;//燕の子安貝
	public static Item ryuutamaItem;//龍の頸の玉
	public static Item kinkakuziItem;//金閣寺の一枚天井
	public static Item roukankenItem;//楼観剣
	public static Item bentlarItem;//
	public static Item sakuyawatchItem;//咲夜の懐中時計
	public static Item sukimaItem;//スキマ
	public static Item thirdeyeItem;//第三の眼
	public static Item mazinkyoukanItem;//魔人経巻
	public static Item silverKnifeItem;//銀のナイフ
	public static Item heavenlyPeachItem;//天界の桃
	public static Item hisouItem;//緋想の剣
	public static Item houtouItem;//毘沙門天の宝塔
	public static Item pendulumItem;//ナズーリンペンデュラム
	public static Item treasureItem;//たから
	public static Item deathScytheItem;//死神の大鎌
	public static Item kaigoItem;//悔悟の棒
	public static Item hisyakuItem;//舟幽霊の柄杓（空）
	public static Item hisyaku2Item;//舟幽霊の柄杓（水入り）
	public static Item yuyukoOugiItem;//幽々子の扇
	public static Item hakkeroItem;//ミニ八卦炉
	public static Item oharaibouSItem;//風祝のお祓い帽
	public static Item onbashiraItem;//御柱
	public static Item kabenukenomiItem;//壁抜けの鑿
	public static Item mikoSwordItem;//豊聡耳の宝剣
	public static Item closedThirdEyeItem;//閉じた第三の眼
	public static Item homingAmuletItem;//ホーミングアミュレット
	public static Item yuukaParasolItem;//幽香の傘
	public static Item ajaRedStoneItem;//エイジャの赤石
	public static Item kappaCapItem;//河童の帽子
	public static Item spellCardItem;//スペルカード
	public static Item shotMaterialItem;//弾幕の素
	public static Item thShotItem;//単発ショット
	public static Item noteBarrageItem;//弾幕記憶アイテム
	//アイテムID
	private int houraiedaItemId;//蓬莱の玉の枝
	private int houraiPearlItemId;//色真珠
	private int hotokehachiItemId;//仏の御石の鉢
	private int hinezumiItemId;//火鼠の皮衣
	private int koyasugaiItemId;//燕の子安貝
	private int ryuutamaItemId;//龍の頸の玉
	private int kinkakuziItemId;//金閣寺の一枚天井
	private int roukankenItemId;//楼観剣
	private int bentlarItemId;//
	private int sakuyawatchItemId;//咲夜の懐中時計
	private int sukimaItemId;//スキマ
	private int thirdeyeItemId;//第三の眼
	private int mazinkyoukanItemId;//魔人経巻
	private int silverKnifeItemId;//銀のナイフ
	private int heavenlyPeachItemId;//天界の桃
	private int hisouItemId;//緋想の剣
	private int houtouItemId;//毘沙門天の宝塔
	private int pendulumItemId;//ナズーリンペンデュラム
	private int treasureItemId;//たから
	private int deathScytheItemId;//死神の大鎌
	private int kaigoItemId;//悔悟の棒
	private int hisyakuItemId;//舟幽霊の柄杓（空）
	private int hisyaku2ItemId;//舟幽霊の柄杓（水入り）
	private int yuyukoOugiItemId;//幽々子の扇
	private int hakkeroItemId;//ミニ八卦炉
	private int oharaibouSItemId;//風祝のお祓い帽
	private int onbashiraItemId;//御柱
	private int kabenukenomiItemId;//壁抜けの鑿
	private int mikoSwordItemId;//豊聡耳の宝剣
	private int closedThirdEyeItemId;//閉じた第三の眼
	private int homingAmuletItemId;//ホーミングアミュレット
	private int yuukaParasolItemId;//幽香の傘
	private int ajaRedStoneItemId;//エイジャの赤石
	private int kappaCapItemId;//河童の帽子
	private int spellCardItemId;//スペルカード
	private int shotMaterialItemId;//弾幕の素
	private int thShotItemId;//単発ショット
	private int noteBarrageItemId;//弾幕記憶アイテム
	//EntityID
	//private int entityIdEntityHouraiTama;
	private int entityIdEntityRyuuLightningBolt;
	private int entityIdEntityColorLightningBolt;
	private int entityIdEntityKinkakuzi;
	private int entityIdEntityPrivateSquare;
	private int entityIdEntitySilverKnife;
	private int entityIdEntitySukima;
	private int entityIdEntityMazinkyoukan;
	private int entityIdEntityHisou;
	private int entityIdEntityKishitudan;
	private int entityIdEntityPendulum;
	//private int entityIdEntityButterflyShot;
	private int entityIdEntityMiniHakkero;
	private int entityIdEntityMiracleCircle;
	private int entityIdEntitySanaeWind;
	private int entityIdEntityUmiware;
	private int entityIdEntityYouryokuSpoiler;
	private int entityIdEntityMasterSpark;
	private int entityIdEntityHomingAmulet;
	//private int entityIdEntityUrokoShot;
	private int entityIdEntityYuukaParasol;
	private int entityIdEntityAjaRedStoneEffect;
	private int entityIdEntityAjaRedStoneLaser;
	private int entityIdEntityTHShot;
	private int entityIdEntityTHLaser;
	private int entityIdEntitySpellCard;
	private int entityIdEntityMusouFuuin;
	
	private int entityIdEntityTHFairy;
	
	//
	private ItemStack redPearl;
	private ItemStack bluePearl;
	private ItemStack greenPearl;
	private ItemStack yellowPearl;
	private ItemStack purplePearl;
	private ItemStack aquaPearl;
	private ItemStack orangePearl;
	private ItemStack silverKnifeBlue;
	private ItemStack silverKnifeRed;
	private ItemStack silverKnifeGreen;
	private ItemStack smallShot;
	private ItemStack tinyShot;
	private ItemStack mediumShot;
	private ItemStack bigShot;
	private ItemStack starShot;
	private ItemStack smallStarShot;
	private ItemStack circleShot;
	private ItemStack scaleShot;
	private ItemStack butterflyShot;
	private ItemStack lightShot;
	
	private int spellCardNumber = 5;
	private ItemStack[] spellCard = new ItemStack[spellCardNumber];
	
	public static String scEnName[] = {
		"Spirit Sign \"Fantasy Seal\"",
		"Love Sign \"Master Spark\"" ,
		"Deadly Butterfly \"Everlasting Nap\"",
		"Star Sign \"Meteonic Shower\"",
		"Boundary Sign \"Boundary between Wave and Particle\""
	};
	
	public static String scJpName[] = {
		"霊符「夢想封印」",
		"恋符「マスタースパーク」",
		"死蝶「華胥の永眠」",
		"星符「メテオニックシャワー」",
		"境符「波と粒の境界」"
	};
	
	static EnumArmorMaterial enumArmorHinezumi;
	
	public static String sukimaWarpSE = "mob.endermen.portal";
	//public static String sukimaWarpSE = "random.sukima";
	
	//コンフィグで変更できる変数
	private int setSpellCardVol;
	private int setMasterSparkVol;
	private int setHisoutenVol;
	public static float SpellCardVol;//スペルカード音の音量
	public static float MasterSparkVol;//マスタースパークの音量
	public static float HisoutenVol;	//全人類の緋想天の音量
	public static boolean UsingMasterSpark;//マスタースパークが使用できるか
	public static boolean MasterSparkDestroysBlocks;//マスタースパークでブロックを破壊できるか
	
	//クリエイティブタグの登録
	public static final CreativeTabs tabSpellCard = new CreativeTabSpellCard("spellcard");
	
	// 前処理
	@Mod.PreInit
	public void preInit(FMLPreInitializationEvent event)
	{
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		try
		{
			cfg.load();
			//ItemIDのコンフィグ
			// 設定する変数    = cfg.get("カテゴリ名", "項目名", 設定する値).getInt();       
			itemIdBase         = cfg.get("ItemID"  , "ItemID Base", 4360).getInt();//ItemIDの出発点のコンフィグ設定
			houraiedaItemId      = itemIdBase+ 0;
			houraiPearlItemId    = itemIdBase+ 1;
			shotMaterialItemId   = itemIdBase+ 2;
			thShotItemId         = itemIdBase+ 3;
			//noteBarrageItemId    = itemIdBase+ 4;
			hotokehachiItemId    = itemIdBase+ 6;
			hinezumiItemId       = itemIdBase+ 7;
			koyasugaiItemId      = itemIdBase+ 8;
			ryuutamaItemId       = itemIdBase+ 9;
			kinkakuziItemId      = itemIdBase+10;
			ajaRedStoneItemId    = itemIdBase+11;
			hisyakuItemId        = itemIdBase+14;
			deathScytheItemId    = itemIdBase+15;
			kaigoItemId          = itemIdBase+16;
			pendulumItemId       = itemIdBase+18;
			roukankenItemId      = itemIdBase+20;
			sakuyawatchItemId    = itemIdBase+21;
			silverKnifeItemId    = itemIdBase+22;
			sukimaItemId         = itemIdBase+23;
			thirdeyeItemId       = itemIdBase+24;
			mazinkyoukanItemId   = itemIdBase+25;
			heavenlyPeachItemId  = itemIdBase+26;
			hisouItemId          = itemIdBase+27;
			yuyukoOugiItemId     = itemIdBase+28;
			oharaibouSItemId     = itemIdBase+29;
			onbashiraItemId      = itemIdBase+30;
			homingAmuletItemId   = itemIdBase+32;
			hakkeroItemId        = itemIdBase+33;
			kabenukenomiItemId   = itemIdBase+35;
			mikoSwordItemId      = itemIdBase+36;
			closedThirdEyeItemId = itemIdBase+37;
			yuukaParasolItemId   = itemIdBase+38;
			kappaCapItemId       = itemIdBase+39;
			spellCardItemId      = itemIdBase+40;
			
			//EntityIDのコンフィグ
			//entityIdEntityHouraiTama         = cfg.get("EntityID", "Hourai Shot"               ,530).getInt();
			entityIdEntityRyuuLightningBolt  = cfg.get("EntityID", "Brilliant Dragon Bullet"   ,531).getInt();
			entityIdEntityColorLightningBolt = cfg.get("EntityID", "Color LightningBolt"       ,532).getInt();
			entityIdEntityKinkakuzi          = cfg.get("EntityID", "Kinkakuzi "                ,533).getInt();
			entityIdEntityPrivateSquare      = cfg.get("EntityID", "Sakuya's Pocket Watch"     ,534).getInt();
			entityIdEntitySilverKnife        = cfg.get("EntityID", "Silver Knife"              ,535).getInt();
			entityIdEntitySukima             = cfg.get("EntityID", "Sukima "                   ,536).getInt();
			entityIdEntityMazinkyoukan       = cfg.get("EntityID", "Mazinkyoukan "             ,537).getInt();
			entityIdEntityHisou              = cfg.get("EntityID", "Hisou Sword"               ,538).getInt();
			entityIdEntityKishitudan         = cfg.get("EntityID", "Kishitu Shot"              ,539).getInt();
			entityIdEntityPendulum           = cfg.get("EntityID", "Nazrin Pendulum"           ,540).getInt();
			//entityIdEntityButterflyShot      = cfg.get("EntityID", "Butterfly Shot"            ,541).getInt();
			entityIdEntityMiracleCircle      = cfg.get("EntityID", "Miracle Magic Square"      ,542).getInt();
			entityIdEntitySanaeWind          = cfg.get("EntityID", "Sanae Wind"                ,543).getInt();
			entityIdEntityUmiware            = cfg.get("EntityID", "Miracle of Moses"          ,544).getInt();
			entityIdEntityYouryokuSpoiler    = cfg.get("EntityID", "Youryoku Spoiler"          ,545).getInt();
			entityIdEntityMiniHakkero        = cfg.get("EntityID", "MiniHakkero "              ,546).getInt();
			entityIdEntityMasterSpark        = cfg.get("EntityID", "MasterSpark "              ,547).getInt();
			entityIdEntityHomingAmulet       = cfg.get("EntityID", "Homing Amulet"             ,548).getInt();
			//entityIdEntityUrokoShot          = cfg.get("EntityID", "Uroko Shot"                ,549).getInt();
			entityIdEntityYuukaParasol       = cfg.get("EntityID", "Yuuka Parasol"             ,550).getInt();
			entityIdEntityAjaRedStoneEffect  = cfg.get("EntityID", "Effect of Red Stone of Aja",551).getInt();
			entityIdEntityAjaRedStoneLaser   = cfg.get("EntityID", "Laser of Red Stone of Aja" ,552).getInt();
			entityIdEntityTHShot             = cfg.get("EntityID", "Normal Shot"               ,553).getInt();
			entityIdEntityTHLaser            = cfg.get("EntityID", "Normal Laser"              ,554).getInt();
			entityIdEntitySpellCard          = cfg.get("EntityID", "Spell Card"                ,555).getInt();
			entityIdEntityMusouFuuin         = cfg.get("EntityID", "Musou Fuuin"               ,556).getInt();
			//entityIdEntityTHFairy            = cfg.get("EntityID", "Fairy"                     ,555).getInt();
			
			/*File sukimaFile = new File("../resources/mod/sound/random/sukima.wav");
			if(sukimaFile.exists())
			{
				sukimaWarpSE = "random.sukima";
			}*/
			
			//SEのボリュームのコンフィグ
			setSpellCardVol   = cfg.get("SE vol", "SpellCarVol"   , 50).getInt();
			setMasterSparkVol = cfg.get("SE vol", "MasterSparkVol", 50).getInt();
			setHisoutenVol    = cfg.get("SE vol", "HisoutenVol"   , 20).getInt();
			
			if(setSpellCardVol > 500)setSpellCardVol = 500;
			if(setMasterSparkVol > 500)setMasterSparkVol = 500;
			if(setHisoutenVol > 500)setHisoutenVol = 500;
			SpellCardVol = (float)setSpellCardVol / 100F;
			MasterSparkVol = (float)setMasterSparkVol / 100F;
			HisoutenVol = (float)setHisoutenVol / 100F;
			
			UsingMasterSpark = true;
			//マスタースパークの使用ができるか？
			UsingMasterSpark = cfg.get("Other", "Using the MasterSpark", true).getBoolean(true);
			MasterSparkDestroysBlocks = cfg.get("Other", "MasterSpark destroys blocks", true).getBoolean(true);
		}
		catch (Exception e)
		{
			// 失敗した場合強制終了
			FMLLog.log(Level.SEVERE, e, "Error Massage");
		}
		finally
		{
			cfg.save();
		}
	}
	
	// load()に相当
	@Mod.Init
	public void init(FMLInitializationEvent event)
	{
		enumArmorHinezumi = EnumHelper.addArmorMaterial("HINEZUMI",1, new int[] {1, 2, 2, 2}, 0);//新しいアーマー素材を登録
		//int hinezumiIndex = RenderingRegistry.addNewArmorRendererPrefix("/armor/hinezumi_1.png");
		//int hinezumiIndex = ModLoader.addArmor("hinezumi");
		int hinezumiIndex = 0;
		//int hinezumiIndex = proxy.addArmor("HINEZUMI");
		
		houraiedaItem = new ItemHouraiEda(houraiedaItemId).setUnlocalizedName("houraiEda");
		hotokehachiItem = new ItemHotokeHachi(hotokehachiItemId,EnumToolMaterial.STONE).setUnlocalizedName("hotokeHachi");
		ryuutamaItem = new ItemRyuuTama(ryuutamaItemId).setUnlocalizedName("ryuuTama");
		hinezumiItem = new ItemHinezumi(hinezumiItemId,enumArmorHinezumi, hinezumiIndex, 1).setUnlocalizedName("hinezumi");
		//hinezumiItem = new ItemHinezumi(hinezumiItemId,EnumArmorMaterial.CHAIN, hinezumiindex, 1).setIconCoord(3,0).setItemName("hinezumiItem");
		koyasugaiItem = new ItemKoyasugai(koyasugaiItemId, 0, false).setUnlocalizedName("koyasugai");
		houraiPearlItem = new ItemHouraiPearl(houraiPearlItemId).setUnlocalizedName("houraiPearl");
		kinkakuziItem = new ItemKinkakuzi(kinkakuziItemId).setUnlocalizedName("kinkakuzi");
		hisyakuItem = new ItemHisyaku(hisyakuItemId).setUnlocalizedName("hisyaku");
		//hisyaku2Item = new ItemHisyaku2(hisyaku2ItemId).setIconCoord(4,6).setItemName("Hisyaku2Item");
		deathScytheItem = new ItemDeathScythe(deathScytheItemId, EnumToolMaterial.IRON).setUnlocalizedName("deathScythe");
		kaigoItem = new ItemKaigo(kaigoItemId, EnumToolMaterial.WOOD).setUnlocalizedName("kaigoStick");
		pendulumItem = new ItemPendulum(pendulumItemId).setUnlocalizedName("pendulum");
		roukankenItem = new ItemRoukanken(roukankenItemId, EnumToolMaterial.IRON).setUnlocalizedName("roukanSword");
		sakuyawatchItem = new ItemSakuyaWatch(sakuyawatchItemId).setUnlocalizedName("sakuyaWatch");
		silverKnifeItem = new ItemSilverKnife(silverKnifeItemId).setUnlocalizedName("silverKnife");
		sukimaItem = new ItemSukima(sukimaItemId).setUnlocalizedName("sukima");
		thirdeyeItem = new ItemThirdEye(thirdeyeItemId).setUnlocalizedName("thirdEye");
		mazinkyoukanItem = new ItemMazinKyoukan(mazinkyoukanItemId).setUnlocalizedName("mazinKyoukan");
		heavenlyPeachItem = new ItemHeavenlyPeach(heavenlyPeachItemId, 2, true).setUnlocalizedName("heavenlyPeach");
		hisouItem = new ItemHisou(hisouItemId, EnumToolMaterial.IRON).setUnlocalizedName("hisouSword");
		yuyukoOugiItem = new ItemYuyukoFan(yuyukoOugiItemId).setUnlocalizedName("yuyukoOugi");
		oharaibouSItem = new ItemOharaibouS(oharaibouSItemId).setUnlocalizedName("mikoStick_S");
		onbashiraItem = new ItemOnbashira(onbashiraItemId, EnumToolMaterial.WOOD).setUnlocalizedName("onbashira");
		hakkeroItem = new ItemMiniHakkero(hakkeroItemId).setUnlocalizedName("miniHakkero");
		kabenukenomiItem = new ItemKabenuke(kabenukenomiItemId).setUnlocalizedName("kabenuke");
		mikoSwordItem = new ItemMikoSword(mikoSwordItemId, EnumToolMaterial.IRON).setUnlocalizedName("toyosatomimiSword");
		closedThirdEyeItem = new ItemClosedThirdEye(closedThirdEyeItemId).setUnlocalizedName("closedThirdEye");
		homingAmuletItem = new ItemHomingAmulet(homingAmuletItemId).setUnlocalizedName("homingAmulet");
		yuukaParasolItem = new ItemYuukaParasol(yuukaParasolItemId).setUnlocalizedName("yuukaParasol");
		ajaRedStoneItem = new ItemAjaRedStone(ajaRedStoneItemId).setUnlocalizedName("ajaRedStone");
		kappaCapItem = new ItemKappaCap(kappaCapItemId,enumArmorHinezumi, hinezumiIndex, 0).setUnlocalizedName("kappaCap");
		spellCardItem = new ItemSpellCard(spellCardItemId).setUnlocalizedName("spellCard/0");
		shotMaterialItem = new ItemShotMaterial(shotMaterialItemId).setUnlocalizedName("shotMaterial");
		thShotItem = new ItemTHShot(thShotItemId).setUnlocalizedName("thShot");
		//noteBarrageItem = new ItemNoteBarrage(noteBarrageItemId).setUnlocalizedName("shotMaterial");
		setItemName(houraiedaItem    , "Jeweled Branch of Hourai"     , "蓬莱の玉の枝"          );
		setItemName(hotokehachiItem  , "Buddhist Diamond"             , "仏の御石の鉢"          );
		setItemName(ryuutamaItem     , "Brilliant Dragon Bullet"      , "龍の頸の玉"            );
		setItemName(hinezumiItem     , "Salamander Shield"            , "火鼠の皮衣"            );
		setItemName(koyasugaiItem    , "Life Spring Infinity"         , "燕の子安貝"            );
		setItemName(houraiPearlItem  , "Color Pearl"                  , "色真珠"                );
		setItemName(kinkakuziItem    , "Enormous Ceiling of Kinkakuji", "金閣寺の一枚天井"      );
		setItemName(ajaRedStoneItem  , "Red Stone of Aja"             , "エイジャの赤石"        );
		setItemName(hisyakuItem      , "Ship Ghost's Dipper"          , "舟幽霊の柄杓"          );
		setItemName(deathScytheItem  , "Scythe of Death"              , "死神の大鎌"            );
		setItemName(kaigoItem        , "Stick of Regret"              , "悔悟の棒"              );
		setItemName(pendulumItem     , "Nazrin Pendulum"              , "ナズーリンペンデュラム");
		setItemName(roukankenItem    , "Roukan Sword"                 , "楼観剣"                );
		setItemName(silverKnifeItem  , "Silver Knife"                 , "銀のナイフ"            );
		setItemName(sakuyawatchItem  , "Sakuya's Pocket Watch"        , "咲夜の懐中時計"        );
		setItemName(sukimaItem       , "Sukima"                       , "スキマ"                );
		setItemName(thirdeyeItem     , "3rd Eye"                      , "第三の眼"              );
		setItemName(mazinkyoukanItem , "Magician Roll of Sutras"      , "魔人経巻"              );
		setItemName(heavenlyPeachItem, "Heavenly Peach"               , "天界の桃"              );
		setItemName(hisouItem        , "Hisou Sword"                  , "緋想の剣"              );
		setItemName(yuyukoOugiItem   , "Yuyuko's Fan"                 , "幽々子の扇"            );
		setItemName(oharaibouSItem   , "Wind Shrine Maiden Stick"     , "風祝のお祓い棒"        );
		setItemName(onbashiraItem    , "Strange Festival Got Pillar"  , "御柱"                  );
		setItemName(hakkeroItem      , "Mini Hakkero"                 , "ミニ八卦炉"            );
		setItemName(kabenukenomiItem , "Chisel of Penetration"        , "壁抜けの鑿"            );
		setItemName(mikoSwordItem    , "Sacred Sword of Toyosatomimi" , "豊聡耳の宝剣"          );
		setItemName(closedThirdEyeItem, "Closed 3rd Eye"              , "閉ざした第三の眼"      );
		setItemName(homingAmuletItem , "Homing Amulet"                , "ホーミングアミュレット");
		setItemName(yuukaParasolItem , "Yuuka's Parasol"              , "幽香の日傘"            );
		setItemName(kappaCapItem     , "Kappa Cap"                    , "河童の帽子"            );
		setItemName(spellCardItem    , "Spell Card"                   , "スペルカード"          );
		setItemName(shotMaterialItem , "Shot Material"                , "弾の素"                );
		setItemName(thShotItem       , "Shot"                         , "弾"                    );
		//setItemName(noteBarrageItem  , "Note Barrage"                 , "弾幕メモ"              );
		
		
		redPearl    = new ItemStack(houraiPearlItem,1, 0);
		bluePearl   = new ItemStack(houraiPearlItem,1, 1);
		greenPearl  = new ItemStack(houraiPearlItem,1, 2);
		yellowPearl = new ItemStack(houraiPearlItem,1, 3);
		purplePearl = new ItemStack(houraiPearlItem,1, 4);
		aquaPearl   = new ItemStack(houraiPearlItem,1, 5);
		orangePearl = new ItemStack(houraiPearlItem,1, 6);
		silverKnifeBlue  = new ItemStack(silverKnifeItem,4, 0);
		silverKnifeRed   = new ItemStack(silverKnifeItem,2, 1);
		silverKnifeGreen = new ItemStack(silverKnifeItem,4, 2);
		setItemName(redPearl    , "Red Pearl"   , "赤真珠");
		setItemName(bluePearl   , "Blue Pearl"  , "青真珠");
		setItemName(greenPearl  , "Green Pearl" , "緑真珠");
		setItemName(yellowPearl , "Yellow Pearl", "黄真珠");
		setItemName(purplePearl , "Purple Pearl", "紫真珠");
		setItemName(aquaPearl   , "Aqua Pearl"  , "水真珠");
		setItemName(orangePearl , "Orange Pearl", "橙真珠");
		
		smallShot = new ItemStack(thShotItem, 1, 0);
		tinyShot  = new ItemStack(thShotItem, 1, 1);
		mediumShot = new ItemStack(thShotItem, 2, 2);
		bigShot    = new ItemStack(thShotItem, 3, 3);
		starShot   = new ItemStack(thShotItem, 1, 4);
		smallStarShot = new ItemStack(thShotItem, 5, 5);
		circleShot = new ItemStack(thShotItem, 3, 6);
		scaleShot = new ItemStack(thShotItem, 4, 7);
		butterflyShot = new ItemStack(thShotItem, 2, 8);
		lightShot = new ItemStack(thShotItem, 1, 9);
		setItemName(smallShot, "Small Shot", "小弾");
		setItemName(tinyShot, "Tiny Shot", "粒弾");
		setItemName(mediumShot, "Medium Shot", "中弾");
		setItemName(bigShot, "Big Shot", "大弾");
		setItemName(starShot, "Star Shot", "星弾");
		setItemName(smallStarShot, "Small Star Shot", "小星弾");
		setItemName(circleShot, "Circle Shot", "輪弾");
		setItemName(scaleShot, "Scale Shot", "鱗弾");
		setItemName(butterflyShot, "Butterfly Shot", "蝶弾");
		setItemName(lightShot, "Light Shot", "光弾");
		
		for(int i = 0; i < spellCardNumber; i++)
		{
			spellCard[i] = new ItemStack(spellCardItem, 1, i);
			setItemName(spellCard[i], scEnName[i], scJpName[i]);
		}

		// ModLoader.registerEntityに相当
		//EntityRegistry.registerGlobalEntityID(EntityHouraiTama.class         , "HouraiTama"         , entityIdEntityHouraiTama        );
		EntityRegistry.registerGlobalEntityID(EntityRyuuLightningBolt.class  , "BrilliantDragonBullet"  , entityIdEntityRyuuLightningBolt );
		EntityRegistry.registerGlobalEntityID(EntityColorLightningBolt.class , "ColorLightningBolt" , entityIdEntityColorLightningBolt);
		EntityRegistry.registerGlobalEntityID(EntityKinkakuzi.class          , "Kinkakuzi"          , entityIdEntityKinkakuzi         );
		EntityRegistry.registerGlobalEntityID(EntitySilverKnife.class        , "SilverKnife"        , entityIdEntitySilverKnife       );
		EntityRegistry.registerGlobalEntityID(EntityPrivateSquare.class      , "PrivateSquare"      , entityIdEntityPrivateSquare     );
		EntityRegistry.registerGlobalEntityID(EntitySukima.class             , "Sukima"             , entityIdEntitySukima            );
		EntityRegistry.registerGlobalEntityID(EntityMazinkyoukan.class       , "Mazinkyoukan"       , entityIdEntityMazinkyoukan      );
		EntityRegistry.registerGlobalEntityID(EntityHisou.class              , "Hisou"              , entityIdEntityHisou             );
		EntityRegistry.registerGlobalEntityID(EntityKishitudan.class         , "Kisihtudan"         , entityIdEntityKishitudan        );
		EntityRegistry.registerGlobalEntityID(EntityPendulum.class           , "NazrinPendulum"     , entityIdEntityPendulum          );
		//EntityRegistry.registerGlobalEntityID(EntityButterflyShot.class      , "ButterflyShot"      , entityIdEntityButterflyShot     );
		EntityRegistry.registerGlobalEntityID(EntityMiracleCircle.class      , "MiracleCircle"      , entityIdEntityMiracleCircle     );
		EntityRegistry.registerGlobalEntityID(EntitySanaeWind.class          , "SanaeWind"          , entityIdEntitySanaeWind         );
		EntityRegistry.registerGlobalEntityID(EntityUmiware.class            , "Umiware"            , entityIdEntityUmiware           );
		EntityRegistry.registerGlobalEntityID(EntityYouryokuSpoiler.class    , "YouryokuSpoiler"    , entityIdEntityYouryokuSpoiler   );
		EntityRegistry.registerGlobalEntityID(EntityMiniHakkero.class        , "MiniHakkero"        , entityIdEntityMiniHakkero       );
		EntityRegistry.registerGlobalEntityID(EntityMasterSpark.class        , "MasterSpark"        , entityIdEntityMasterSpark       );
		EntityRegistry.registerGlobalEntityID(EntityHomingAmulet.class       , "HomingAmulet"       , entityIdEntityHomingAmulet      );
		//EntityRegistry.registerGlobalEntityID(EntityUrokoShot.class          , "UrokoShot"          , entityIdEntityUrokoShot         );
		EntityRegistry.registerGlobalEntityID(EntityYuukaParasol.class       , "YuukaParasol"       , entityIdEntityYuukaParasol      );
		EntityRegistry.registerGlobalEntityID(EntityAjaRedStoneEffect.class  , "AjaRedStoneEffect"  , entityIdEntityAjaRedStoneEffect );
		EntityRegistry.registerGlobalEntityID(EntityAjaRedStoneLaser.class   , "AjaRedStoneLaser"   , entityIdEntityAjaRedStoneLaser  );
		EntityRegistry.registerGlobalEntityID(EntityTHShot.class             , "NormalShot"         , entityIdEntityTHShot            );
		EntityRegistry.registerGlobalEntityID(EntityTHLaser.class            , "NormalLaser"        , entityIdEntityTHLaser           );
		EntityRegistry.registerGlobalEntityID(EntitySpellCard.class          , "SpellCard"          , entityIdEntitySpellCard         );
		//EntityRegistry.registerGlobalEntityID(EntityTHFairy.class, "THFairy", entityIdEntityTHFairy, 0xFFFFFF, 0x000000);
		
		
		/*
		 サーバーとクライアントのエンティティを同期させるメソッド
		 各引数はそれぞれ以下のとおり
		 Entityのクラス, 
		 Entityの内部名, 
		 このmod内で使用する同期取り用のID,
		 @Modのクラス(ここに書くのであればthis, そうでないならinstanceを参照)
		 更新可能な距離
		 更新頻度(tickごと)
		 Entityが速度情報を持つかどうか
		*/
		//EntityRegistry.registerModEntity(EntityHouraiTama.class         , "HouraiTama"         , 0, this, 250, 5, true );
		EntityRegistry.registerModEntity(EntityRyuuLightningBolt.class  , "BrilliantDragonBullet"  , 1, this, 250, 3, true );
		EntityRegistry.registerModEntity(EntityColorLightningBolt.class , "ColorLightningBolt" , 2, this, 250, 1, false);
		EntityRegistry.registerModEntity(EntityKinkakuzi.class          , "Kinkakuzi"          , 3, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntitySilverKnife.class        , "SilverKnife"        , 4, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntityPrivateSquare.class      , "PrivateSquare"      , 5, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntitySukima.class             , "Sukima"             , 6, this, 250, 5, false);
		EntityRegistry.registerModEntity(EntityMazinkyoukan.class       , "Mazinkyoukan"       , 7, this,  50, 1, true);
		EntityRegistry.registerModEntity(EntityHisou.class              , "Hisou"              , 8, this, 250, 5, false);
		EntityRegistry.registerModEntity(EntityKishitudan.class         , "Kishitudan"         , 9, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntityPendulum.class           , "NazrinPendulum"     ,10, this,  30, 1, true);
		//EntityRegistry.registerModEntity(EntityButterflyShot.class      , "ButterflyShot"      ,11, this, 250, 5, true);
		EntityRegistry.registerModEntity(EntityMiracleCircle.class      , "MiracleCircle"      ,12, this,  20, 1, false);
		EntityRegistry.registerModEntity(EntitySanaeWind.class          , "SanaeWind"          ,13, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntityUmiware.class            , "Umiware"            ,14, this, 250, 5, true);
		EntityRegistry.registerModEntity(EntityYouryokuSpoiler.class    , "YouryokuSpoiler"    ,15, this, 250, 5, true);
		EntityRegistry.registerModEntity(EntityMiniHakkero.class        , "MiniHakkero"        ,16, this, 250, 5, false);
		EntityRegistry.registerModEntity(EntityMasterSpark.class        , "MasterSpark"        ,17, this, 250, 5, false);
		EntityRegistry.registerModEntity(EntityHomingAmulet.class       , "HomingAmulet"       ,18, this, 250, 1, true);
		//EntityRegistry.registerModEntity(EntityUrokoShot.class          , "UrokoShot"          ,19, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntityYuukaParasol.class       , "YuukaParasol"       ,20, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntityAjaRedStoneEffect.class  , "AjaRedStoneEffect"  ,21, this,  50, 1, true);
		EntityRegistry.registerModEntity(EntityAjaRedStoneLaser.class   , "AjaRedStoneLaser"   ,22, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntityTHShot.class             , "NormalShot"         ,23, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntityTHLaser.class            , "NormalLaser"        ,24, this, 250, 1, true);
		EntityRegistry.registerModEntity(EntitySpellCard.class          , "SpellCard"          ,25, this, 250, 5, false);
		EntityRegistry.registerModEntity(EntityMusouFuuin.class         , "MusouFuuin"         ,26, this, 250, 1, true);
		//EntityRegistry.registerModEntity(EntityTHFairy.class, "THFairy", 25, this, 250, 5, true);
		
		//テクスチャの登録
		proxy.registerTextures();
		// サーバー側は何もしない, クライアント側ではレンダーの登録が行われる
		proxy.registerRenderers();
		
		
		//レシピの登録
		setAllAddRecipes();
		
	}
	
	private void setItemName(Item item, String strEn, String strJP)
	{
		ModLoader.addName(item,strEn);
		ModLoader.addName(item,"ja_JP",strJP);
	}
	
	private void setItemName(ItemStack itemstack, String strEn, String strJP)
	{
		ModLoader.addName(itemstack,strEn);
		ModLoader.addName(itemstack,"ja_JP",strJP);
	}

//レシピの登録
private void setAllAddRecipes()
{
	//赤真珠
	ModLoader.addRecipe(redPearl,
						new Object[]{	"XXX",
										"XYX",
										"XXX",
						Character.valueOf('X'),Item.redstone,
						Character.valueOf('Y'),Item.enderPearl });
	//青真珠
	ModLoader.addRecipe(bluePearl,
						new Object[]{	"XXX",
										"XYX",
										"XXX",
						Character.valueOf('X'),new ItemStack(Item.dyePowder, 1, 4),
						Character.valueOf('Y'),Item.enderPearl });
	//緑真珠
	ModLoader.addRecipe(greenPearl,
						new Object[]{	"XXX",
										"XYX",
										"XXX",
						Character.valueOf('X'),Item.emerald,
						Character.valueOf('Y'),Item.enderPearl });
	//黄真珠
	ModLoader.addRecipe(yellowPearl,
						new Object[]{	"XXX",
										"XYX",
										"XXX",
						Character.valueOf('X'),Item.lightStoneDust,
						Character.valueOf('Y'),Item.enderPearl });
	//紫真珠
	ModLoader.addRecipe(purplePearl,
						new Object[]{	"XXX",
										"XYX",
										"XXX",
						Character.valueOf('X'),Block.obsidian,
						Character.valueOf('Y'),Item.enderPearl });
	
	//水真珠
	/*ModLoader.addRecipe(aquaPearl,
						new Object[]{	"XXX",
										"XYX",
										"XXX",
						Character.valueOf('X'),Block.ice,
						Character.valueOf('Y'),Item.enderPearl });*/
	
	//橙真珠
	ModLoader.addRecipe(orangePearl,
						new Object[]{	"XXX",
										"XYX",
										"XXX",
						Character.valueOf('X'),Item.blazePowder,
						Character.valueOf('Y'),Item.enderPearl });
	
	//蓬莱の玉の枝
	ModLoader.addRecipe(new ItemStack(houraiedaItem),
						new Object[]{	"YRB",
										"GEP",
										" E ",
						Character.valueOf('Y'),yellowPearl,
						Character.valueOf('R'),redPearl,
						Character.valueOf('B'),bluePearl,
						Character.valueOf('G'),greenPearl,
						Character.valueOf('P'),purplePearl,
						Character.valueOf('E'),Item.ingotGold });
	//仏の御石の鉢
	ModLoader.addRecipe(new ItemStack(hotokehachiItem),
						new Object[]{	"DOD",
										"O O",
										"DOD",
						Character.valueOf('D'),Item.diamond,
						Character.valueOf('O'),Block.obsidian });
	//火鼠の皮衣
	ModLoader.addRecipe(new ItemStack(hinezumiItem),
						new Object[]{	"BDB",
										"BPB",
										"B B",
						Character.valueOf('B'),Item.blazePowder,
						Character.valueOf('D'),Item.diamond,
						Character.valueOf('P'),Item.plateLeather });
	//燕の子安貝
	ModLoader.addRecipe(new ItemStack(koyasugaiItem),
						new Object[]{	"GGG",
										"FEF",
										"WWW",
						Character.valueOf('E'),Item.egg,
						Character.valueOf('W'),Item.wheat,
						Character.valueOf('F'),Item.feather,
						Character.valueOf('G'),Item.ghastTear });
	//龍の頸の玉
	ModLoader.addRecipe(new ItemStack(ryuutamaItem),
						new Object[]{ 	"GWG",
										"LDL",
										"GWG",
						Character.valueOf('D'),Item.diamond,
						Character.valueOf('L'),Item.bucketLava,
						Character.valueOf('W'),Item.bucketWater,
						Character.valueOf('G'),Block.glowStone});
	//金閣寺の一枚天井
	ModLoader.addRecipe(new ItemStack(kinkakuziItem),
						new Object[]{	"WWW",
										"GGG",
						Character.valueOf('W'),Block.planks,
						Character.valueOf('G'),Block.blockGold});
	//金閣寺の一枚天井を金ブロック3つに還元するレシピ
	ModLoader.addRecipe(new ItemStack(Block.blockGold,3),
						new Object[]{	"K",
						Character.valueOf('K'),kinkakuziItem});
	
	//エイジャの赤石
	ModLoader.addRecipe(new ItemStack(ajaRedStoneItem),
						new Object[]{	"RRR",
										"RRR",
										"RRR",
						Character.valueOf('R'),redPearl});
	
	//舟幽霊の柄杓
	ModLoader.addRecipe(new ItemStack(hisyakuItem),
						new Object[]{	" SB",
										" WS",
										"W  ",
						Character.valueOf('B'),Item.bowlEmpty,
						Character.valueOf('W'),Item.stick,
						Character.valueOf('S'),Block.slowSand});
	//死神の大鎌
	ModLoader.addRecipe(new ItemStack(deathScytheItem),
						new Object[]{	"III",
										" S ",
										"S  ",
						Character.valueOf('I'),Item.ingotIron,
						Character.valueOf('S'),Block.slowSand});
	//悔悟の棒
	ModLoader.addRecipe(new ItemStack(kaigoItem),
						new Object[]{	"WPB",
										"WPB",
										" S ",
						Character.valueOf('W'),new ItemStack(Item.dyePowder, 1, 0),
						Character.valueOf('B'),new ItemStack(Item.dyePowder, 1, 15),
						Character.valueOf('S'),Item.stick,
						Character.valueOf('P'),Block.planks});
	//ナズーリンペンデュラム
	ModLoader.addRecipe(new ItemStack(pendulumItem),
						new Object[]{	" I ",
										"I I",
										" D ",
						Character.valueOf('I'),Item.ingotIron,
						Character.valueOf('D'),Item.diamond});
	//楼観剣
	ModLoader.addRecipe(new ItemStack(roukankenItem),
						new Object[]{	"  I",
										"FI ",
										"S  ",
						Character.valueOf('I'),Item.ingotIron,
						Character.valueOf('F'),BlockFlower.plantRed,
						Character.valueOf('S'),Item.swordIron});
	//咲夜の懐中時計
	ModLoader.addRecipe(new ItemStack(sakuyawatchItem),
						new Object[]{	" Y ",
										"RCR",
										" R ",
						Character.valueOf('Y'),yellowPearl,
						Character.valueOf('R'), Item.redstone ,
						Character.valueOf('C'), Item.pocketSundial});
	//銀のナイフ 青
	ModLoader.addRecipe(silverKnifeBlue,
						new Object[]{	"I ",
										" R",
						Character.valueOf('R'),new ItemStack(Item.dyePowder, 1, 4) ,
						Character.valueOf('I'),Item.ingotIron });
	
	//銀のナイフ 赤
	ModLoader.addRecipe(silverKnifeRed,
						new Object[]{	"I ",
										" R",
						Character.valueOf('R'),Item.redstone ,
						Character.valueOf('I'),Item.ingotIron });
	//銀のナイフ 緑
	/*ModLoader.addRecipe(silverKnifeGreen,
						new Object[]{	"I ",
										" R",
						Character.valueOf('R'),Item.emerald ,
						Character.valueOf('I'),Item.ingotIron });*/
	
	//スキマ
	ModLoader.addRecipe(new ItemStack(sukimaItem, 2),
						new Object[]{	" KR",
										"KEK",
										"RK ",
						Character.valueOf('K'),Block.obsidian,
						Character.valueOf('R'),new ItemStack(Item.dyePowder, 1, 1),
						Character.valueOf('E'),Item.eyeOfEnder });
	//第三の眼
	ModLoader.addRecipe(new ItemStack(thirdeyeItem),
						new Object[]{	" X ",
										"XYX",
										" X ",
						Character.valueOf('X'),new ItemStack(Item.dyePowder, 1, 1),
						Character.valueOf('Y'),Item.eyeOfEnder });
	//魔人経巻
	ModLoader.addRecipe(new ItemStack(mazinkyoukanItem),
						new Object[]{	"BRB",
										"BRB",
										"BRB",
						Character.valueOf('B'),Block.blockLapis,
						Character.valueOf('R'),Block.blockRedstone});
	//緋想の剣
	ModLoader.addRecipe(new ItemStack(hisouItem),
						new Object[]{	" PG",
										"PGP",
										"RP ",
						Character.valueOf('P'),Item.blazePowder,
						Character.valueOf('G'),Block.glowStone,
						Character.valueOf('R'),Item.blazeRod});
	//幽々子の扇
	ModLoader.addRecipe(new ItemStack(yuyukoOugiItem),
						new Object[]{	"RDL",
										"SPS",
										"TST",
						Character.valueOf('D'),Item.diamond,
						Character.valueOf('P'),Item.paper,
						Character.valueOf('S'),Item.stick,
						Character.valueOf('T'),Item.ghastTear,
						Character.valueOf('R'),Item.redstone,
						Character.valueOf('L'),new ItemStack(Item.dyePowder, 1, 4)});
	//風祝のお祓い棒
	ModLoader.addRecipe(new ItemStack(oharaibouSItem),
						new Object[]{	" FP",
										" S ",
										"S  ",
						Character.valueOf('S'),Item.stick,
						Character.valueOf('P'),Item.paper,
						Character.valueOf('F'),Item.feather});
	//御柱
	ModLoader.addRecipe(new ItemStack(onbashiraItem),
						new Object[]{	"PWP",
										" W ",
										" W ",
						Character.valueOf('W'),Block.wood,
						Character.valueOf('P'),Item.paper});
	//ミニ八卦炉
	ModLoader.addRecipe(new ItemStack(hakkeroItem),
						new Object[]{	"IBI",
										"BFB",
										"IBI",
						Character.valueOf('I'),Item.ingotIron,
						Character.valueOf('F'),Item.flintAndSteel,
						Character.valueOf('B'),Item.blazeRod});
	//壁抜けの鑿
	ModLoader.addRecipe(new ItemStack(kabenukenomiItem),
						new Object[]{	"GSS",
										"E  ",
						Character.valueOf('G'),Item.ingotGold,
						Character.valueOf('S'),Item.stick,
						Character.valueOf('E'),Item.enderPearl});
	//豊聡耳の宝剣
	ModLoader.addRecipe(new ItemStack(mikoSwordItem),
						new Object[]{	"DID",
										"DID",
										"DGD",
						Character.valueOf('D'),Item.lightStoneDust,
						Character.valueOf('I'), Item.ingotIron,
						Character.valueOf('G'), Item.ingotGold});
	
	//閉ざした第三の眼
	ModLoader.addRecipe(new ItemStack(closedThirdEyeItem),
						new Object[]{	"OOO",
										"OTO",
										"OOO",
						Character.valueOf('O'),Block.obsidian,
						Character.valueOf('T'),thirdeyeItem});
	
	//ホーミングアミュレット
	ModLoader.addRecipe(new ItemStack(homingAmuletItem, 16),
						new Object[]{	"PPP",
										"PRP",
										"PPP",
						Character.valueOf('P'),Item.paper,
						Character.valueOf('R'),new ItemStack(Item.dyePowder, 1, 1)});
	
	//幽香の日傘
	ModLoader.addRecipe(new ItemStack(yuukaParasolItem),
						new Object[]{	"YRO",
										" IR",
										"I Y",
						Character.valueOf('O'),orangePearl,
						Character.valueOf('I'),Item.ingotIron,
						Character.valueOf('Y'),BlockFlower.plantYellow,
						Character.valueOf('R'),BlockFlower.plantRed});
	
	//河童の帽子
	ModLoader.addRecipe(new ItemStack(kappaCapItem),
						new Object[]{	"LWL",
										"SCS",
						Character.valueOf('L'),Block.waterlily,
						Character.valueOf('W'),Item.bucketWater,
						Character.valueOf('S'),Item.slimeBall,
						Character.valueOf('C'),Item.helmetLeather });
	//弾の素
	ModLoader.addShapelessRecipe(new ItemStack(shotMaterialItem, 64),
						new Object[]{
						new ItemStack(Item.lightStoneDust, 1), new ItemStack(Item.gunpowder, 1)});
	//粒弾
	ModLoader.addRecipe(tinyShot,
						new Object[]{	"B",
						Character.valueOf('B'),shotMaterialItem });
	//小弾
	ModLoader.addRecipe(smallShot,
						new Object[]{	"BB",
						Character.valueOf('B'),shotMaterialItem });
	//中弾
	ModLoader.addRecipe(mediumShot,
						new Object[]{	"BB",
										"BB",
						Character.valueOf('B'),shotMaterialItem });
	//大弾
	ModLoader.addRecipe(bigShot,
						new Object[]{	"BBB",
										"BBB",
										"BBB",
						Character.valueOf('B'),shotMaterialItem });
	//鱗弾
	ModLoader.addRecipe(circleShot,
						new Object[]{	" B ",
										"BBB",
										" B " ,
						Character.valueOf('B'),shotMaterialItem });
	//星
	ModLoader.addRecipe(smallStarShot,
						new Object[]{	" B ",
										"BBB",
										"B B",
						Character.valueOf('B'),shotMaterialItem });
	//星
	ModLoader.addRecipe(starShot,
						new Object[]{	"BB",
						Character.valueOf('B'),smallStarShot });
	//鱗弾
	ModLoader.addRecipe(scaleShot,
						new Object[]{	" B ",
										"B B",
										"B B",
						Character.valueOf('B'),shotMaterialItem });
	//蝶弾
	ModLoader.addRecipe(butterflyShot,
						new Object[]{	"B B",
										" B ",
										"B B",
						Character.valueOf('B'),shotMaterialItem });
	//光弾
	ModLoader.addRecipe(lightShot,
						new Object[]{	"B B",
										"   ",
										"B B",
						Character.valueOf('B'),shotMaterialItem });
	
	//霊符「夢想封印」
	ModLoader.addRecipe(spellCard[0],
						new Object[]{	"GOG",
										"OPO",
										"GOG",
						Character.valueOf('P'),Item.paper,
						Character.valueOf('O'),bigShot,
						Character.valueOf('G'),Item.lightStoneDust});
	//恋符「マスタースパーク」
	ModLoader.addRecipe(spellCard[1],
						new Object[]{	"SRS",
										"SPS",
										"SHS",
						Character.valueOf('P'),Item.paper,
						Character.valueOf('H'),hakkeroItem,
						Character.valueOf('S'),starShot,
						Character.valueOf('R'),Block.blockRedstone});
	//死蝶「華胥の永眠」
	ModLoader.addRecipe(spellCard[2],
						new Object[]{	"BBB",
										"BPB",
										"BBB",
						Character.valueOf('P'),Item.paper,
						Character.valueOf('B'),butterflyShot});
	//星符「メテオニックシャワー」
	ModLoader.addRecipe(spellCard[3],
						new Object[]{	"BBB",
										"BPB",
						Character.valueOf('P'),Item.paper,
						Character.valueOf('B'),starShot});
	
	//境符「粒と波の境界」
	ModLoader.addRecipe(spellCard[4],
						new Object[]{	"LWL",
										"WPW",
										"LWL",
						Character.valueOf('P'),Item.paper,
						Character.valueOf('W'),Item.bucketWater,
						Character.valueOf('L'), lightShot});
	
	
}

	
	
	
}