/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.miccore;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MicdoodleTransformer
implements IClassTransformer {
    HashMap<String, ObfuscationEntry> nodemap = new HashMap();
    private boolean deobfuscated = true;
    private boolean optifinePresent;
    private DefaultArtifactVersion mcVersion = new DefaultArtifactVersion((String)FMLInjectionData.data()[4]);
    private static final String KEY_CLASS_PLAYER_MP = "PlayerMP";
    private static final String KEY_CLASS_WORLD = "worldClass";
    private static final String KEY_CLASS_CONF_MANAGER = "confManagerClass";
    private static final String KEY_CLASS_GAME_PROFILE = "gameProfileClass";
    private static final String KEY_CLASS_ITEM_IN_WORLD_MANAGER = "itemInWorldManagerClass";
    private static final String KEY_CLASS_PLAYER_CONTROLLER = "playerControllerClass";
    private static final String KEY_CLASS_PLAYER_SP = "playerClient";
    private static final String KEY_CLASS_STAT_FILE_WRITER = "statFileWriterClass";
    private static final String KEY_CLASS_NET_HANDLER_PLAY = "netHandlerPlayClientClass";
    private static final String KEY_CLASS_ENTITY_LIVING = "entityLivingClass";
    private static final String KEY_CLASS_ENTITY_ITEM = "entityItemClass";
    private static final String KEY_CLASS_ENTITY_RENDERER = "entityRendererClass";
    private static final String KEY_CLASS_WORLD_RENDERER = "worldRendererClass";
    private static final String KEY_CLASS_RENDER_GLOBAL = "renderGlobalClass";
    private static final String KEY_CLASS_RENDER_MANAGER = "renderManagerClass";
    private static final String KEY_CLASS_TESSELLATOR = "tessellatorClass";
    private static final String KEY_CLASS_TILEENTITY_RENDERER = "tileEntityRendererClass";
    private static final String KEY_CLASS_CONTAINER_PLAYER = "containerPlayer";
    private static final String KEY_CLASS_MINECRAFT = "minecraft";
    private static final String KEY_CLASS_SESSION = "session";
    private static final String KEY_CLASS_GUI_SCREEN = "guiScreen";
    private static final String KEY_CLASS_ITEM_RENDERER = "itemRendererClass";
    private static final String KEY_CLASS_VEC3 = "vecClass";
    private static final String KEY_CLASS_ENTITY = "entityClass";
    private static final String KEY_CLASS_TILEENTITY = "tileEntityClass";
    private static final String KEY_CLASS_GUI_SLEEP = "guiSleepClass";
    private static final String KEY_CLASS_EFFECT_RENDERER = "effectRendererClass";
    private static final String KEY_CLASS_FORGE_HOOKS_CLIENT = "forgeHooks";
    private static final String KEY_CLASS_CUSTOM_PLAYER_MP = "customPlayerMP";
    private static final String KEY_CLASS_CUSTOM_PLAYER_SP = "customPlayerSP";
    private static final String KEY_CLASS_CUSTOM_OTHER_PLAYER = "customEntityOtherPlayer";
    private static final String KEY_CLASS_PACKET_SPAWN_PLAYER = "packetSpawnPlayer";
    private static final String KEY_CLASS_ENTITY_OTHER_PLAYER = "entityOtherPlayer";
    private static final String KEY_CLASS_SERVER = "minecraftServer";
    private static final String KEY_CLASS_WORLD_SERVER = "worldServer";
    private static final String KEY_CLASS_WORLD_CLIENT = "worldClient";
    private static final String KEY_CLASS_MUSIC_TICKER = "musicTicker";
    private static final String KEY_NET_HANDLER_LOGIN_SERVER = "netHandlerLoginServer";
    private static final String KEY_FIELD_THE_PLAYER = "thePlayer";
    private static final String KEY_FIELD_WORLDRENDERER_GLRENDERLIST = "glRenderList";
    private static final String KEY_METHOD_CREATE_PLAYER = "createPlayerMethod";
    private static final String KEY_METHOD_RESPAWN_PLAYER = "respawnPlayerMethod";
    private static final String KEY_METHOD_CREATE_CLIENT_PLAYER = "createClientPlayerMethod";
    private static final String KEY_METHOD_MOVE_ENTITY = "moveEntityMethod";
    private static final String KEY_METHOD_ON_UPDATE = "onUpdateMethod";
    private static final String KEY_METHOD_UPDATE_LIGHTMAP = "updateLightmapMethod";
    private static final String KEY_METHOD_RENDER_OVERLAYS = "renderOverlaysMethod";
    private static final String KEY_METHOD_UPDATE_FOG_COLOR = "updateFogColorMethod";
    private static final String KEY_METHOD_GET_FOG_COLOR = "getFogColorMethod";
    private static final String KEY_METHOD_GET_SKY_COLOR = "getSkyColorMethod";
    private static final String KEY_METHOD_WAKE_ENTITY = "wakeEntityMethod";
    private static final String KEY_METHOD_BED_ORIENT_CAMERA = "orientBedCamera";
    private static final String KEY_METHOD_RENDER_PARTICLES = "renderParticlesMethod";
    private static final String KEY_METHOD_CUSTOM_PLAYER_MP = "customPlayerMPConstructor";
    private static final String KEY_METHOD_CUSTOM_PLAYER_SP = "customPlayerSPConstructor";
    private static final String KEY_METHOD_ATTEMPT_LOGIN_BUKKIT = "attemptLoginMethodBukkit";
    private static final String KEY_METHOD_HANDLE_SPAWN_PLAYER = "handleSpawnPlayerMethod";
    private static final String KEY_METHOD_ORIENT_CAMERA = "orientCamera";
    private static final String KEY_METHOD_RENDERMANAGER = "renderManagerMethod";
    private static final String KEY_METHOD_PRERENDER_BLOCKS = "preRenderBlocksMethod";
    private static final String KEY_METHOD_SETUP_GL = "setupGLTranslationMethod";
    private static final String KEY_METHOD_SET_POSITION = "setPositionMethod";
    private static final String KEY_METHOD_WORLDRENDERER_UPDATERENDERER = "updateRendererMethod";
    private static final String KEY_METHOD_LOAD_RENDERERS = "loadRenderersMethod";
    private static final String KEY_METHOD_RENDERGLOBAL_INIT = "renderGlobalInitMethod";
    private static final String KEY_METHOD_RENDERGLOBAL_SORTANDRENDER = "sortAndRenderMethod";
    private static final String KEY_METHOD_TESSELLATOR_ADDVERTEX = "addVertexMethod";
    private static final String KEY_METHOD_TILERENDERER_RENDERTILEAT = "renderTileAtMethod";
    private static final String KEY_METHOD_START_GAME = "startGame";
    private static final String KEY_METHOD_CAN_RENDER_FIRE = "canRenderOnFire";
    private static final String CLASS_RUNTIME_INTERFACE = "micdoodle8/mods/miccore/Annotations$RuntimeInterface";
    private static final String CLASS_MICDOODLE_PLUGIN = "micdoodle8/mods/miccore/MicdoodlePlugin";
    private static final String CLASS_CLIENT_PROXY_MAIN = "micdoodle8/mods/galacticraft/core/proxy/ClientProxyCore";
    private static final String CLASS_MUSIC_TICKER_GC = "micdoodle8/mods/galacticraft/core/client/sounds/MusicTickerGC";
    private static final String CLASS_WORLD_UTIL = "micdoodle8/mods/galacticraft/core/util/WorldUtil";
    private static final String CLASS_GL11 = "org/lwjgl/opengl/GL11";
    private static int operationCount = 0;
    private static int injectionCount = 0;

    public MicdoodleTransformer() {
        try {
            LaunchClassLoader loader = new LaunchClassLoader(((URLClassLoader)this.getClass().getClassLoader()).getURLs());
            URL classResource = loader.findResource(String.valueOf("net.minecraft.world.World").replace('.', '/').concat(".class"));
            this.deobfuscated = classResource != null;
            classResource = loader.findResource(String.valueOf("CustomColorizer").replace('.', '/').concat(".class"));
            this.optifinePresent = classResource != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mcVersionMatches("1.7.2")) {
            this.nodemap.put(KEY_CLASS_PLAYER_MP, new ObfuscationEntry("net/minecraft/entity/player/EntityPlayerMP", "mm"));
            this.nodemap.put(KEY_CLASS_WORLD, new ObfuscationEntry("net/minecraft/world/World", "afn"));
            this.nodemap.put(KEY_CLASS_CONF_MANAGER, new ObfuscationEntry("net/minecraft/server/management/ServerConfigurationManager", "ld"));
            this.nodemap.put(KEY_CLASS_GAME_PROFILE, new ObfuscationEntry("com/mojang/authlib/GameProfile"));
            this.nodemap.put(KEY_CLASS_ITEM_IN_WORLD_MANAGER, new ObfuscationEntry("net/minecraft/server/management/ItemInWorldManager", "mn"));
            this.nodemap.put(KEY_CLASS_PLAYER_CONTROLLER, new ObfuscationEntry("net/minecraft/client/multiplayer/PlayerControllerMP", "biy"));
            this.nodemap.put(KEY_CLASS_PLAYER_SP, new ObfuscationEntry("net/minecraft/client/entity/EntityClientPlayerMP", "bje"));
            this.nodemap.put(KEY_CLASS_STAT_FILE_WRITER, new ObfuscationEntry("net/minecraft/stats/StatFileWriter", "oe"));
            this.nodemap.put(KEY_CLASS_NET_HANDLER_PLAY, new ObfuscationEntry("net/minecraft/client/network/NetHandlerPlayClient", "biv"));
            this.nodemap.put(KEY_CLASS_ENTITY_LIVING, new ObfuscationEntry("net/minecraft/entity/EntityLivingBase", "rh"));
            this.nodemap.put(KEY_CLASS_ENTITY_ITEM, new ObfuscationEntry("net/minecraft/entity/item/EntityItem", "vw"));
            this.nodemap.put(KEY_CLASS_ENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/EntityRenderer", "bll"));
            this.nodemap.put(KEY_CLASS_WORLD_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/WorldRenderer", "blg"));
            this.nodemap.put(KEY_CLASS_RENDER_GLOBAL, new ObfuscationEntry("net/minecraft/client/renderer/RenderGlobal", "bls"));
            this.nodemap.put(KEY_CLASS_TESSELLATOR, new ObfuscationEntry("net/minecraft/client/renderer/Tessellator", "blz"));
            this.nodemap.put(KEY_CLASS_RENDER_MANAGER, new ObfuscationEntry("net/minecraft/client/renderer/entity/RenderManager", "bnf"));
            this.nodemap.put(KEY_CLASS_TILEENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher", "bmc"));
            this.nodemap.put(KEY_CLASS_CONTAINER_PLAYER, new ObfuscationEntry("net/minecraft/inventory/ContainerPlayer", "zb"));
            this.nodemap.put(KEY_CLASS_MINECRAFT, new ObfuscationEntry("net/minecraft/client/Minecraft", "azd"));
            this.nodemap.put(KEY_CLASS_SESSION, new ObfuscationEntry("net/minecraft/util/Session", "baf"));
            this.nodemap.put(KEY_CLASS_GUI_SCREEN, new ObfuscationEntry("net/minecraft/client/gui/GuiScreen", "bcd"));
            this.nodemap.put(KEY_CLASS_ITEM_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/ItemRenderer", "blq"));
            this.nodemap.put(KEY_CLASS_VEC3, new ObfuscationEntry("net/minecraft/util/Vec3", "ayk"));
            this.nodemap.put(KEY_CLASS_ENTITY, new ObfuscationEntry("net/minecraft/entity/Entity", "qn"));
            this.nodemap.put(KEY_CLASS_GUI_SLEEP, new ObfuscationEntry("net/minecraft/client/gui/GuiSleepMP", "bbp"));
            this.nodemap.put(KEY_CLASS_EFFECT_RENDERER, new ObfuscationEntry("net/minecraft/client/particle/EffectRenderer", "bkg"));
            this.nodemap.put(KEY_CLASS_FORGE_HOOKS_CLIENT, new ObfuscationEntry("net/minecraftforge/client/ForgeHooksClient"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_MP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_SP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityClientPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_OTHER_PLAYER, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityOtherPlayerMP"));
            this.nodemap.put(KEY_CLASS_PACKET_SPAWN_PLAYER, new ObfuscationEntry("net/minecraft/network/play/server/S0CPacketSpawnPlayer", "fs"));
            this.nodemap.put(KEY_CLASS_ENTITY_OTHER_PLAYER, new ObfuscationEntry("net/minecraft/client/entity/EntityOtherPlayerMP", "bld"));
            this.nodemap.put(KEY_CLASS_SERVER, new ObfuscationEntry("net/minecraft/server/MinecraftServer"));
            this.nodemap.put(KEY_CLASS_WORLD_SERVER, new ObfuscationEntry("net/minecraft/world/WorldServer", "mj"));
            this.nodemap.put(KEY_CLASS_WORLD_CLIENT, new ObfuscationEntry("net/minecraft/client/multiplayer/WorldClient", "biz"));
            this.nodemap.put(KEY_CLASS_TILEENTITY, new ObfuscationEntry("net/minecraft/tileentity/TileEntity", "and"));
            this.nodemap.put(KEY_CLASS_MUSIC_TICKER, new ObfuscationEntry("net/minecraft/client/audio/MusicTicker", "bst"));
            this.nodemap.put(KEY_NET_HANDLER_LOGIN_SERVER, new ObfuscationEntry("net/minecraft/server/network/NetHandlerLoginServer", "nd"));
            this.nodemap.put(KEY_FIELD_THE_PLAYER, new FieldObfuscationEntry(KEY_FIELD_THE_PLAYER, "h"));
            this.nodemap.put(KEY_FIELD_WORLDRENDERER_GLRENDERLIST, new FieldObfuscationEntry(KEY_FIELD_WORLDRENDERER_GLRENDERLIST, "z"));
            this.nodemap.put(KEY_METHOD_CREATE_PLAYER, new MethodObfuscationEntry("createPlayerForUser", "a", "(L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_RESPAWN_PLAYER, new MethodObfuscationEntry("respawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";IZ)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_CREATE_CLIENT_PLAYER, new MethodObfuscationEntry("func_147493_a", "a", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_SP) + ";"));
            this.nodemap.put(KEY_METHOD_MOVE_ENTITY, new MethodObfuscationEntry("moveEntityWithHeading", "e", "(FF)V"));
            this.nodemap.put(KEY_METHOD_ON_UPDATE, new MethodObfuscationEntry("onUpdate", "h", "()V"));
            this.nodemap.put(KEY_METHOD_UPDATE_LIGHTMAP, new MethodObfuscationEntry("updateLightmap", "h", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDER_OVERLAYS, new MethodObfuscationEntry("renderOverlays", "b", "(F)V"));
            this.nodemap.put(KEY_METHOD_UPDATE_FOG_COLOR, new MethodObfuscationEntry("updateFogColor", "i", "(F)V"));
            this.nodemap.put(KEY_METHOD_GET_FOG_COLOR, new MethodObfuscationEntry("getFogColor", "f", "(F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_GET_SKY_COLOR, new MethodObfuscationEntry("getSkyColor", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_WAKE_ENTITY, new MethodObfuscationEntry("func_146418_g", "g", "()V"));
            this.nodemap.put(KEY_METHOD_BED_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_BED_ORIENT_CAMERA, "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDER_PARTICLES, new MethodObfuscationEntry("renderParticles", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_MP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";L" + this.getNameDynamic(KEY_CLASS_ITEM_IN_WORLD_MANAGER) + ";)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_SP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_SESSION) + ";L" + this.getNameDynamic(KEY_CLASS_NET_HANDLER_PLAY) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";)V"));
            this.nodemap.put(KEY_METHOD_HANDLE_SPAWN_PLAYER, new MethodObfuscationEntry("handleSpawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PACKET_SPAWN_PLAYER) + ";)V"));
            this.nodemap.put(KEY_METHOD_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_ORIENT_CAMERA, "g", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDERMANAGER, new MethodObfuscationEntry("func_147939_a", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";DDDFFZ)Z"));
            this.nodemap.put(KEY_METHOD_SETUP_GL, new MethodObfuscationEntry("setupGLTranslation", "f", "()V"));
            this.nodemap.put(KEY_METHOD_PRERENDER_BLOCKS, new MethodObfuscationEntry("preRenderBlocks", "b", "(I)V"));
            this.nodemap.put(KEY_METHOD_SET_POSITION, new MethodObfuscationEntry("setPosition", "a", "(III)V"));
            this.nodemap.put(KEY_METHOD_WORLDRENDERER_UPDATERENDERER, new MethodObfuscationEntry("updateRenderer", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)V"));
            this.nodemap.put(KEY_METHOD_LOAD_RENDERERS, new MethodObfuscationEntry("loadRenderers", "a", "()V"));
            this.nodemap.put(KEY_METHOD_RENDERGLOBAL_INIT, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDERGLOBAL_SORTANDRENDER, new MethodObfuscationEntry("sortAndRender", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";ID)I"));
            this.nodemap.put(KEY_METHOD_TESSELLATOR_ADDVERTEX, new MethodObfuscationEntry("addVertex", "a", "(DDD)V"));
            this.nodemap.put(KEY_METHOD_TILERENDERER_RENDERTILEAT, new MethodObfuscationEntry("renderTileEntityAt", "a", "(L" + this.getNameDynamic(KEY_CLASS_TILEENTITY) + ";DDDF)V"));
            this.nodemap.put(KEY_METHOD_START_GAME, new MethodObfuscationEntry(KEY_METHOD_START_GAME, "Z", "()V"));
            this.nodemap.put(KEY_METHOD_CAN_RENDER_FIRE, new MethodObfuscationEntry(KEY_METHOD_CAN_RENDER_FIRE, "aA", "()Z"));
            this.nodemap.put(KEY_METHOD_ATTEMPT_LOGIN_BUKKIT, new MethodObfuscationEntry("attemptLogin", "attemptLogin", "(L" + this.getNameDynamic(KEY_NET_HANDLER_LOGIN_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";Ljava/lang/String;)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
        } else if (this.mcVersionMatches("1.7.10")) {
            this.nodemap.put(KEY_CLASS_PLAYER_MP, new ObfuscationEntry("net/minecraft/entity/player/EntityPlayerMP", "mw"));
            this.nodemap.put(KEY_CLASS_WORLD, new ObfuscationEntry("net/minecraft/world/World", "ahb"));
            this.nodemap.put(KEY_CLASS_CONF_MANAGER, new ObfuscationEntry("net/minecraft/server/management/ServerConfigurationManager", "oi"));
            this.nodemap.put(KEY_CLASS_GAME_PROFILE, new ObfuscationEntry("com/mojang/authlib/GameProfile"));
            this.nodemap.put(KEY_CLASS_ITEM_IN_WORLD_MANAGER, new ObfuscationEntry("net/minecraft/server/management/ItemInWorldManager", "mx"));
            this.nodemap.put(KEY_CLASS_PLAYER_CONTROLLER, new ObfuscationEntry("net/minecraft/client/multiplayer/PlayerControllerMP", "bje"));
            this.nodemap.put(KEY_CLASS_PLAYER_SP, new ObfuscationEntry("net/minecraft/client/entity/EntityClientPlayerMP", "bjk"));
            this.nodemap.put(KEY_CLASS_STAT_FILE_WRITER, new ObfuscationEntry("net/minecraft/stats/StatFileWriter", "pq"));
            this.nodemap.put(KEY_CLASS_NET_HANDLER_PLAY, new ObfuscationEntry("net/minecraft/client/network/NetHandlerPlayClient", "bjb"));
            this.nodemap.put(KEY_CLASS_ENTITY_LIVING, new ObfuscationEntry("net/minecraft/entity/EntityLivingBase", "sv"));
            this.nodemap.put(KEY_CLASS_ENTITY_ITEM, new ObfuscationEntry("net/minecraft/entity/item/EntityItem", "xk"));
            this.nodemap.put(KEY_CLASS_ENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/EntityRenderer", "blt"));
            this.nodemap.put(KEY_CLASS_WORLD_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/WorldRenderer", "blo"));
            this.nodemap.put(KEY_CLASS_RENDER_GLOBAL, new ObfuscationEntry("net/minecraft/client/renderer/RenderGlobal", "bma"));
            this.nodemap.put(KEY_CLASS_TESSELLATOR, new ObfuscationEntry("net/minecraft/client/renderer/Tessellator", "bmh"));
            this.nodemap.put(KEY_CLASS_RENDER_MANAGER, new ObfuscationEntry("net/minecraft/client/renderer/entity/RenderManager", "bnn"));
            this.nodemap.put(KEY_CLASS_TILEENTITY_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/tileentity/TileEntityRendererDispatcher", "bmk"));
            this.nodemap.put(KEY_CLASS_CONTAINER_PLAYER, new ObfuscationEntry("net/minecraft/inventory/ContainerPlayer", "aap"));
            this.nodemap.put(KEY_CLASS_MINECRAFT, new ObfuscationEntry("net/minecraft/client/Minecraft", "bao"));
            this.nodemap.put(KEY_CLASS_SESSION, new ObfuscationEntry("net/minecraft/util/Session", "bbs"));
            this.nodemap.put(KEY_CLASS_GUI_SCREEN, new ObfuscationEntry("net/minecraft/client/gui/GuiScreen", "bdw"));
            this.nodemap.put(KEY_CLASS_ITEM_RENDERER, new ObfuscationEntry("net/minecraft/client/renderer/ItemRenderer", "bly"));
            this.nodemap.put(KEY_CLASS_VEC3, new ObfuscationEntry("net/minecraft/util/Vec3", "azw"));
            this.nodemap.put(KEY_CLASS_ENTITY, new ObfuscationEntry("net/minecraft/entity/Entity", "sa"));
            this.nodemap.put(KEY_CLASS_GUI_SLEEP, new ObfuscationEntry("net/minecraft/client/gui/GuiSleepMP", "bdi"));
            this.nodemap.put(KEY_CLASS_EFFECT_RENDERER, new ObfuscationEntry("net/minecraft/client/particle/EffectRenderer", "bkn"));
            this.nodemap.put(KEY_CLASS_FORGE_HOOKS_CLIENT, new ObfuscationEntry("net/minecraftforge/client/ForgeHooksClient"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_MP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_PLAYER_SP, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityClientPlayerMP"));
            this.nodemap.put(KEY_CLASS_CUSTOM_OTHER_PLAYER, new ObfuscationEntry("micdoodle8/mods/galacticraft/core/entities/player/GCEntityOtherPlayerMP"));
            this.nodemap.put(KEY_CLASS_PACKET_SPAWN_PLAYER, new ObfuscationEntry("net/minecraft/network/play/server/S0CPacketSpawnPlayer", "gb"));
            this.nodemap.put(KEY_CLASS_ENTITY_OTHER_PLAYER, new ObfuscationEntry("net/minecraft/client/entity/EntityOtherPlayerMP", "bll"));
            this.nodemap.put(KEY_CLASS_SERVER, new ObfuscationEntry("net/minecraft/server/MinecraftServer"));
            this.nodemap.put(KEY_CLASS_WORLD_SERVER, new ObfuscationEntry("net/minecraft/world/WorldServer", "mt"));
            this.nodemap.put(KEY_CLASS_WORLD_CLIENT, new ObfuscationEntry("net/minecraft/client/multiplayer/WorldClient", "bjf"));
            this.nodemap.put(KEY_CLASS_TILEENTITY, new ObfuscationEntry("net/minecraft/tileentity/TileEntity", "aor"));
            this.nodemap.put(KEY_CLASS_MUSIC_TICKER, new ObfuscationEntry("net/minecraft/client/audio/MusicTicker", "btg"));
            this.nodemap.put(KEY_NET_HANDLER_LOGIN_SERVER, new ObfuscationEntry("net/minecraft/server/network/NetHandlerLoginServer", "nn"));
            this.nodemap.put(KEY_FIELD_THE_PLAYER, new FieldObfuscationEntry(KEY_FIELD_THE_PLAYER, "h"));
            this.nodemap.put(KEY_FIELD_WORLDRENDERER_GLRENDERLIST, new FieldObfuscationEntry(KEY_FIELD_WORLDRENDERER_GLRENDERLIST, "z"));
            this.nodemap.put(KEY_METHOD_CREATE_PLAYER, new MethodObfuscationEntry("createPlayerForUser", "f", "(L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_RESPAWN_PLAYER, new MethodObfuscationEntry("respawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";IZ)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
            this.nodemap.put(KEY_METHOD_CREATE_CLIENT_PLAYER, new MethodObfuscationEntry("func_147493_a", "a", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";)L" + this.getNameDynamic(KEY_CLASS_PLAYER_SP) + ";"));
            this.nodemap.put(KEY_METHOD_MOVE_ENTITY, new MethodObfuscationEntry("moveEntityWithHeading", "e", "(FF)V"));
            this.nodemap.put(KEY_METHOD_ON_UPDATE, new MethodObfuscationEntry("onUpdate", "h", "()V"));
            this.nodemap.put(KEY_METHOD_UPDATE_LIGHTMAP, new MethodObfuscationEntry("updateLightmap", "i", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDER_OVERLAYS, new MethodObfuscationEntry("renderOverlays", "b", "(F)V"));
            this.nodemap.put(KEY_METHOD_UPDATE_FOG_COLOR, new MethodObfuscationEntry("updateFogColor", "j", "(F)V"));
            this.nodemap.put(KEY_METHOD_GET_FOG_COLOR, new MethodObfuscationEntry("getFogColor", "f", "(F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_GET_SKY_COLOR, new MethodObfuscationEntry("getSkyColor", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
            this.nodemap.put(KEY_METHOD_WAKE_ENTITY, new MethodObfuscationEntry("func_146418_g", "f", "()V"));
            this.nodemap.put(KEY_METHOD_BED_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_BED_ORIENT_CAMERA, "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDER_PARTICLES, new MethodObfuscationEntry("renderParticles", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";F)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_MP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";L" + this.getNameDynamic(KEY_CLASS_ITEM_IN_WORLD_MANAGER) + ";)V"));
            this.nodemap.put(KEY_METHOD_CUSTOM_PLAYER_SP, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_SESSION) + ";L" + this.getNameDynamic(KEY_CLASS_NET_HANDLER_PLAY) + ";L" + this.getNameDynamic(KEY_CLASS_STAT_FILE_WRITER) + ";)V"));
            this.nodemap.put(KEY_METHOD_HANDLE_SPAWN_PLAYER, new MethodObfuscationEntry("handleSpawnPlayer", "a", "(L" + this.getNameDynamic(KEY_CLASS_PACKET_SPAWN_PLAYER) + ";)V"));
            this.nodemap.put(KEY_METHOD_ORIENT_CAMERA, new MethodObfuscationEntry(KEY_METHOD_ORIENT_CAMERA, "h", "(F)V"));
            this.nodemap.put(KEY_METHOD_RENDERMANAGER, new MethodObfuscationEntry("func_147939_a", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";DDDFFZ)Z"));
            this.nodemap.put(KEY_METHOD_SETUP_GL, new MethodObfuscationEntry("setupGLTranslation", "f", "()V"));
            this.nodemap.put(KEY_METHOD_PRERENDER_BLOCKS, new MethodObfuscationEntry("preRenderBlocks", "b", "(I)V"));
            this.nodemap.put(KEY_METHOD_SET_POSITION, new MethodObfuscationEntry("setPosition", "a", "(III)V"));
            this.nodemap.put(KEY_METHOD_WORLDRENDERER_UPDATERENDERER, new MethodObfuscationEntry("updateRenderer", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";)V"));
            this.nodemap.put(KEY_METHOD_LOAD_RENDERERS, new MethodObfuscationEntry("loadRenderers", "a", "()V"));
            this.nodemap.put(KEY_METHOD_RENDERGLOBAL_INIT, new MethodObfuscationEntry("<init>", "(L" + this.getNameDynamic(KEY_CLASS_MINECRAFT) + ";)V"));
            this.nodemap.put(KEY_METHOD_RENDERGLOBAL_SORTANDRENDER, new MethodObfuscationEntry("sortAndRender", "a", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_LIVING) + ";ID)I"));
            this.nodemap.put(KEY_METHOD_TESSELLATOR_ADDVERTEX, new MethodObfuscationEntry("addVertex", "a", "(DDD)V"));
            this.nodemap.put(KEY_METHOD_TILERENDERER_RENDERTILEAT, new MethodObfuscationEntry("renderTileEntityAt", "a", "(L" + this.getNameDynamic(KEY_CLASS_TILEENTITY) + ";DDDF)V"));
            this.nodemap.put(KEY_METHOD_START_GAME, new MethodObfuscationEntry(KEY_METHOD_START_GAME, "ag", "()V"));
            this.nodemap.put(KEY_METHOD_CAN_RENDER_FIRE, new MethodObfuscationEntry(KEY_METHOD_CAN_RENDER_FIRE, "aA", "()Z"));
            this.nodemap.put(KEY_METHOD_ATTEMPT_LOGIN_BUKKIT, new MethodObfuscationEntry("attemptLogin", "attemptLogin", "(L" + this.getNameDynamic(KEY_NET_HANDLER_LOGIN_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";Ljava/lang/String;)L" + this.getNameDynamic(KEY_CLASS_PLAYER_MP) + ";"));
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (this.classPathMatches(KEY_CLASS_CONF_MANAGER, name)) {
            bytes = this.transformConfigManager(bytes);
        } else if (this.classPathMatches(KEY_CLASS_PLAYER_CONTROLLER, name)) {
            bytes = this.transformPlayerController(bytes);
        } else if (this.classPathMatches(KEY_CLASS_ENTITY_LIVING, name)) {
            bytes = this.transformEntityLiving(bytes);
        } else if (this.classPathMatches(KEY_CLASS_ENTITY_ITEM, name)) {
            bytes = this.transformEntityItem(bytes);
        } else if (this.classPathMatches(KEY_CLASS_ENTITY_RENDERER, name)) {
            bytes = this.transformEntityRenderer(bytes);
        } else if (this.classPathMatches(KEY_CLASS_ITEM_RENDERER, name)) {
            bytes = this.transformItemRenderer(bytes);
        } else if (this.classPathMatches(KEY_CLASS_GUI_SLEEP, name)) {
            bytes = this.transformGuiSleep(bytes);
        } else if (this.classPathMatches(KEY_CLASS_FORGE_HOOKS_CLIENT, name)) {
            bytes = this.transformForgeHooks(bytes);
        } else if (this.classPathMatches(KEY_CLASS_EFFECT_RENDERER, name)) {
            bytes = this.transformEffectRenderer(bytes);
        } else if (this.classPathMatches(KEY_CLASS_NET_HANDLER_PLAY, name)) {
            bytes = this.transformNetHandlerPlay(bytes);
        } else if (this.classPathMatches(KEY_CLASS_WORLD_RENDERER, name)) {
            bytes = this.transformWorldRenderer(bytes);
        } else if (this.classPathMatches(KEY_CLASS_RENDER_GLOBAL, name)) {
            bytes = this.transformRenderGlobal(bytes);
        } else if (this.classPathMatches(KEY_CLASS_RENDER_MANAGER, name)) {
            bytes = this.transformRenderManager(bytes);
        } else if (this.classPathMatches(KEY_CLASS_TILEENTITY_RENDERER, name)) {
            bytes = this.transformTileEntityRenderer(bytes);
        } else if (this.classPathMatches(KEY_CLASS_MINECRAFT, name)) {
            bytes = this.transformMinecraftClass(bytes);
        } else if (this.classPathMatches(KEY_CLASS_ENTITY, name)) {
            bytes = this.transformEntityClass(bytes);
        }
        if (name.contains("galacticraft")) {
            bytes = this.transformCustomAnnotations(bytes);
        }
        return bytes;
    }

    public byte[] transformConfigManager(byte[] bytes) {
        TypeInsnNode overwriteNode;
        TypeInsnNode nodeAt;
        AbstractInsnNode list;
        int count;
        ClassNode node = this.startInjection(bytes);
        operationCount = 6;
        MethodNode createPlayerMethod = this.getMethod(node, KEY_METHOD_CREATE_PLAYER);
        MethodNode respawnPlayerMethod = this.getMethod(node, KEY_METHOD_RESPAWN_PLAYER);
        MethodNode attemptLoginMethod = this.getMethod(node, KEY_METHOD_ATTEMPT_LOGIN_BUKKIT);
        if (createPlayerMethod != null) {
            for (count = 0; count < createPlayerMethod.instructions.size(); ++count) {
                list = createPlayerMethod.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (nodeAt.getOpcode() == 192 || !nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                    overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                    createPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.owner.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP)) || nodeAt.getOpcode() != 183) continue;
                createPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_MP)));
                ++injectionCount;
            }
        }
        if (respawnPlayerMethod != null) {
            for (count = 0; count < respawnPlayerMethod.instructions.size(); ++count) {
                list = respawnPlayerMethod.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (nodeAt.getOpcode() == 192 || !nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                    overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                    respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                respawnPlayerMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_MP)));
                ++injectionCount;
            }
        }
        if (attemptLoginMethod != null) {
            for (count = 0; count < attemptLoginMethod.instructions.size(); ++count) {
                list = attemptLoginMethod.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (nodeAt.getOpcode() != 187 || !nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                    overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP));
                    attemptLoginMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode) || (nodeAt = (MethodInsnNode)list).getOpcode() != 183 || !nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_PLAYER_MP))) continue;
                String initDesc = "(L" + this.getNameDynamic(KEY_CLASS_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_WORLD_SERVER) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";L" + this.getNameDynamic(KEY_CLASS_ITEM_IN_WORLD_MANAGER) + ";)V";
                attemptLoginMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_MP), this.getName(KEY_METHOD_CUSTOM_PLAYER_MP), initDesc));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformPlayerController(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 2;
        MethodNode method = this.getMethod(node, KEY_METHOD_CREATE_CLIENT_PLAYER);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                TypeInsnNode nodeAt;
                AbstractInsnNode list = method.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (!nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_PLAYER_SP))) continue;
                    TypeInsnNode overwriteNode = new TypeInsnNode(187, this.getName(KEY_CLASS_CUSTOM_PLAYER_SP));
                    method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_PLAYER_SP))) continue;
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getName(KEY_CLASS_CUSTOM_PLAYER_SP), this.getName(KEY_METHOD_CUSTOM_PLAYER_SP), this.getDescDynamic(KEY_METHOD_CUSTOM_PLAYER_SP)));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityLiving(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_MOVE_ENTITY);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (!(list instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)list;
                if (!nodeAt.cst.equals(0.08)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_WORLD_UTIL, "getGravityForEntity", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";)D");
                method.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityItem(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_ON_UPDATE);
        if (method != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode list = method.instructions.get(count);
                if (!(list instanceof LdcInsnNode)) continue;
                LdcInsnNode nodeAt = (LdcInsnNode)list;
                if (!nodeAt.cst.equals(0.04f)) continue;
                VarInsnNode beforeNode = new VarInsnNode(25, 0);
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_WORLD_UTIL, "getItemGravity", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY_ITEM) + ";)D");
                method.instructions.insertBefore((AbstractInsnNode)nodeAt, (AbstractInsnNode)beforeNode);
                method.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 5;
        if (this.optifinePresent) {
            --operationCount;
        }
        MethodNode updateLightMapMethod = this.getMethod(node, KEY_METHOD_UPDATE_LIGHTMAP);
        MethodNode updateFogColorMethod = this.getMethod(node, KEY_METHOD_UPDATE_FOG_COLOR);
        MethodNode orientCameraMethod = this.getMethod(node, KEY_METHOD_ORIENT_CAMERA);
        if (orientCameraMethod != null) {
            InsnList nodesToAdd = new InsnList();
            nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 1));
            nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, KEY_METHOD_ORIENT_CAMERA, "(F)V"));
            orientCameraMethod.instructions.insertBefore(orientCameraMethod.instructions.get(orientCameraMethod.instructions.size() - 3), nodesToAdd);
            ++injectionCount;
            System.out.println("bll.OrientCamera done");
        }
        if (updateLightMapMethod != null) {
            boolean worldBrightnessInjection = false;
            for (int count = 0; count < updateLightMapMethod.instructions.size(); ++count) {
                MethodInsnNode nodeAt;
                AbstractInsnNode list = updateLightMapMethod.instructions.get(count);
                if (list instanceof MethodInsnNode) {
                    nodeAt = (MethodInsnNode)list;
                    if (!worldBrightnessInjection && nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_WORLD_CLIENT))) {
                        updateLightMapMethod.instructions.remove(updateLightMapMethod.instructions.get(count - 1));
                        updateLightMapMethod.instructions.remove(updateLightMapMethod.instructions.get(count - 1));
                        updateLightMapMethod.instructions.insertBefore(updateLightMapMethod.instructions.get(count - 1), (AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getWorldBrightness", "(L" + this.getNameDynamic(KEY_CLASS_WORLD_CLIENT) + ";)F"));
                        ++injectionCount;
                        worldBrightnessInjection = true;
                        System.out.println("bll.updateLightMap - worldBrightness done");
                        continue;
                    }
                }
                if (!(list instanceof IntInsnNode)) continue;
                nodeAt = (IntInsnNode)list;
                if (nodeAt.operand != 255) continue;
                InsnList nodesToAdd = new InsnList();
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 11));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getColorRed", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 11));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 12));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getColorGreen", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 12));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(23, 13));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                nodesToAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getColorBlue", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)F"));
                nodesToAdd.add((AbstractInsnNode)new InsnNode(106));
                nodesToAdd.add((AbstractInsnNode)new VarInsnNode(56, 13));
                updateLightMapMethod.instructions.insertBefore((AbstractInsnNode)nodeAt, nodesToAdd);
                ++injectionCount;
                System.out.println("bll.updateLightMap - getColors done");
                break;
            }
        }
        if (updateFogColorMethod != null) {
            for (int count = 0; count < updateFogColorMethod.instructions.size(); ++count) {
                InsnList toAdd;
                AbstractInsnNode list = updateFogColorMethod.instructions.get(count);
                if (!(list instanceof MethodInsnNode)) continue;
                MethodInsnNode nodeAt = (MethodInsnNode)list;
                if (!this.optifinePresent && this.methodMatches(KEY_METHOD_GET_FOG_COLOR, nodeAt)) {
                    toAdd = new InsnList();
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                    toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getFogColorHook", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
                    toAdd.add((AbstractInsnNode)new VarInsnNode(58, 9));
                    updateFogColorMethod.instructions.insertBefore(updateFogColorMethod.instructions.get(count + 2), toAdd);
                    ++injectionCount;
                    System.out.println("bll.updateFogColor - getFogColor (no Optifine) done");
                    continue;
                }
                if (!this.methodMatches(KEY_METHOD_GET_SKY_COLOR, nodeAt)) continue;
                toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 2));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_WORLD_UTIL, "getSkyColorHook", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";)L" + this.getNameDynamic(KEY_CLASS_VEC3) + ";"));
                toAdd.add((AbstractInsnNode)new VarInsnNode(58, 5));
                updateFogColorMethod.instructions.insertBefore(updateFogColorMethod.instructions.get(count + 2), toAdd);
                ++injectionCount;
                System.out.println("bll.updateFogColor - getSkyColor done");
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformGuiSleep(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_WAKE_ENTITY);
        if (method != null) {
            method.instructions.insertBefore(method.instructions.get(method.instructions.size() - 3), (AbstractInsnNode)new MethodInsnNode(184, CLASS_MICDOODLE_PLUGIN, "onSleepCancelled", "()V"));
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformForgeHooks(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_BED_ORIENT_CAMERA);
        if (method != null) {
            method.instructions.insertBefore(method.instructions.get(0), (AbstractInsnNode)new MethodInsnNode(184, CLASS_MICDOODLE_PLUGIN, KEY_METHOD_ORIENT_CAMERA, "()V"));
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformCustomAnnotations(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 0;
        injectionCount = 0;
        Iterator methods = node.methods.iterator();
        ArrayList<String> ignoredMods = new ArrayList<String>();
        block2: while (methods.hasNext()) {
            MethodNode methodnode = (MethodNode)methods.next();
            if (methodnode.visibleAnnotations == null || methodnode.visibleAnnotations.size() <= 0) continue;
            for (AnnotationNode annotation : methodnode.visibleAnnotations) {
                if (!annotation.desc.equals("Lmicdoodle8/mods/miccore/Annotations$RuntimeInterface;")) continue;
                ArrayList<String> desiredInterfaces = new ArrayList<String>();
                String modID = "";
                for (int i = 0; i < annotation.values.size(); ++i) {
                    Object value = annotation.values.get(i);
                    if (value.equals("clazz")) {
                        desiredInterfaces.add(String.valueOf(annotation.values.get(i + 1)));
                        continue;
                    }
                    if (value.equals("modID")) {
                        modID = String.valueOf(annotation.values.get(i + 1));
                        continue;
                    }
                    if (!value.equals("altClasses")) continue;
                    desiredInterfaces.addAll((ArrayList)annotation.values.get(i + 1));
                }
                if (ignoredMods.contains(modID)) continue block2;
                boolean modFound = Loader.isModLoaded((String)modID);
                if (modFound) {
                    for (String inter : desiredInterfaces) {
                        try {
                            Class.forName(inter);
                        }
                        catch (ClassNotFoundException e) {
                            this.printLog("Galacticraft ignored missing interface \"" + inter + "\" from mod \"" + modID + "\".");
                            continue;
                        }
                        if (node.interfaces.contains(inter = inter.replace(".", "/"))) continue block2;
                        this.printLog("Galacticraft added interface \"" + inter + "\" dynamically from \"" + modID + "\" to class \"" + node.name + "\".");
                        node.interfaces.add(inter);
                        ++injectionCount;
                        continue block2;
                    }
                    continue block2;
                }
                ignoredMods.add(modID);
                this.printLog("Galacticraft ignored dynamic interface insertion since \"" + modID + "\" was not found.");
                continue block2;
            }
        }
        if (injectionCount > 0) {
            this.printLog("Galacticraft successfully injected bytecode into: " + node.name + " (" + injectionCount + ")");
        }
        return this.finishInjection(node, false);
    }

    public byte[] transformEffectRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode renderParticlesMethod = this.getMethod(node, KEY_METHOD_RENDER_PARTICLES);
        if (renderParticlesMethod != null) {
            InsnList toAdd = new InsnList();
            toAdd.add((AbstractInsnNode)new VarInsnNode(23, 2));
            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "renderFootprints", "(F)V"));
            renderParticlesMethod.instructions.insert(renderParticlesMethod.instructions.get(0), toAdd);
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformItemRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode renderOverlaysMethod = this.getMethod(node, KEY_METHOD_RENDER_OVERLAYS);
        if (renderOverlaysMethod != null) {
            for (int count = 0; count < renderOverlaysMethod.instructions.size(); ++count) {
                AbstractInsnNode glEnable = renderOverlaysMethod.instructions.get(count);
                if (!(glEnable instanceof MethodInsnNode) || !((MethodInsnNode)glEnable).name.equals("glEnable")) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(23, 1));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "renderLiquidOverlays", "(F)V"));
                renderOverlaysMethod.instructions.insertBefore(glEnable, toAdd);
                ++injectionCount;
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformNetHandlerPlay(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 2;
        MethodNode handleNamedSpawnMethod = this.getMethod(node, KEY_METHOD_HANDLE_SPAWN_PLAYER);
        if (handleNamedSpawnMethod != null) {
            for (int count = 0; count < handleNamedSpawnMethod.instructions.size(); ++count) {
                TypeInsnNode nodeAt;
                AbstractInsnNode list = handleNamedSpawnMethod.instructions.get(count);
                if (list instanceof TypeInsnNode) {
                    nodeAt = (TypeInsnNode)list;
                    if (!nodeAt.desc.contains(this.getNameDynamic(KEY_CLASS_ENTITY_OTHER_PLAYER))) continue;
                    TypeInsnNode overwriteNode = new TypeInsnNode(187, this.getNameDynamic(KEY_CLASS_CUSTOM_OTHER_PLAYER));
                    handleNamedSpawnMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    continue;
                }
                if (!(list instanceof MethodInsnNode)) continue;
                nodeAt = (MethodInsnNode)list;
                if (!nodeAt.name.equals("<init>") || !nodeAt.owner.equals(this.getNameDynamic(KEY_CLASS_ENTITY_OTHER_PLAYER))) continue;
                handleNamedSpawnMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)new MethodInsnNode(183, this.getNameDynamic(KEY_CLASS_CUSTOM_OTHER_PLAYER), "<init>", "(L" + this.getNameDynamic(KEY_CLASS_WORLD) + ";L" + this.getNameDynamic(KEY_CLASS_GAME_PROFILE) + ";)V"));
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformWorldRenderer(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        Boolean smallMoonsEnabled = this.getSmallMoonsEnabled();
        int n = operationCount = smallMoonsEnabled != false ? 2 : 0;
        if (smallMoonsEnabled.booleanValue()) {
            MethodNode setupGLMethod;
            MethodNode setPositionMethod = this.getMethod(node, KEY_METHOD_SET_POSITION);
            if (setPositionMethod != null) {
                for (int count = 0; count < setPositionMethod.instructions.size(); ++count) {
                    AbstractInsnNode nodeTest = setPositionMethod.instructions.get(count);
                    if (!(nodeTest instanceof InsnNode) || nodeTest.getOpcode() != 177) continue;
                    InsnList toAdd = new InsnList();
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toAdd.add((AbstractInsnNode)new FieldInsnNode(180, this.getNameDynamic(KEY_CLASS_WORLD_RENDERER), this.getNameDynamic(KEY_FIELD_WORLDRENDERER_GLRENDERLIST), "I"));
                    toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "setPositionList", "(L" + this.getNameDynamic(KEY_CLASS_WORLD_RENDERER) + ";I)V"));
                    setPositionMethod.instructions.insertBefore(nodeTest, toAdd);
                    ++injectionCount;
                    System.out.println("blg.setPosition - done");
                    break;
                }
            }
            if ((setupGLMethod = this.getMethod(node, KEY_METHOD_SETUP_GL)) != null) {
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toAdd.add((AbstractInsnNode)new FieldInsnNode(180, this.getNameDynamic(KEY_CLASS_WORLD_RENDERER), this.getNameDynamic(KEY_FIELD_WORLDRENDERER_GLRENDERLIST), "I"));
                toAdd.add((AbstractInsnNode)new InsnNode(6));
                toAdd.add((AbstractInsnNode)new InsnNode(96));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_GL11, "glCallList", "(I)V"));
                setupGLMethod.instructions.insertBefore(setupGLMethod.instructions.get(0), toAdd);
                ++injectionCount;
                System.out.println("blg.setupGLMethod - done");
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformRenderGlobal(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        Boolean smallMoonsEnabled = this.getSmallMoonsEnabled();
        int n = operationCount = smallMoonsEnabled != false ? 5 : 0;
        if (smallMoonsEnabled.booleanValue()) {
            MethodNode renderMethod;
            MethodNode loadMethod;
            MethodNode initMethod = this.getMethod(node, KEY_METHOD_RENDERGLOBAL_INIT);
            if (initMethod != null) {
                for (int count = 0; count < initMethod.instructions.size(); ++count) {
                    AbstractInsnNode nodeTest = initMethod.instructions.get(count);
                    AbstractInsnNode nodeTestb = initMethod.instructions.get(count + 1);
                    if (!(nodeTest instanceof InsnNode) || !(nodeTestb instanceof InsnNode) || nodeTest.getOpcode() != 6 || nodeTestb.getOpcode() != 104) continue;
                    InsnNode overwriteNode = new InsnNode(7);
                    initMethod.instructions.set(nodeTest, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    System.out.println("bls.init - done");
                    break;
                }
            }
            if ((loadMethod = this.getMethod(node, KEY_METHOD_LOAD_RENDERERS)) != null) {
                for (int count = 0; count < loadMethod.instructions.size(); ++count) {
                    IincInsnNode overwriteNode;
                    AbstractInsnNode nodeTest = loadMethod.instructions.get(count);
                    if (!(nodeTest instanceof IincInsnNode)) continue;
                    IincInsnNode nodeAt = (IincInsnNode)nodeTest;
                    if (nodeAt.var == 2 && nodeAt.incr == 3 && !this.optifinePresent) {
                        overwriteNode = new IincInsnNode(2, 4);
                        loadMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                        ++injectionCount;
                        System.out.println("bls.loadRenderers (no Optifine) done");
                        break;
                    }
                    if (nodeAt.var != 6 || nodeAt.incr != 3 || !this.optifinePresent) continue;
                    overwriteNode = new IincInsnNode(6, 4);
                    loadMethod.instructions.set((AbstractInsnNode)nodeAt, (AbstractInsnNode)overwriteNode);
                    ++injectionCount;
                    System.out.println("bls.loadRenderers (Optifine present) done");
                    break;
                }
            }
            if ((renderMethod = this.getMethod(node, KEY_METHOD_RENDERGLOBAL_SORTANDRENDER)) != null) {
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "adjustRenderCamera", "()V"));
                renderMethod.instructions.insertBefore(renderMethod.instructions.get(0), toAdd);
                ++injectionCount;
                MethodInsnNode toAdd2 = new MethodInsnNode(184, CLASS_GL11, "glPopMatrix", "()V");
                renderMethod.instructions.insertBefore(renderMethod.instructions.get(renderMethod.instructions.size() - 3), (AbstractInsnNode)toAdd2);
                ++injectionCount;
                System.out.println("bls.sortAndRender - both done");
                int pos1 = 0;
                int pos2 = 0;
                int pos3 = 0;
                String fieldRenderersSkippingRenderPass = this.deobfuscated ? "renderersSkippingRenderPass" : "ac";
                String fieldPrevChunkSortZ = this.deobfuscated ? "prevChunkSortZ" : "k";
                String methodMarkRenderersForNewPosition = this.deobfuscated ? "markRenderersForNewPosition" : "c";
                for (int count = 0; count < renderMethod.instructions.size(); ++count) {
                    AbstractInsnNode nodeTest = renderMethod.instructions.get(count);
                    if (nodeTest instanceof FieldInsnNode && nodeTest.getOpcode() == 181 && ((FieldInsnNode)nodeTest).name.equals(fieldRenderersSkippingRenderPass) && ((FieldInsnNode)nodeTest).desc.equals("I")) {
                        pos1 = count;
                        continue;
                    }
                    if (nodeTest instanceof FieldInsnNode && nodeTest.getOpcode() == 181 && ((FieldInsnNode)nodeTest).name.equals(fieldPrevChunkSortZ) && ((FieldInsnNode)nodeTest).desc.equals("I")) {
                        pos2 = count;
                        continue;
                    }
                    if (!(nodeTest instanceof MethodInsnNode) || nodeTest.getOpcode() != 183 || !((MethodInsnNode)nodeTest).name.equals(methodMarkRenderersForNewPosition) || !((MethodInsnNode)nodeTest).desc.equals("(III)V")) continue;
                    pos3 = count;
                }
                if (pos1 > 0 && pos2 > 0 && pos3 > 0) {
                    AbstractInsnNode[] instructionArray = renderMethod.instructions.toArray();
                    renderMethod.instructions.clear();
                    int count = 0;
                    while (count <= pos1) {
                        renderMethod.instructions.add(instructionArray[count++]);
                    }
                    count = pos2 + 1;
                    while (count <= pos3) {
                        renderMethod.instructions.add(instructionArray[count++]);
                    }
                    count = pos1 + 1;
                    while (count <= pos2) {
                        renderMethod.instructions.add(instructionArray[count++]);
                    }
                    count = pos3 + 1;
                    while (count < instructionArray.length) {
                        renderMethod.instructions.add(instructionArray[count++]);
                    }
                    ++injectionCount;
                } else {
                    System.out.println("[GC] Warning: Unable to modify bytecode for bls.markRenderersForNewPosition");
                }
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformRenderManager(byte[] bytes) {
        MethodNode method;
        ClassNode node = this.startInjection(bytes);
        Boolean smallMoonsEnabled = this.getSmallMoonsEnabled();
        int n = operationCount = smallMoonsEnabled != false ? 2 : 0;
        if (smallMoonsEnabled.booleanValue() && (method = this.getMethod(node, KEY_METHOD_RENDERMANAGER)) != null) {
            for (int count = 0; count < method.instructions.size(); ++count) {
                AbstractInsnNode nodeTest = method.instructions.get(count);
                AbstractInsnNode nodeTestb = method.instructions.get(count + 1);
                if (!(nodeTest instanceof VarInsnNode) || !(nodeTestb instanceof VarInsnNode) || nodeTest.getOpcode() != 25 || nodeTestb.getOpcode() != 25 || ((VarInsnNode)nodeTest).var != 11 || ((VarInsnNode)nodeTestb).var != 1) continue;
                InsnList toAdd = new InsnList();
                toAdd.add((AbstractInsnNode)new VarInsnNode(25, 1));
                toAdd.add((AbstractInsnNode)new VarInsnNode(24, 2));
                toAdd.add((AbstractInsnNode)new VarInsnNode(24, 4));
                toAdd.add((AbstractInsnNode)new VarInsnNode(24, 6));
                toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "adjustRenderPos", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";DDD)V"));
                method.instructions.insertBefore(nodeTest, toAdd);
                ++injectionCount;
                break;
            }
            for (int i = count; i < method.instructions.size(); ++i) {
                AbstractInsnNode nodeTest = method.instructions.get(i);
                if (!(nodeTest instanceof FieldInsnNode) || nodeTest.getOpcode() != 178) continue;
                FieldInsnNode f = (FieldInsnNode)nodeTest;
                if (!f.owner.equals(this.getNameDynamic(KEY_CLASS_RENDER_MANAGER)) || !f.desc.equals("Z")) continue;
                MethodInsnNode toAdd = new MethodInsnNode(184, CLASS_GL11, "glPopMatrix", "()V");
                method.instructions.insertBefore(nodeTest, (AbstractInsnNode)toAdd);
                ++injectionCount;
                System.out.println("bnf - done2/2");
                break;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformTileEntityRenderer(byte[] bytes) {
        MethodNode renderMethod;
        ClassNode node = this.startInjection(bytes);
        Boolean smallMoonsEnabled = this.getSmallMoonsEnabled();
        int n = operationCount = smallMoonsEnabled != false ? 2 : 0;
        if (smallMoonsEnabled.booleanValue() && (renderMethod = this.getMethod(node, KEY_METHOD_TILERENDERER_RENDERTILEAT)) != null) {
            InsnList toAdd = new InsnList();
            toAdd.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toAdd.add((AbstractInsnNode)new VarInsnNode(24, 2));
            toAdd.add((AbstractInsnNode)new VarInsnNode(24, 4));
            toAdd.add((AbstractInsnNode)new VarInsnNode(24, 6));
            toAdd.add((AbstractInsnNode)new MethodInsnNode(184, CLASS_CLIENT_PROXY_MAIN, "adjustTileRenderPos", "(L" + this.getNameDynamic(KEY_CLASS_TILEENTITY) + ";DDD)V"));
            renderMethod.instructions.insert(toAdd);
            ++injectionCount;
            AbstractInsnNode returnNode = renderMethod.instructions.get(renderMethod.instructions.size() - 1);
            for (int i = 0; i < renderMethod.instructions.size(); ++i) {
                AbstractInsnNode insnAt = renderMethod.instructions.get(i);
                if (insnAt.getOpcode() != 177) continue;
                returnNode = insnAt;
                break;
            }
            MethodInsnNode toAdd2 = new MethodInsnNode(184, CLASS_GL11, "glPopMatrix", "()V");
            renderMethod.instructions.insertBefore(returnNode, (AbstractInsnNode)toAdd2);
            ++injectionCount;
        }
        return this.finishInjection(node);
    }

    public byte[] transformEntityClass(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        operationCount = 1;
        MethodNode method = this.getMethod(node, KEY_METHOD_CAN_RENDER_FIRE);
        if (method != null) {
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode nodeAt = method.instructions.get(i);
                if (!(nodeAt instanceof MethodInsnNode) || nodeAt.getOpcode() != 182) continue;
                MethodInsnNode overwriteNode = new MethodInsnNode(184, CLASS_WORLD_UTIL, "shouldRenderFire", "(L" + this.getNameDynamic(KEY_CLASS_ENTITY) + ";)Z");
                method.instructions.set(nodeAt, (AbstractInsnNode)overwriteNode);
                ++injectionCount;
            }
        }
        return this.finishInjection(node);
    }

    public byte[] transformMinecraftClass(byte[] bytes) {
        ClassNode node = this.startInjection(bytes);
        return this.finishInjection(node);
    }

    private void printResultsAndReset(String nodeName) {
        if (operationCount > 0) {
            if (injectionCount >= operationCount) {
                this.printLog("Galacticraft successfully injected bytecode into: " + nodeName + " (" + injectionCount + " / " + operationCount + ")");
            } else {
                System.err.println("Galacticraft successfully injected bytecode into: " + nodeName + " (" + injectionCount + " / " + operationCount + ")");
            }
        }
    }

    private MethodNode getMethod(ClassNode node, String keyName) {
        for (MethodNode methodNode : node.methods) {
            if (!this.methodMatches(keyName, methodNode)) continue;
            return methodNode;
        }
        return null;
    }

    private boolean methodMatches(String keyName, MethodInsnNode node) {
        return node.name.equals(this.getNameDynamic(keyName)) && node.desc.equals(this.getDescDynamic(keyName));
    }

    private boolean methodMatches(String keyName, MethodNode node) {
        return node.name.equals(this.getNameDynamic(keyName)) && node.desc.equals(this.getDescDynamic(keyName));
    }

    public String getName(String keyName) {
        return this.nodemap.get((Object)keyName).name;
    }

    public String getObfName(String keyName) {
        return this.nodemap.get((Object)keyName).obfuscatedName;
    }

    public String getNameDynamic(String keyName) {
        try {
            if (this.deobfuscated) {
                return this.getName(keyName);
            }
            return this.getObfName(keyName);
        }
        catch (NullPointerException e) {
            System.err.println("Could not find key: " + keyName);
            throw e;
        }
    }

    public String getDescDynamic(String keyName) {
        return ((MethodObfuscationEntry)this.nodemap.get((Object)keyName)).methodDesc;
    }

    private boolean classPathMatches(String keyName, String className) {
        return className.replace('.', '/').equals(this.getNameDynamic(keyName));
    }

    private void printLog(String message) {
        System.out.println(message);
    }

    private ClassNode startInjection(byte[] bytes) {
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)node, 0);
        injectionCount = 0;
        operationCount = 0;
        return node;
    }

    private byte[] finishInjection(ClassNode node) {
        return this.finishInjection(node, true);
    }

    private byte[] finishInjection(ClassNode node, boolean printLog) {
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        if (printLog) {
            this.printResultsAndReset(node.name);
        }
        return writer.toByteArray();
    }

    private boolean getSmallMoonsEnabled() {
        return false;
    }

    private boolean mcVersionMatches(String mcVersion) {
        return VersionParser.parseRange((String)("[" + mcVersion + "]")).containsVersion((ArtifactVersion)this.mcVersion);
    }

    public static class FieldObfuscationEntry
    extends ObfuscationEntry {
        public FieldObfuscationEntry(String name, String obfuscatedName) {
            super(name, obfuscatedName);
        }
    }

    public static class MethodObfuscationEntry
    extends ObfuscationEntry {
        public String methodDesc;

        public MethodObfuscationEntry(String name, String obfuscatedName, String methodDesc) {
            super(name, obfuscatedName);
            this.methodDesc = methodDesc;
        }

        public MethodObfuscationEntry(String commonName, String methodDesc) {
            this(commonName, commonName, methodDesc);
        }
    }

    public static class ObfuscationEntry {
        public String name;
        public String obfuscatedName;

        public ObfuscationEntry(String name, String obfuscatedName) {
            this.name = name;
            this.obfuscatedName = obfuscatedName;
        }

        public ObfuscationEntry(String commonName) {
            this(commonName, commonName);
        }
    }
}

