/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCargoUnloader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityUniversalElectrical;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCargoLoader
extends BlockAdvancedTile {
    private IIcon iconMachineSide;
    private IIcon iconInput;
    private IIcon iconFrontLoader;
    private IIcon iconFrontUnloader;
    private IIcon iconItemInput;
    private IIcon iconItemOutput;
    public static int METADATA_CARGO_LOADER = 0;
    public static int METADATA_CARGO_UNLOADER = 4;

    public BlockCargoLoader(String assetName) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, METADATA_CARGO_LOADER));
        par3List.add(new ItemStack(par1, 1, METADATA_CARGO_UNLOADER));
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @Override
    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null) {
            if (tileEntity instanceof TileEntityCargoLoader) {
                ((TileEntityCargoLoader)tileEntity).checkForCargoEntity();
            } else if (tileEntity instanceof TileEntityCargoUnloader) {
                ((TileEntityCargoUnloader)tileEntity).checkForCargoEntity();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_input");
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_blank");
        this.iconFrontLoader = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_cargoloader");
        this.iconFrontUnloader = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_cargounloader");
        this.iconItemInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_item_input");
        this.iconItemOutput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_item_output");
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, x, y, z);
        return true;
    }

    public IIcon func_149691_a(int side, int metadata) {
        int shiftedMeta = metadata;
        if (side == 0 || side == 1) {
            return this.iconMachineSide;
        }
        if (metadata >= METADATA_CARGO_UNLOADER) {
            if (side == (shiftedMeta -= METADATA_CARGO_UNLOADER) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.getOrientation((int)(shiftedMeta + 2)).getOpposite().ordinal()) {
                return metadata < 4 ? this.iconItemInput : this.iconItemOutput;
            }
            return metadata < 4 ? this.iconFrontLoader : this.iconFrontUnloader;
        }
        if (metadata >= METADATA_CARGO_LOADER) {
            if (side == (shiftedMeta -= METADATA_CARGO_LOADER) + 2) {
                return this.iconInput;
            }
            if (side == ForgeDirection.getOrientation((int)(shiftedMeta + 2)).getOpposite().ordinal()) {
                return metadata < 4 ? this.iconItemInput : this.iconItemOutput;
            }
            return metadata < 4 ? this.iconFrontLoader : this.iconFrontUnloader;
        }
        return this.iconMachineSide;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata < METADATA_CARGO_UNLOADER) {
            return new TileEntityCargoLoader();
        }
        return new TileEntityCargoUnloader();
    }

    @Override
    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata;
        int shiftedMeta = metadata = world.func_72805_g(x, y, z);
        int baseMeta = 0;
        if (metadata >= METADATA_CARGO_UNLOADER) {
            baseMeta = METADATA_CARGO_UNLOADER;
        } else if (metadata >= METADATA_CARGO_LOADER) {
            baseMeta = METADATA_CARGO_LOADER;
        }
        int change = 0;
        switch (shiftedMeta -= baseMeta) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityUniversalElectrical) {
            ((TileEntityUniversalElectrical)te).updateFacing();
        }
        return world.func_72921_c(x, y, z, baseMeta + change, 3);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int metadata = world.func_72805_g(x, y, z);
        int change = 0;
        int baseMeta = 0;
        if (metadata >= METADATA_CARGO_UNLOADER) {
            baseMeta = METADATA_CARGO_UNLOADER;
        } else if (metadata >= METADATA_CARGO_LOADER) {
            baseMeta = METADATA_CARGO_LOADER;
        }
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, baseMeta + change, 3);
        for (int dX = -2; dX < 3; ++dX) {
            for (int dZ = -2; dZ < 3; ++dZ) {
                Block block = world.func_147439_a(x + dX, y, z + dZ);
                if (block != GCBlocks.landingPadFull) continue;
                world.func_147471_g(x + dX, y, z + dZ);
            }
        }
    }

    public void func_149664_b(World world, int x, int y, int z, int par5) {
        super.func_149664_b(world, x, y, z, par5);
        for (int dX = -2; dX < 3; ++dX) {
            for (int dZ = -2; dZ < 3; ++dZ) {
                Block block = world.func_147439_a(x + dX, y, z + dZ);
                if (block != GCBlocks.landingPadFull) continue;
                world.func_147471_g(x + dX, y, z + dZ);
            }
        }
    }

    public int func_149692_a(int metadata) {
        if (metadata >= METADATA_CARGO_UNLOADER) {
            return METADATA_CARGO_UNLOADER;
        }
        if (metadata >= METADATA_CARGO_LOADER) {
            return METADATA_CARGO_LOADER;
        }
        return 0;
    }
}

