/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityIngotCompressor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityUniversalElectrical;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachine
extends BlockTileGC {
    public static final int COAL_GENERATOR_METADATA = 0;
    public static final int COMPRESSOR_METADATA = 12;
    private IIcon iconMachineSide;
    private IIcon iconOutput;
    private IIcon iconCoalGenerator;
    private IIcon iconCompressor;

    public BlockMachine(String assetName) {
        super(GCBlocks.machine);
        this.func_149663_c("basicMachine");
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine");
        this.iconOutput = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_output");
        this.iconMachineSide = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_side");
        this.iconCoalGenerator = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "coalGenerator");
        this.iconCompressor = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "compressor");
    }

    public void func_149734_b(World par1World, int x, int y, int z, Random par5Random) {
        TileEntity tile = par1World.func_147438_o(x, y, z);
        if (tile instanceof TileEntityCoalGenerator) {
            TileEntityCoalGenerator tileEntity = (TileEntityCoalGenerator)tile;
            if (tileEntity.heatGJperTick > 0.0f) {
                int metadata = par1World.func_72805_g(x, y, z);
                float var7 = (float)x + 0.5f;
                float var8 = (float)y + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
                float var9 = (float)z + 0.5f;
                float var10 = 0.52f;
                float var11 = par5Random.nextFloat() * 0.6f - 0.3f;
                if (metadata == 0) {
                    par1World.func_72869_a("smoke", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 - var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 1) {
                    par1World.func_72869_a("smoke", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var10), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 2) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + var10), 0.0, 0.0, 0.0);
                } else if (metadata == 3) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - var10), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.field_149761_L;
        }
        if (metadata >= 12) {
            if ((metadata -= 12) == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconCompressor;
            }
        } else {
            if (side == metadata + 2) {
                return this.iconOutput;
            }
            if (metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconCoalGenerator;
            }
        }
        return this.iconMachineSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        int metadata = par1World.func_72805_g(x, y, z);
        int original = metadata & 3;
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata < 12 && (te = par1World.func_147438_o(x, y, z)) instanceof TileEntityUniversalElectrical) {
            ((TileEntityUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K) {
            if (metadata >= 12) {
                par5EntityPlayer.openGui((Object)GalacticraftCore.instance, -1, par1World, x, y, z);
                return true;
            }
            par5EntityPlayer.openGui((Object)GalacticraftCore.instance, -1, par1World, x, y, z);
            return true;
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if ((metadata &= 0xC) == 12) {
            return new TileEntityIngotCompressor();
        }
        if (metadata == 4) {
            return new TileEntityEnergyStorageModule();
        }
        if (metadata == 8) {
            return new TileEntityElectricFurnace();
        }
        return new TileEntityCoalGenerator();
    }

    public ItemStack getCompressor() {
        return new ItemStack((Block)this, 1, 12);
    }

    public ItemStack getCoalGenerator() {
        return new ItemStack((Block)this, 1, 0);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getCoalGenerator());
        par3List.add(this.getCompressor());
    }

    public int func_149692_a(int metadata) {
        return metadata & 0xC;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }
}

