/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.common.Loader;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.TileEntityElectricFurnace;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityUniversalElectrical;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachineTiered
extends BlockTileGC {
    public static final int STORAGE_MODULE_METADATA = 0;
    public static final int ELECTRIC_FURNACE_METADATA = 4;
    private IIcon iconMachineSide;
    private IIcon iconInput;
    private IIcon iconOutput;
    private IIcon iconTier2;
    private IIcon iconMachineSideT2;
    private IIcon iconInputT2;
    private IIcon iconOutputT2;
    private IIcon[] iconEnergyStorageModule;
    private IIcon[] iconEnergyStorageModuleT2;
    private IIcon iconElectricFurnace;
    private IIcon iconElectricFurnaceT2;

    public BlockMachineTiered(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + "machine");
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        int i;
        this.field_149761_L = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine");
        this.iconInput = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_input");
        this.iconOutput = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_output");
        this.iconMachineSide = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_side");
        this.iconEnergyStorageModule = new IIcon[17];
        for (i = 0; i < this.iconEnergyStorageModule.length; ++i) {
            this.iconEnergyStorageModule[i] = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "energyStorageModule_" + i);
        }
        this.iconElectricFurnace = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "electricFurnace");
        if (Loader.isModLoaded((String)"GalacticraftMars")) {
            this.iconTier2 = iconRegister.func_94245_a("galacticraftasteroids:machine");
            this.iconInputT2 = iconRegister.func_94245_a("galacticraftasteroids:machine_input");
            this.iconOutputT2 = iconRegister.func_94245_a("galacticraftasteroids:machine_output");
            this.iconMachineSideT2 = iconRegister.func_94245_a("galacticraftasteroids:machine_side");
            this.iconEnergyStorageModuleT2 = new IIcon[17];
            for (i = 0; i < this.iconEnergyStorageModule.length; ++i) {
                this.iconEnergyStorageModuleT2[i] = iconRegister.func_94245_a("galacticraftasteroids:energyStorageModule_" + i);
            }
            this.iconElectricFurnaceT2 = iconRegister.func_94245_a("galacticraftasteroids:electricFurnace");
        } else {
            this.iconTier2 = iconRegister.func_94245_a("void");
            this.iconInputT2 = iconRegister.func_94245_a("void");
            this.iconOutputT2 = iconRegister.func_94245_a("void");
            this.iconMachineSideT2 = iconRegister.func_94245_a("void");
            this.iconEnergyStorageModuleT2 = new IIcon[17];
            for (i = 0; i < this.iconEnergyStorageModule.length; ++i) {
                this.iconEnergyStorageModuleT2[i] = iconRegister.func_94245_a("void");
            }
            this.iconElectricFurnaceT2 = iconRegister.func_94245_a("void");
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        int type = metadata & 4;
        int metaside = (metadata & 3) + 2;
        if (type == 0) {
            if (side == 0 || side == 1) {
                if (metadata >= 8) {
                    return this.iconTier2;
                }
                return this.field_149761_L;
            }
            if (side == metaside) {
                if (metadata >= 8) {
                    return this.iconOutputT2;
                }
                return this.iconOutput;
            }
            if (side == (metaside ^ 1)) {
                if (metadata >= 8) {
                    return this.iconInputT2;
                }
                return this.iconInput;
            }
            TileEntity tile = world.func_147438_o(x, y, z);
            int level = 0;
            if (tile instanceof TileEntityEnergyStorageModule) {
                level = ((TileEntityEnergyStorageModule)tile).scaledEnergyLevel;
            }
            if (metadata >= 8) {
                return this.iconEnergyStorageModuleT2[level];
            }
            return this.iconEnergyStorageModule[level];
        }
        return this.func_149691_a(side, metadata);
    }

    public IIcon func_149691_a(int side, int metadata) {
        int metaside = (metadata & 3) + 2;
        if (side == 0 || side == 1) {
            if (metadata >= 8) {
                return this.iconTier2;
            }
            return this.field_149761_L;
        }
        if ((metadata & 4) == 4) {
            if (side == metaside) {
                if (metadata >= 8) {
                    return this.iconInputT2;
                }
                return this.iconInput;
            }
            if (metaside == 2 && side == 4 || metaside == 3 && side == 5 || metaside == 4 && side == 3 || metaside == 5 && side == 2) {
                if (metadata >= 8) {
                    return this.iconElectricFurnaceT2;
                }
                return this.iconElectricFurnace;
            }
        } else {
            if (side == metaside) {
                if (metadata >= 8) {
                    return this.iconOutputT2;
                }
                return this.iconOutput;
            }
            if (side == (metaside ^ 1)) {
                if (metadata >= 8) {
                    return this.iconInputT2;
                }
                return this.iconInput;
            }
            if (metadata >= 8) {
                return this.iconEnergyStorageModuleT2[16];
            }
            return this.iconEnergyStorageModule[16];
        }
        if (metadata >= 8) {
            return this.iconMachineSideT2;
        }
        return this.iconMachineSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = par1World.func_72805_g(x, y, z);
        int original = metadata & 3;
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        TileEntity te = par1World.func_147438_o(x, y, z);
        if (te instanceof TileEntityUniversalElectrical) {
            ((TileEntityUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (!par1World.field_72995_K) {
            par5EntityPlayer.openGui((Object)GalacticraftCore.instance, -1, par1World, x, y, z);
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        int tier = metadata / 8 + 1;
        if ((metadata & 4) == 4) {
            return new TileEntityElectricFurnace(tier);
        }
        return new TileEntityEnergyStorageModule(tier);
    }

    public ItemStack getEnergyStorageModule() {
        return new ItemStack((Block)this, 1, 0);
    }

    public ItemStack getEnergyStorageCluster() {
        return new ItemStack((Block)this, 1, 8);
    }

    public ItemStack getElectricFurnace() {
        return new ItemStack((Block)this, 1, 4);
    }

    public ItemStack getElectricArcFurnace() {
        return new ItemStack((Block)this, 1, 12);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getEnergyStorageModule());
        par3List.add(this.getElectricFurnace());
        if (Loader.isModLoaded((String)"GalacticraftMars")) {
            par3List.add(this.getEnergyStorageCluster());
            par3List.add(this.getElectricArcFurnace());
        }
    }

    public int func_149692_a(int metadata) {
        return metadata & 0xC;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }
}

