/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockAdvancedTile;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityUniversalElectrical;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockOxygenCollector
extends BlockAdvancedTile {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] collectorIcons;
    private IIcon iconMachineSide;
    private IIcon iconInput;
    private IIcon iconOutput;

    public BlockOxygenCollector(String assetName) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.iconMachineSide = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_collector_fan");
        this.iconInput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_oxygen_output");
        this.iconOutput = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_input");
    }

    @Override
    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int change = 0;
        switch (par1World.func_72805_g(x, y, z)) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        TileEntity te = par1World.func_147438_o(x, y, z);
        if (te instanceof TileEntityUniversalElectrical) {
            ((TileEntityUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, change, 3);
        return true;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        entityPlayer.openGui((Object)GalacticraftCore.instance, -1, world, x, y, z);
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityOxygenCollector();
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (side == metadata + 2) {
            return this.iconOutput;
        }
        if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
            return this.iconInput;
        }
        return this.iconMachineSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, change, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int x, int y, int z, Random rand) {
        if (par1World.func_147438_o(x, y, z) instanceof TileEntityOxygenCollector && ((TileEntityOxygenCollector)par1World.func_147438_o((int)x, (int)y, (int)z)).lastOxygenCollected > 1.0f) {
            for (int particleCount = 0; particleCount < 10; ++particleCount) {
                double x2 = (float)x + rand.nextFloat();
                double y2 = (float)y + rand.nextFloat();
                double z2 = (float)z + rand.nextFloat();
                double mX = 0.0;
                double mY = 0.0;
                double mZ = 0.0;
                int dir = rand.nextInt(2) * 2 - 1;
                mX = ((double)rand.nextFloat() - 0.5) * 0.5;
                mY = ((double)rand.nextFloat() - 0.5) * 0.5;
                mZ = ((double)rand.nextFloat() - 0.5) * 0.5;
                int var2 = par1World.func_72805_g(x, y, z);
                if (var2 == 3 || var2 == 2) {
                    x2 = (double)x + 0.5 + 0.25 * (double)dir;
                    mX = rand.nextFloat() * 2.0f * (float)dir;
                } else {
                    z2 = (double)z + 0.5 + 0.25 * (double)dir;
                    mZ = rand.nextFloat() * 2.0f * (float)dir;
                }
                GalacticraftCore.proxy.spawnParticle("oxygen", new Vector3(x2, y2, z2), new Vector3(mX, mY, mZ), new Vector3(0.7, 0.7, 1.0));
            }
        }
    }
}

