/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.container;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementDropdown;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiAirLockController
extends GuiScreen
implements GuiElementCheckbox.ICheckBoxCallback,
GuiElementDropdown.IDropboxCallback,
GuiElementTextBox.ITextBoxCallback {
    private final int xSize;
    private final int ySize;
    private static final ResourceLocation airLockControllerGui = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/airLockController.png");
    private final TileEntityAirLockController controller;
    private GuiElementCheckbox checkboxRedstoneSignal;
    private GuiElementCheckbox checkboxPlayerDistance;
    private GuiElementDropdown dropdownPlayerDistance;
    private GuiElementCheckbox checkboxOpenForPlayer;
    private GuiElementTextBox textBoxPlayerToOpenFor;
    private GuiElementCheckbox checkboxInvertSelection;
    private GuiElementCheckbox checkboxHorizontalMode;
    private int cannotEditTimer;

    public GuiAirLockController(TileEntityAirLockController controller) {
        this.controller = controller;
        this.xSize = 176;
        this.ySize = 139;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int var5 = (this.field_146294_l - this.xSize) / 2;
        int var6 = (this.field_146295_m - this.ySize) / 2;
        this.checkboxRedstoneSignal = new GuiElementCheckbox(0, this, this.field_146294_l / 2 - 78, var6 + 18, GCCoreUtil.translate("gui.checkbox.redstoneSignal.name"));
        this.checkboxPlayerDistance = new GuiElementCheckbox(1, this, this.field_146294_l / 2 - 78, var6 + 33, GCCoreUtil.translate("gui.checkbox.playerWithin.name") + ": ");
        String[] dropboxStrings = new String[]{GCCoreUtil.translate("gui.dropbox.playerDistance.name.0"), GCCoreUtil.translate("gui.dropbox.playerDistance.name.1"), GCCoreUtil.translate("gui.dropbox.playerDistance.name.2"), GCCoreUtil.translate("gui.dropbox.playerDistance.name.3")};
        this.dropdownPlayerDistance = new GuiElementDropdown(2, this, var5 + 105, var6 + 34, dropboxStrings);
        this.checkboxOpenForPlayer = new GuiElementCheckbox(3, this, this.field_146294_l / 2 - 62, var6 + 49, GCCoreUtil.translate("gui.checkbox.playerName.name") + ": ");
        this.textBoxPlayerToOpenFor = new GuiElementTextBox(4, this, this.field_146294_l / 2 - 55, var6 + 64, 110, 15, "", false, 16, false);
        this.checkboxInvertSelection = new GuiElementCheckbox(5, this, this.field_146294_l / 2 - 78, var6 + 80, GCCoreUtil.translate("gui.checkbox.invert.name"));
        this.checkboxHorizontalMode = new GuiElementCheckbox(6, this, this.field_146294_l / 2 - 78, var6 + 96, GCCoreUtil.translate("gui.checkbox.horizontal.name"));
        this.field_146292_n.add(this.checkboxRedstoneSignal);
        this.field_146292_n.add(this.checkboxPlayerDistance);
        this.field_146292_n.add(this.dropdownPlayerDistance);
        this.field_146292_n.add(this.checkboxOpenForPlayer);
        this.field_146292_n.add(this.textBoxPlayerToOpenFor);
        this.field_146292_n.add(this.checkboxInvertSelection);
        this.field_146292_n.add(this.checkboxHorizontalMode);
    }

    protected void func_73869_a(char keyChar, int keyID) {
        if (keyID != 1 && this.textBoxPlayerToOpenFor.keyTyped(keyChar, keyID)) {
            return;
        }
        super.func_73869_a(keyChar, keyID);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            switch (par1GuiButton.field_146127_k) {
                default: 
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int var5 = (this.field_146294_l - this.xSize) / 2;
        int var6 = (this.field_146295_m - this.ySize) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(airLockControllerGui);
        this.func_73729_b(var5, var6, 0, 0, this.xSize, this.ySize);
        this.func_73729_b(var5 + 15, var6 + 51, 176, 0, 7, 9);
        String displayString = GCCoreUtil.translateWithFormat("gui.title.airLock.name", this.controller.ownerName);
        this.field_146289_q.func_78276_b(displayString, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(displayString) / 2, this.field_146295_m / 2 - 65, 0x404040);
        if (this.cannotEditTimer > 0) {
            this.field_146289_q.func_78276_b(this.controller.ownerName, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(displayString) / 2, this.field_146295_m / 2 - 65, this.cannotEditTimer % 30 < 15 ? GCCoreUtil.to32BitColor(255, 255, 100, 100) : 0x404040);
            --this.cannotEditTimer;
        }
        displayString = GCCoreUtil.translate("gui.message.status.name") + ":";
        this.field_146289_q.func_78276_b(displayString, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(displayString) / 2, this.field_146295_m / 2 + 45, 0x404040);
        displayString = GCCoreUtil.translate("gui.status.airLockClosed.name");
        if (!this.controller.active) {
            displayString = GCCoreUtil.translate("gui.status.airLockOpen.name");
        }
        this.field_146289_q.func_78276_b(displayString, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(displayString) / 2, this.field_146295_m / 2 + 55, 0x404040);
        super.func_73863_a(par1, par2, par3);
    }

    @Override
    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        if (((Object)((Object)checkbox)).equals((Object)this.checkboxRedstoneSignal)) {
            this.controller.redstoneActivation = newSelected;
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, new Object[]{0, this.controller.field_145851_c, this.controller.field_145848_d, this.controller.field_145849_e, this.controller.redstoneActivation ? 1 : 0}));
        } else if (((Object)((Object)checkbox)).equals((Object)this.checkboxPlayerDistance)) {
            this.controller.playerDistanceActivation = newSelected;
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, new Object[]{1, this.controller.field_145851_c, this.controller.field_145848_d, this.controller.field_145849_e, this.controller.playerDistanceActivation ? 1 : 0}));
        } else if (((Object)((Object)checkbox)).equals((Object)this.checkboxOpenForPlayer)) {
            this.controller.playerNameMatches = newSelected;
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, new Object[]{3, this.controller.field_145851_c, this.controller.field_145848_d, this.controller.field_145849_e, this.controller.playerNameMatches ? 1 : 0}));
        } else if (((Object)((Object)checkbox)).equals((Object)this.checkboxInvertSelection)) {
            this.controller.invertSelection = newSelected;
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, new Object[]{4, this.controller.field_145851_c, this.controller.field_145848_d, this.controller.field_145849_e, this.controller.invertSelection ? 1 : 0}));
        } else if (((Object)((Object)checkbox)).equals((Object)this.checkboxHorizontalMode)) {
            this.controller.lastHorizontalModeEnabled = this.controller.horizontalModeEnabled;
            this.controller.horizontalModeEnabled = newSelected;
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, new Object[]{5, this.controller.field_145851_c, this.controller.field_145848_d, this.controller.field_145849_e, this.controller.horizontalModeEnabled ? 1 : 0}));
        }
    }

    @Override
    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return player.func_146103_bH().getName().equals(this.controller.ownerName);
    }

    @Override
    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        if (((Object)((Object)checkbox)).equals((Object)this.checkboxRedstoneSignal)) {
            return this.controller.redstoneActivation;
        }
        if (((Object)((Object)checkbox)).equals((Object)this.checkboxPlayerDistance)) {
            return this.controller.playerDistanceActivation;
        }
        if (((Object)((Object)checkbox)).equals((Object)this.checkboxOpenForPlayer)) {
            return this.controller.playerNameMatches;
        }
        if (((Object)((Object)checkbox)).equals((Object)this.checkboxInvertSelection)) {
            return this.controller.invertSelection;
        }
        if (((Object)((Object)checkbox)).equals((Object)this.checkboxHorizontalMode)) {
            return this.controller.horizontalModeEnabled;
        }
        return false;
    }

    @Override
    public boolean canBeClickedBy(GuiElementDropdown dropdown, EntityPlayer player) {
        return player.func_146103_bH().getName().equals(this.controller.ownerName);
    }

    @Override
    public void onSelectionChanged(GuiElementDropdown dropdown, int selection) {
        if (((Object)((Object)dropdown)).equals((Object)this.dropdownPlayerDistance)) {
            this.controller.playerDistanceSelection = selection;
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, new Object[]{2, this.controller.field_145851_c, this.controller.field_145848_d, this.controller.field_145849_e, this.controller.playerDistanceSelection}));
        }
    }

    @Override
    public int getInitialSelection(GuiElementDropdown dropdown) {
        return this.controller.playerDistanceSelection;
    }

    @Override
    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return player.func_146103_bH().getName().equals(this.controller.ownerName);
    }

    @Override
    public void onTextChanged(GuiElementTextBox textBox, String newText) {
        if (((Object)((Object)textBox)).equals((Object)this.textBoxPlayerToOpenFor)) {
            this.controller.playerToOpenFor = newText != null ? newText : "";
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_STRING, new Object[]{0, this.controller.field_145851_c, this.controller.field_145848_d, this.controller.field_145849_e, this.controller.playerToOpenFor}));
        }
    }

    @Override
    public String getInitialText(GuiElementTextBox textBox) {
        if (((Object)((Object)textBox)).equals((Object)this.textBoxPlayerToOpenFor)) {
            return this.controller.playerToOpenFor;
        }
        return null;
    }

    @Override
    public int getTextColor(GuiElementTextBox textBox) {
        return GCCoreUtil.to32BitColor(255, 200, 200, 200);
    }

    @Override
    public void onIntruderInteraction() {
        this.cannotEditTimer = 50;
    }

    @Override
    public void onIntruderInteraction(GuiElementTextBox textBox) {
        this.cannotEditTimer = 50;
    }
}

