/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.item.ItemElectric;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.ElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityElectricFurnace
extends ElectricBlockWithInventory
implements ISidedInventory,
IPacketReceiver {
    public static int PROCESS_TIME_REQUIRED = 130;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack[] containingItems = new ItemStack[3];
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    private boolean initialised = false;

    public TileEntityElectricFurnace() {
        this(1);
    }

    public TileEntityElectricFurnace(int tier) {
        if (tier == 1) {
            this.storage.setMaxExtract(45.0f);
            return;
        }
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
        this.initialised = true;
    }

    @Override
    public void func_145845_h() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (b == GCBlocks.machineBase) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, GCBlocks.machineTiered, 4, 2);
            } else if (metadata >= 8) {
                this.storage.setCapacity(25000.0f);
                this.storage.setMaxExtract(60.0f);
                this.processTimeRequired = 100;
                this.setTierGC(2);
            }
            this.initialised = true;
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public boolean canProcess() {
        if (this.containingItems[1] == null || FurnaceRecipes.func_77602_a().func_151395_a(this.containingItems[1]) == null) {
            return false;
        }
        if (this.containingItems[2] != null) {
            if (!this.containingItems[2].func_77969_a(FurnaceRecipes.func_77602_a().func_151395_a(this.containingItems[1]))) {
                return false;
            }
            if (this.containingItems[2].field_77994_a + 1 > 64) {
                return false;
            }
        }
        return true;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            ItemStack resultItemStack = FurnaceRecipes.func_77602_a().func_151395_a(this.containingItems[1]);
            if (this.containingItems[2] == null) {
                this.containingItems[2] = resultItemStack.func_77946_l();
                if (this.tierGC > 1) {
                    String nameSmelted = this.containingItems[1].func_77977_a().toLowerCase();
                    if (resultItemStack.func_77977_a().toLowerCase().contains("ingot") && (nameSmelted.contains("ore") || nameSmelted.contains("raw") || nameSmelted.contains("moon") || nameSmelted.contains("mars") || nameSmelted.contains("shard"))) {
                        ++this.containingItems[2].field_77994_a;
                    }
                }
            } else if (this.containingItems[2].func_77969_a(resultItemStack)) {
                ++this.containingItems[2].field_77994_a;
                if (this.tierGC > 1) {
                    String nameSmelted = this.containingItems[1].func_77977_a().toLowerCase();
                    if (resultItemStack.func_77977_a().toLowerCase().contains("ingot") && (nameSmelted.contains("ore") || nameSmelted.contains("raw") || nameSmelted.contains("moon") || nameSmelted.contains("mars") || nameSmelted.contains("shard"))) {
                        ++this.containingItems[2].field_77994_a;
                    }
                }
            }
            --this.containingItems[1].field_77994_a;
            if (this.containingItems[1].field_77994_a <= 0) {
                this.containingItems[1] = null;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        this.initialised = false;
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate(this.tierGC == 1 ? "tile.machine.2.name" : "tile.machine.7.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 1 ? itemStack != null && FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null : slotID == 0 && ItemElectric.isElectricItem(itemStack.func_77973_b());
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else if (side == 1) {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        } else {
            int[] nArray4 = new int[1];
            nArray = nArray4;
            nArray4[0] = 0;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 2;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.canProcess();
    }
}

