/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.transmission.item.ItemElectric;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemFuelCanister;
import micdoodle8.mods.galacticraft.core.tile.ElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFuelLoader
extends ElectricBlockWithInventory
implements ISidedInventory,
IFluidHandler,
ILandingPadAttachable {
    private final int tankCapacity = 12000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    private ItemStack[] containingItems = new ItemStack[2];
    public IFuelable attachedFuelable;

    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid;
            if (this.containingItems[1] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1])) != null && FluidRegistry.getFluidName((FluidStack)liquid).equalsIgnoreCase("Fuel") && (this.fuelTank.getFluid() == null || this.fuelTank.getFluid().amount + liquid.amount <= this.fuelTank.getCapacity())) {
                this.fuelTank.fill(liquid, true);
                if (this.containingItems[1].func_77973_b() instanceof ItemFuelCanister) {
                    this.containingItems[1] = new ItemStack(GCItems.oilCanister, 1, GCItems.oilCanister.func_77612_l());
                } else if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                    int amount = this.containingItems[1].field_77994_a;
                    this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                } else {
                    --this.containingItems[1].field_77994_a;
                    if (this.containingItems[1].field_77994_a == 0) {
                        this.containingItems[1] = null;
                    }
                }
            }
            if (this.ticks % 100L == 0L) {
                this.attachedFuelable = null;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity pad = new BlockVec3(this).modifyPositionFromSide(dir, 1).getTileEntity((IBlockAccess)this.field_145850_b);
                    if (pad instanceof TileEntityMulti) {
                        TileEntity mainTile = ((TileEntityMulti)pad).mainBlockPosition.getTileEntity((IBlockAccess)this.field_145850_b);
                        if (!(mainTile instanceof IFuelable)) continue;
                        this.attachedFuelable = (IFuelable)mainTile;
                        break;
                    }
                    if (!(pad instanceof IFuelable)) continue;
                    this.attachedFuelable = (IFuelable)pad;
                    break;
                }
            }
            if (this.fuelTank != null && this.fuelTank.getFluid() != null && this.fuelTank.getFluid().amount > 0) {
                liquid = new FluidStack(GalacticraftCore.fluidFuel, 2);
                if (this.attachedFuelable != null && this.hasEnoughEnergyToRun && !this.disabled && liquid != null) {
                    this.fuelTank.drain(this.attachedFuelable.addFuel(liquid, true), true);
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(par1NBTTagCompound.func_74775_l("fuelTank"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        if (this.fuelTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.fuelloader.name");
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 1 || side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 1;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 1 || slotID == 0 && ItemElectric.isElectricItem(itemstack.func_77973_b());
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fuelTank.getFluid() == null || this.fuelTank.getFluidAmount() < this.fuelTank.getCapacity();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite()) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.equalsIgnoreCase("Fuel")) {
            used = this.fuelTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.fuelTank.getFluid() != null && this.fuelTank.getFluid().amount > 0 && !this.getDisabled(0);
    }

    @Override
    public boolean canAttachToLandingPad(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

