/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.tile.IEnergySource;
import java.lang.reflect.Constructor;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityConductor;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityUniversalConductor
extends TileEntityConductor {
    protected boolean isAddedToEnergyNet;
    protected Object powerHandlerBC;
    private float IC2surplusJoules = 0.0f;

    public TileEntityUniversalConductor() {
        this.initBC();
    }

    @Override
    public void onNetworkChanged() {
    }

    private void initBC() {
        if (NetworkConfigHandler.isBuildcraftLoaded() && this instanceof IPowerReceptor) {
            this.powerHandlerBC = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.PIPE);
            ((PowerHandler)this.powerHandlerBC).configurePowerPerdition(0, 0);
        }
    }

    @Override
    public TileEntity[] getAdjacentConnections() {
        return WorldUtil.getAdjacentPowerConnections(this);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.isAddedToEnergyNet) {
            if (!this.field_145850_b.field_72995_K && NetworkConfigHandler.isIndustrialCraft2Loaded()) {
                this.initIC();
            }
            this.isAddedToEnergyNet = true;
        }
    }

    @Override
    public void func_145843_s() {
        this.IC2surplusJoules = 0.0f;
        this.unloadTileIC2();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (NetworkConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
            try {
                Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                Object o = constr.newInstance(this);
                if (o != null && o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_145850_b != null) {
            if (!this.field_145850_b.field_72995_K && NetworkConfigHandler.isIndustrialCraft2Loaded()) {
                try {
                    Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                    Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                    Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                    Object o = constr.newInstance(this);
                    if (o != null && o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double demandedEnergyUnits() {
        if (this.getNetwork() == null) {
            return 0.0;
        }
        if (this.IC2surplusJoules < 0.001f) {
            this.IC2surplusJoules = 0.0f;
            return this.getNetwork().getRequest(this) * NetworkConfigHandler.TO_IC2_RATIO;
        }
        this.IC2surplusJoules = this.getNetwork().produce(this.IC2surplusJoules, true, 1, this);
        if (this.IC2surplusJoules < 0.001f) {
            this.IC2surplusJoules = 0.0f;
            return this.getNetwork().getRequest(this) * NetworkConfigHandler.TO_IC2_RATIO;
        }
        return 0.0;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        TileEntity tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, directionFrom);
        int tier = 1;
        if (tile instanceof IEnergySource && ((IEnergySource)tile).getOfferedEnergy() >= 128.0) {
            tier = 2;
        }
        float convertedEnergy = (float)amount * NetworkConfigHandler.IC2_RATIO;
        float surplus = this.getNetwork().produce(convertedEnergy, true, tier, this, tile);
        this.IC2surplusJoules = surplus >= 0.001f ? surplus : 0.0f;
        return Math.round(this.IC2surplusJoules * NetworkConfigHandler.TO_IC2_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double getMaxSafeInput() {
        return 2.147483647E9;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyAcceptor", modID="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (emitter instanceof IElectrical || emitter instanceof IConductor) {
            return false;
        }
        try {
            Class<?> conductorIC2 = Class.forName("ic2.api.energy.tile.IEnergyConductor");
            if (conductorIC2.isInstance(emitter)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyEmitter", modID="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (receiver instanceof IElectrical || receiver instanceof IConductor) {
            return false;
        }
        try {
            Class<?> conductorIC2 = Class.forName("ic2.api.energy.tile.IEnergyConductor");
            if (conductorIC2.isInstance(receiver)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        block3: {
            block2: {
                if (this.getNetwork() == null) break block2;
                TileEntity[] tileEntityArray = new TileEntity[]{this};
                if (!(this.getNetwork().getRequest(tileEntityArray) <= 0.0f)) break block3;
            }
            return null;
        }
        return ((PowerHandler)this.powerHandlerBC).getPowerReceiver();
    }

    public void reconfigureBC() {
        double requiredEnergy = this.getNetwork().getRequest(this) * NetworkConfigHandler.TO_BC_RATIO;
        ((PowerHandler)this.powerHandlerBC).configure(1.0, requiredEnergy, 0.0, requiredEnergy);
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public void doWork(PowerHandler workProvider) {
        double energyBC;
        PowerHandler handler = (PowerHandler)this.powerHandlerBC;
        if (!(handler.getEnergyStored() > 0.0) || this.getNetwork() != null) {
            // empty if block
        }
        if ((energyBC = handler.getEnergyStored()) > 0.0) {
            TileEntity[] tileEntityArray = new TileEntity[]{this};
            energyBC = this.getNetwork().produce((float)energyBC * NetworkConfigHandler.BC3_RATIO, true, 1, tileEntityArray) * NetworkConfigHandler.TO_BC_RATIO;
            if (energyBC < 0.0) {
                energyBC = 0.0;
            }
            handler.setEnergy(energyBC);
        }
        this.reconfigureBC();
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="BuildCraft|Energy")
    public World getWorld() {
        return this.func_145831_w();
    }
}

