/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import java.lang.reflect.Method;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.power.EnergySource;
import micdoodle8.mods.galacticraft.api.power.IEnergyHandlerGC;
import micdoodle8.mods.galacticraft.api.transmission.compatibility.NetworkConfigHandler;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.transmission.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.tile.TileEntityConductor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityUniversalElectrical;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityUniversalElectricalSource
extends TileEntityUniversalElectrical {
    public float produce() {
        return this.extractEnergyGC(null, this.produce(false), false);
    }

    public float produce(boolean simulate) {
        int amountProduced = 0;
        if (!this.field_145850_b.field_72995_K) {
            EnumSet<ForgeDirection> outputDirections = this.getElectricalOutputDirections();
            outputDirections.remove(ForgeDirection.UNKNOWN);
            BlockVec3 thisVec = new BlockVec3(this);
            for (ForgeDirection direction : outputDirections) {
                PowerHandler.PowerReceiver receiver;
                float toSend;
                TileEntity tileAdj = thisVec.getTileEntityOnSide(this.field_145850_b, direction);
                if (tileAdj == null || (toSend = this.extractEnergyGC(null, this.getEnergyStoredGC() - (float)amountProduced, true)) <= 0.0f) continue;
                if (tileAdj instanceof TileEntityConductor) {
                    IElectricityNetwork network = ((IConductor)tileAdj).getNetwork();
                    if (network == null) continue;
                    amountProduced = (int)((float)amountProduced + (toSend - network.produce(toSend, true, this.tierGC, this)));
                    continue;
                }
                if (tileAdj instanceof IEnergyHandlerGC) {
                    EnergySource.EnergySourceAdjacent source = new EnergySource.EnergySourceAdjacent(direction.getOpposite());
                    float transferred = ((IEnergyHandlerGC)tileAdj).receiveEnergyGC(source, toSend / (float)outputDirections.size(), simulate);
                    amountProduced = (int)((float)amountProduced + transferred);
                    if (this.tierGC <= 1 || simulate || !(transferred > 0.0f) || !(tileAdj instanceof EnergyStorageTile)) continue;
                    ((EnergyStorageTile)tileAdj).poweredByTierGC = this.tierGC;
                    continue;
                }
                if (NetworkConfigHandler.isBuildcraftLoaded() && NetworkConfigHandler.getBuildcraftVersion() == 6 && MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)direction.getOpposite()) != null) {
                    double toSendBC = Math.min((double)(toSend * NetworkConfigHandler.TO_BC_RATIO), MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)direction.getOpposite()).getEnergyRequested());
                    if (simulate) {
                        amountProduced = (int)((double)amountProduced + toSendBC * (double)NetworkConfigHandler.BC3_RATIO);
                        continue;
                    }
                    amountProduced = (int)((float)amountProduced + (float)MjAPI.getMjBattery((Object)tileAdj, (String)"buildcraft.kinesis", (ForgeDirection)direction.getOpposite()).addEnergy(toSendBC) * NetworkConfigHandler.BC3_RATIO);
                    continue;
                }
                if (!NetworkConfigHandler.isBuildcraftLoaded() || !(tileAdj instanceof IPowerReceptor) || (receiver = ((IPowerReceptor)tileAdj).getPowerReceiver(direction.getOpposite())) == null) continue;
                double toSendBC = Math.min((double)(toSend * NetworkConfigHandler.TO_BC_RATIO), receiver.powerRequest());
                if (simulate) {
                    amountProduced = (int)((double)amountProduced + toSendBC * (double)NetworkConfigHandler.BC3_RATIO);
                    continue;
                }
                amountProduced = (int)((float)amountProduced + (float)receiver.receiveEnergy(PowerHandler.Type.PIPE, toSendBC, direction.getOpposite()) * NetworkConfigHandler.BC3_RATIO);
            }
        }
        return amountProduced;
    }

    public void recharge(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            float energyToCharge = this.storage.extractEnergyGC(this.storage.getMaxExtract(), true);
            if (item instanceof IItemElectric) {
                this.storage.extractEnergyGC(ElectricItemHelper.chargeItem(itemStack, energyToCharge), false);
            } else if (NetworkConfigHandler.isIndustrialCraft2Loaded()) {
                try {
                    Class<?> itemElectricIC2 = Class.forName("ic2.api.item.ISpecialElectricItem");
                    Class<?> itemElectricIC2B = Class.forName("ic2.api.item.IElectricItem");
                    Class<?> itemManagerIC2 = Class.forName("ic2.api.item.IElectricItemManager");
                    if (itemElectricIC2.isInstance(item)) {
                        Object IC2item = itemElectricIC2.cast(item);
                        Method getMan = itemElectricIC2.getMethod("getManager", ItemStack.class);
                        Object IC2manager = getMan.invoke(IC2item, itemStack);
                        Method methodCharge = itemManagerIC2.getMethod("charge", ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                        int result = (Integer)methodCharge.invoke(IC2manager, itemStack, (int)(energyToCharge * NetworkConfigHandler.TO_IC2_RATIO), 4, false, false);
                        float energy = (float)result * NetworkConfigHandler.IC2_RATIO;
                        this.storage.extractEnergyGC(energy, false);
                    } else if (itemElectricIC2B.isInstance(item)) {
                        Class<?> electricItemIC2 = Class.forName("ic2.api.item.ElectricItem");
                        Object IC2manager = electricItemIC2.getField("manager").get(null);
                        Method methodCharge = itemManagerIC2.getMethod("charge", ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                        int result = (Integer)methodCharge.invoke(IC2manager, itemStack, (int)(energyToCharge * NetworkConfigHandler.TO_IC2_RATIO), 4, false, false);
                        float energy = (float)result * NetworkConfigHandler.IC2_RATIO;
                        this.storage.extractEnergyGC(energy, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyEmitter", modID="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (receiver instanceof IElectrical || receiver instanceof IConductor) {
            return false;
        }
        try {
            Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
            if (!energyTile.isInstance(receiver)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getElectricalOutputDirections().contains(direction);
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySource", modID="IC2")
    public double getOfferedEnergy() {
        return this.getProvide(ForgeDirection.UNKNOWN) * NetworkConfigHandler.TO_IC2_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySource", modID="IC2")
    public void drawEnergy(double amount) {
        this.storage.extractEnergyGC((float)amount * NetworkConfigHandler.IC2_RATIO, false);
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        TileEntity tile;
        if (direction == ForgeDirection.UNKNOWN && NetworkConfigHandler.isIndustrialCraft2Loaded() && (tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, this.getElectricalOutputDirectionMain())) instanceof IConductor) {
            return 0.0f;
        }
        if (this.getElectricalOutputDirections().contains(direction)) {
            return this.storage.extractEnergyGC(Float.MAX_VALUE, true);
        }
        return 0.0f;
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        return ForgeDirection.UNKNOWN;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerEmitter", modID="BuildCraft|Energy")
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return this.getElectricalOutputDirections().contains(side);
    }
}

