/*
 * Decompiled with CFR 0.152.
 */
import elliandetector.EllianDetector;
import elliandetector.Material;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.lwjgl.input.Keyboard;

public class EllianGuiMaterialScreen
extends EllianGUIScreenInterface {
    private ConcurrentHashMap deleteObject;
    private EllianDetector detector = null;
    static final int MIN_STRING_WIDTH = 64;
    static final int MAX_STRING_WIDTH = 160;
    static final int LIST_SIZE = 9;
    private List<Material> mats;
    private EllianGuiMaterial[] guiMaterials;
    private EllianGuiScrollbar scrollbar;
    private EllianGuiSimpleButton backButton;
    private EllianGuiSimpleButton addButton;
    private EllianGuiSimpleButton removeButton;
    private EllianGuiSimpleButton cancelButton;
    private int scroll;
    private boolean removeMode;
    private int maxStringWidth;
    private EllianGUIScreenInterface parent;

    public EllianGuiMaterialScreen(EllianGUIScreenInterface xe1, EllianDetector detector) {
        this.detector = detector;
        this.mats = detector.getMaterials();
        this.guiMaterials = new EllianGuiMaterial[9];
        this.scrollbar = new EllianGuiScrollbar(0, 0, 0, 12, 90);
        this.parent = xe1;
        int i = 0;
        while (i < 9) {
            this.guiMaterials[i] = new EllianGuiMaterial(detector, i, this);
            ++i;
        }
        this.deleteObject = new ConcurrentHashMap();
    }

    public void A_() {
        this.initialise();
        this.buttons.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        EllianGuiMaterial[] aguimaterial = this.guiMaterials;
        int l = this.guiMaterials.length;
        int j = 0;
        while (j < l) {
            EllianGuiMaterial guimaterial = aguimaterial[j];
            this.buttons.add(guimaterial);
            ++j;
        }
        this.buttons.add(this.scrollbar);
        this.updateMaterials();
        int i = this.width / 2;
        int k = this.height + 90 >> 1;
        this.backButton = new EllianGuiSimpleButton(0, i - 65, k + 7, 40, 14, this.parent != null ? "Back" : "Close");
        this.buttons.add(this.backButton);
        this.addButton = new EllianGuiSimpleButton(0, i - 20, k + 7, 40, 14, "Add");
        this.buttons.add(this.addButton);
        this.removeButton = new EllianGuiSimpleButton(0, i + 25, k + 7, 40, 14, "Remove");
        this.buttons.add(this.removeButton);
        this.cancelButton = new EllianGuiSimpleButton(0, i - 20, k + 7, 40, 14, "Cancel");
        this.buttons.add(this.cancelButton);
        this.setRemoveMode(this.removeMode);
    }

    public void b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void a(int mouseX, int mouseY, float floa) {
        this.addButton.h = true;
        this.addButton.i = true;
        int kk = Math.min(160, this.maxStringWidth) + 16;
        int ll = this.height - 90 >> 1;
        int i1 = this.height + 90 >> 1;
        int j1 = this.width - kk - 45 - 10 >> 1;
        int k1 = this.width + kk + 45 + 10 >> 1;
        EllianGuiMaterialScreen.a((int)(j1 - 2), (int)(ll - 2), (int)(k1 + 2), (int)(i1 + 2), (int)-1610612736);
        String string = String.format("Ellian's Material Detector Materials", new Object[0]);
        int l1 = EllianGUIFontRenderer.ELLIANGUIFONTRENDERER.a(string);
        int i2 = this.width - l1 >> 1;
        int j2 = this.width + l1 >> 1;
        EllianGuiMaterialScreen.a((int)(i2 - 2), (int)(ll - 22), (int)(j2 + 2), (int)(ll - 8), (int)-1610612736);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, string, this.width / 2, ll - 19, -1);
        super.a(mouseX, mouseY, floa);
    }

    protected void a(aut ct) {
        if (ct == this.backButton) {
            this.mine.a((awe)this.parent);
        }
        if (ct == this.removeButton) {
            this.setRemoveMode(true);
        }
        if (ct == this.cancelButton) {
            this.setRemoveMode(false);
        }
        if (!this.removeMode && ct == this.addButton) {
            this.mine.a((awe)new EllianGuiMaterialEditorScreen(this.detector, this, null));
        }
    }

    void setRemoveMode(boolean flag) {
        this.backButton.i = !flag;
        this.backButton.h = this.backButton.i;
        this.addButton.i = !flag;
        this.addButton.h = this.addButton.i;
        this.removeButton.i = !flag;
        this.removeButton.h = this.removeButton.i;
        this.cancelButton.h = this.cancelButton.i = flag;
        if (this.removeMode != flag) {
            this.removeMode = flag;
        }
    }

    boolean getRemoveMode() {
        return this.removeMode;
    }

    void addMaterial(Material material) {
        if (!this.mats.contains(material)) {
            this.mats.add(material);
            this.detector.saveMaterials(this.mats);
            this.updateMaterials();
            this.scrollbar.setValue(this.scrollbar.getMaximum());
        }
    }

    void removeMaterial(Material material) {
        if (this.mats.remove(material)) {
            this.detector.saveMaterials(this.mats);
            this.updateMaterials();
        }
        this.setRemoveMode(false);
    }

    void updateMaterial(Material material) {
        if (this.mats.contains(material)) {
            this.detector.saveMaterials(this.mats);
            this.updateMaterials();
        }
    }

    private void updateMaterials() {
        this.maxStringWidth = 128;
        int i = 0;
        int j = this.mats.size();
        while (i < j) {
            Material material = this.mats.get(i);
            this.maxStringWidth = Math.max(this.maxStringWidth, EllianGUIFontRenderer.ELLIANGUIFONTRENDERER.a(String.valueOf(i + 1) + ") " + material.getName()));
            ++i;
        }
        this.scrollbar.setMinimum(0.0f);
        this.scrollbar.setMaximum(this.mats.size());
        this.scrollbar.setVisibleAmount(Math.min(9, this.mats.size()));
        this.scroll = (int)this.scrollbar.getValue();
        this.updateGui();
        this.setMaterials();
    }

    private void updateGui() {
        int i = Math.min(160, this.maxStringWidth) + 16;
        int j = this.height - 90 - 4 >> 1;
        int k = this.width - i - 45 - 12 >> 1;
        int l = this.width + i + 45 + 12 >> 1;
        int i1 = 0;
        while (i1 < 9) {
            this.guiMaterials[i1].bounds(k + 2, j + 2 + 10 * i1, i + 45, 9);
            ++i1;
        }
        this.scrollbar.d = l - 12;
        this.scrollbar.e = j + 2;
    }

    private void setMaterials() {
        int i = 0;
        while (i < 9) {
            int j = i + this.scroll;
            this.guiMaterials[i].setMaterial(j + 1, j >= this.mats.size() ? null : this.mats.get(j));
            ++i;
        }
    }
}

