/*
 * Decompiled with CFR 0.152.
 */
package elliandetector;

import elliandetector.EllianDetector;
import elliandetector.EllianDetector2MinecraftProxy;
import elliandetector.EllianDetectorConfiguration;
import elliandetector.EllianMat;
import elliandetector.Vein;
import java.util.concurrent.ConcurrentHashMap;

public class EllianDetectorCalculator {
    private static EllianDetectorCalculator calculator = null;
    private int distance = 10;
    private int nbX;
    private int nbY = 0;
    protected Object lock = new Object();
    private ConcurrentHashMap<String, Vein> veins = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, EllianMat>>> matCache = new ConcurrentHashMap();

    public static EllianDetectorCalculator getInstance() {
        if (calculator == null) {
            calculator = new EllianDetectorCalculator();
        }
        return calculator;
    }

    private int checkDangerousMat(EllianDetector detector, int alt, int floor, int i, int j, int m, int n) {
        int min = Math.max(2, alt - 3);
        int k = 0;
        int max = Math.min(floor, alt + 3);
        int deep = min;
        while (deep < max) {
            EllianMat mat = this.getMat(detector, i + m, deep, j - n);
            if (detector.isVertical()) {
                mat = this.getMat(detector, j - n, i + m, deep);
            }
            if (mat.getMat() == EllianDetectorConfiguration.MAT_LAVA_STAT) {
                k = EllianDetector.getBlockColor(String.valueOf(EllianDetectorConfiguration.MAT_LAVA_STAT));
                break;
            }
            if (mat.getMat() == EllianDetectorConfiguration.MAT_WATER_STAT) {
                k = EllianDetector.getBlockColor(String.valueOf(EllianDetectorConfiguration.MAT_WATER_STAT));
                break;
            }
            if (detector.isInMaterials(mat.getMat() + ":" + mat.getSubMat())) {
                k = EllianDetector.getBlockColor(mat.getMat(), mat.getSubMat());
                break;
            }
            ++deep;
        }
        return k;
    }

    public void clearCache() {
        this.matCache.clear();
        this.nbY = 0;
        this.nbX = 0;
    }

    private void clearVeins() {
        int i = 0;
        while (i < this.veins.size()) {
            Vein vein = (Vein)this.veins.values().toArray()[i];
            String key = String.valueOf(vein.getX() - 1) + "_" + (vein.getZ() - 1);
            if (this.veins.containsKey(key)) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX()) + "_" + (vein.getZ() - 1))) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + (vein.getZ() - 1))) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() - 1) + "_" + vein.getZ())) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + vein.getZ())) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() - 1) + "_" + (vein.getZ() + 1))) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX()) + "_" + (vein.getZ() + 1))) {
                this.veins.remove(key);
            }
            if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + (vein.getZ() + 1))) {
                this.veins.remove(key);
            }
            ++i;
        }
    }

    private boolean isCloseVeinExisting(Vein vein) {
        boolean isExisting = false;
        String key = String.valueOf(vein.getX() - 1) + "_" + (vein.getZ() - 1);
        if (this.veins.containsKey(key)) {
            isExisting = true;
        }
        if (this.veins.containsKey(key = String.valueOf(vein.getX()) + "_" + (vein.getZ() - 1))) {
            isExisting = true;
        }
        if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + (vein.getZ() - 1))) {
            isExisting = true;
        }
        if (this.veins.containsKey(key = String.valueOf(vein.getX() - 1) + "_" + vein.getZ())) {
            isExisting = true;
        }
        if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + vein.getZ())) {
            isExisting = true;
        }
        if (this.veins.containsKey(key = String.valueOf(vein.getX() - 1) + "_" + (vein.getZ() + 1))) {
            isExisting = true;
        }
        if (this.veins.containsKey(key = String.valueOf(vein.getX()) + "_" + (vein.getZ() + 1))) {
            isExisting = true;
        }
        if (this.veins.containsKey(key = String.valueOf(vein.getX() + 1) + "_" + (vein.getZ() + 1))) {
            isExisting = true;
        }
        return isExisting;
    }

    private EllianMat getMat(EllianDetector detector, int a, int b, int c) {
        EllianMat mat = null;
        boolean isPlayerClose = false;
        if (this.nbX > 50 || this.nbY > 50) {
            this.clearCache();
        }
        if (Math.abs(a - detector.getLastX()) < 2 && Math.abs(b - detector.getLastZ()) < 2 && Math.abs(c - detector.getLastY()) < 2) {
            isPlayerClose = true;
        }
        if (this.matCache.containsKey(a) && !isPlayerClose) {
            ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, EllianMat>> bMap = this.matCache.get(a);
            if (bMap.containsKey(b)) {
                ConcurrentHashMap<Integer, EllianMat> cMap = bMap.get(b);
                if (cMap.containsKey(c)) {
                    mat = cMap.get(c);
                } else {
                    mat = new EllianMat(EllianDetector2MinecraftProxy.getMaterial(a, b, c), EllianDetector2MinecraftProxy.getMaterialSubType(a, b, c));
                    cMap.put(c, mat);
                    bMap.put(b, cMap);
                    this.matCache.put(a, bMap);
                }
            } else {
                ++this.nbY;
                mat = new EllianMat(EllianDetector2MinecraftProxy.getMaterial(a, b, c), EllianDetector2MinecraftProxy.getMaterialSubType(a, b, c));
                ConcurrentHashMap<Integer, EllianMat> cMap = new ConcurrentHashMap<Integer, EllianMat>();
                cMap.put(c, mat);
                bMap.put(b, cMap);
                this.matCache.put(a, bMap);
            }
        } else {
            ++this.nbX;
            mat = new EllianMat(EllianDetector2MinecraftProxy.getMaterial(a, b, c), EllianDetector2MinecraftProxy.getMaterialSubType(a, b, c));
            ConcurrentHashMap<Integer, EllianMat> cMap = new ConcurrentHashMap<Integer, EllianMat>();
            cMap.put(c, mat);
            ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, EllianMat>> bMap = new ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, EllianMat>>();
            bMap.put(b, cMap);
            this.matCache.put(a, bMap);
        }
        return mat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentHashMap<String, Vein> getVeins() {
        Object object = this.lock;
        synchronized (object) {
            return this.veins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapCalcDetector(EllianDetector detector) {
        Object object = this.lock;
        synchronized (object) {
            this.veins.clear();
            int lastZoom = detector.getZoom();
            int multi = (int)Math.pow(2.0, lastZoom);
            int i = detector.getLastX();
            int j = detector.getLastY();
            int alt = detector.getLastZ();
            if (detector.isVertical()) {
                i = detector.getLastZ();
                j = detector.getLastX();
                alt = detector.getLastY();
            }
            if (!detector.isVertical()) {
                j += detector.getScanSize() / 2 * multi;
            }
            i -= detector.getScanSize() / 2 * multi;
            int k = 0;
            int m = 0;
            while (m < detector.getScanSize() * multi) {
                int n = 0;
                while (n < detector.getScanSize() * multi) {
                    k = 0x737373;
                    boolean check = false;
                    if (Math.sqrt((detector.getScanSize() / 2 * multi - m) * (detector.getScanSize() / 2 * multi - m) + (detector.getScanSize() / 2 * multi - n) * (detector.getScanSize() / 2 * multi - n)) < (double)(detector.getScanSize() / 2 * multi - (int)Math.sqrt(multi))) {
                        check = true;
                    }
                    int floor = EllianDetector2MinecraftProxy.getFloor(i + m, j - n);
                    if (detector.isVertical()) {
                        floor = EllianDetector2MinecraftProxy.getFloor(i + m, j - n);
                    }
                    if (check) {
                        EllianMat mat = this.getMat(detector, i + m, alt - 1, j - n);
                        k = EllianDetector.getBlockColor(mat.getMat(), mat.getSubMat());
                        if (detector.isVertical()) {
                            int X = j + (int)Math.round((double)(n - detector.getScanSize() / 2 * multi) * Math.cos(1.5707963267948966 + Math.toRadians(detector.getDirection())));
                            int Y = alt - (int)Math.round((double)(n - detector.getScanSize() / 2 * multi) * Math.sin(1.5707963267948966 + Math.toRadians(detector.getDirection())));
                            mat = this.getMat(detector, X, i + m, Y);
                            k = EllianDetector.getBlockColor(mat.getMat(), mat.getSubMat());
                        }
                        if (!detector.isVertical()) {
                            int dang;
                            if (detector.isDetecting()) {
                                int min = 2;
                                int max = floor;
                                if (detector.isFiltered()) {
                                    min = Math.max(2, alt - this.distance);
                                    max = Math.min(floor, alt + this.distance);
                                }
                                int deep = min;
                                while (deep < max) {
                                    mat = this.getMat(detector, i + m, deep, j - n);
                                    if (detector.isSameHasCurrentMaterial(mat.getMat(), mat.getSubMat())) {
                                        String materialName = detector.getCurrentMaterialName();
                                        Vein vein = new Vein(materialName.substring(0, 1), i + m, j - n, deep - alt);
                                        if (this.isCloseVeinExisting(vein)) break;
                                        this.veins.put(vein.getKey(), vein);
                                        break;
                                    }
                                    ++deep;
                                }
                            }
                            if ((dang = this.checkDangerousMat(detector, alt, floor, i, j, m, n)) != 0) {
                                k = dang;
                            }
                        }
                    }
                    if (k != EllianDetectorConfiguration.COLOR_TRANSPARENT && k != 0 && check) {
                        int i3 = 255;
                        if (i3 > 255) {
                            i3 = 255;
                        }
                        if (i3 < 32) {
                            i3 = 32;
                        }
                        k = i3 * 0x1000000 + k;
                    }
                    detector.getMapImage(lastZoom).setRGB(n, m, k);
                    ++n;
                }
                ++m;
            }
        }
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }
}

