/*
 * Decompiled with CFR 0.152.
 */
package com.chunkbase.mod.forge.mods.villageinfossp.display;

import com.chunkbase.mod.forge.mods.villageinfossp.display.IDisplay;
import com.chunkbase.mod.forge.mods.villageinfossp.villagedata.IVillageDataAccess;
import com.chunkbase.mod.forge.mods.villageinfossp.villagedata.VillageData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;

@SideOnly(value=Side.CLIENT)
public final class Display
implements IDisplay {
    private final Minecraft mc;
    private IVillageDataAccess villageDataAccess;

    public Display(Minecraft mc, IVillageDataAccess villageDataAccess) {
        this.mc = mc;
        this.villageDataAccess = villageDataAccess;
    }

    @Override
    public void addVillageInfoToList(List<String> list) {
        EntityClientPlayerMP player = this.mc.field_71439_g;
        WorldClient world = this.mc.field_71441_e;
        if (player == null || world == null || this.villageDataAccess == null || !this.mc.field_71474_y.field_74330_P) {
            return;
        }
        list.add(null);
        VillageData village = this.villageDataAccess.getVillageData();
        if (village == null) {
            list.add("No village info available");
            return;
        }
        if (!village.isVillageFound()) {
            list.add("No Village Found");
            return;
        }
        int radius = village.getRadius();
        ChunkCoordinates center = village.getCenter();
        double distanceCenter = Math.sqrt(center.func_71569_e(MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v)));
        double distance = distanceCenter - (double)radius;
        boolean showDetails = false;
        if (distance < 0.0) {
            list.add("Inside Village (ID: " + village.getId() + ")");
            showDetails = true;
        } else if (distance < 32.0) {
            list.add("Nearby Village Found (ID: " + village.getId() + ")");
            showDetails = true;
        } else {
            list.add("Distant Village Found (" + village.getId() + ")");
        }
        list.add("Center: (" + center.field_71574_a + ", " + center.field_71572_b + ", " + center.field_71573_c + "), Radius: " + radius);
        list.add("Distance to Center: " + (int)distanceCenter);
        if (showDetails) {
            int maxVillagers = (int)((double)village.getNumDoors() * 0.35);
            list.add("Villagers: " + village.getNumVillagers() + " (" + maxVillagers + "), Golems: " + village.getNumGolems() + " (" + village.getNumVillagers() / 10 + ")");
            EnumChatFormatting houseColor = village.getNumDoors() > 20 ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
            list.add(houseColor + "Houses: " + village.getNumDoors());
            int reputation = village.getReputation();
            EnumChatFormatting repColor = reputation <= -15 ? EnumChatFormatting.RED : EnumChatFormatting.GREEN;
            list.add(repColor + "Reputation: " + reputation);
            String status = "Breeding Status: ";
            status = village.areBreeding() ? status + "OK" : status + "Stopped";
            list.add(status);
            boolean gsz = true;
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t) > center.field_71574_a + 7) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70165_t) < center.field_71574_a - 8) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70121_D.field_72338_b) > center.field_71572_b + 2) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70121_D.field_72338_b) < center.field_71572_b - 3) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v) > center.field_71573_c + 7) {
                gsz = false;
            }
            if (MathHelper.func_76128_c((double)this.mc.field_71439_g.field_70161_v) < center.field_71573_c - 8) {
                gsz = false;
            }
            if (gsz) {
                list.add("Inside Golem Spawn Zone");
            }
        }
    }

    @Override
    public void setVillageDataAccess(IVillageDataAccess slimeChunks) {
        this.villageDataAccess = slimeChunks;
    }
}

