/*
 * Decompiled with CFR 0.152.
 */
package thebombzen.mods.enchantview;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.gui.GuiEnchantment;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import thebombzen.mods.enchantview.CommandEnchantViewExists;
import thebombzen.mods.enchantview.Configuration;
import thebombzen.mods.enchantview.SideSpecificUtilities;
import thebombzen.mods.enchantview.client.EVGuiEnchantment;
import thebombzen.mods.thebombzenapi.ThebombzenAPIBaseMod;

@Mod(modid="enchantview", name="EnchantView", version="4.0.3", dependencies="required-after:thebombzenapi", guiFactory="thebombzen.mods.enchantview.client.ConfigGuiFactory")
public class EnchantView
extends ThebombzenAPIBaseMod {
    public static final int STAGE_REQUEST = 0;
    public static final int STAGE_SEND = 1;
    public static final int STAGE_ACCEPT = 2;
    public static final Random random = new Random();
    public FMLEventChannel channel;
    @Mod.Instance(value="enchantview")
    public static EnchantView instance;
    @SidedProxy(clientSide="thebombzen.mods.enchantview.client.ClientSideSpecificUtilities", serverSide="thebombzen.mods.enchantview.server.ServerSideSpecificUtilities")
    public static SideSpecificUtilities sideSpecificUtilities;
    private Configuration configuration;
    @SideOnly(value=Side.CLIENT)
    public ItemStack[] newItemStacks;
    @SideOnly(value=Side.CLIENT)
    public volatile boolean enchantViewExists;
    @SideOnly(value=Side.CLIENT)
    public volatile boolean askingIfEnchantViewExists;
    @SideOnly(value=Side.CLIENT)
    public volatile boolean askingForEnchantments;
    private Map<UUID, ItemStack[]> newItemStacksMap = new HashMap<UUID, ItemStack[]>();

    public boolean canPlayerUseCommand(EntityPlayerMP player) {
        return sideSpecificUtilities.canPlayerUseCommand(player);
    }

    public void enchantItem(ContainerEnchantment container, EntityPlayerMP player, int slot) {
        ItemStack stack = this.newItemStacksMap.get(player.func_110124_au())[slot];
        player.func_82242_a(-container.field_75167_g[slot]);
        container.field_75168_e.func_70299_a(0, stack);
        container.func_75130_a(container.field_75168_e);
    }

    public ItemStack generateEnchantedItemStack(ContainerEnchantment container, EntityPlayerMP player, int slot) {
        ItemStack newItemStack = ItemStack.func_77944_b((ItemStack)container.field_75168_e.func_70301_a(0));
        if (container.field_75167_g[slot] > 0 && newItemStack != null && (player.field_71068_ca >= container.field_75167_g[slot] || player.field_71075_bZ.field_75098_d)) {
            boolean isBook;
            List enchList = EnchantmentHelper.func_77513_b((Random)random, (ItemStack)newItemStack, (int)container.field_75167_g[slot]);
            boolean bl = isBook = newItemStack.func_77973_b() == Items.field_151122_aG;
            if (enchList != null) {
                if (isBook) {
                    newItemStack.func_150996_a((Item)Items.field_151134_bR);
                }
                int enchToPick = random.nextInt(enchList.size());
                for (int i = 0; i < enchList.size(); ++i) {
                    EnchantmentData enchData = (EnchantmentData)enchList.get(i);
                    if (isBook && i != enchToPick) continue;
                    if (isBook) {
                        Items.field_151134_bR.func_92115_a(newItemStack, enchData);
                        continue;
                    }
                    newItemStack.func_77966_a(enchData.field_76302_b, enchData.field_76303_c);
                }
            }
        }
        return newItemStack;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDownloadLocationURLString() {
        return "http://is.gd/ThebombzensMods#EnchantView";
    }

    public String getLongName() {
        return "EnchantView";
    }

    public String getLongVersionString() {
        return "EnchantView, version 4.0.3, Minecraft 1.7.2";
    }

    @SideOnly(value=Side.CLIENT)
    public int getNumToggleKeys() {
        return 0;
    }

    public String getShortName() {
        return "EV";
    }

    @SideOnly(value=Side.CLIENT)
    protected String getToggleMessageString(int index, boolean enabled) {
        return null;
    }

    public String getVersionFileURLString() {
        return "https://dl.dropboxusercontent.com/u/51080973/Mods/EnchantView/EVVersion.txt";
    }

    public void init1(FMLPreInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("EnchantView");
        this.channel.register((Object)this);
        this.configuration = new Configuration(this);
        if (event.getSide().equals((Object)Side.CLIENT)) {
            this.newItemStacks = new ItemStack[3];
        }
        FMLCommonHandler.instance().findContainerFor((Object)((Object)this)).getMetadata().authorList = Arrays.asList("Thebombzen");
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        if (this.askingIfEnchantViewExists) {
            this.enchantViewExists = event.message.func_150260_c().equals("Yes, EnchantView exists.");
            this.askingIfEnchantViewExists = false;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onOpenGui(GuiOpenEvent event) {
        if (event.gui instanceof GuiEnchantment && !(event.gui instanceof EVGuiEnchantment)) {
            event.gui = new EVGuiEnchantment((GuiEnchantment)event.gui);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPacketToClient(FMLNetworkEvent.ClientCustomPacketEvent event) {
        if (!event.packet.channel().equals("EnchantView")) {
            return;
        }
        byte[] payload = new byte[event.packet.payload().readableBytes()];
        event.packet.payload().readBytes(payload);
        this.receiveEnchantmentsListFromServer(payload);
    }

    @SubscribeEvent
    public void onPacketToServer(FMLNetworkEvent.ServerCustomPacketEvent event) {
        if (!event.packet.channel().equals("EnchantView")) {
            return;
        }
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            byte[] payload = new byte[event.packet.payload().readableBytes()];
            event.packet.payload().readBytes(payload);
            NBTTagCompound compoundIn = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(payload));
            int stage = compoundIn.func_74762_e("stage");
            int windowId = compoundIn.func_74762_e("windowId");
            if (player.field_71070_bA.field_75152_c != windowId) {
                return;
            }
            if (!(player.field_71070_bA instanceof ContainerEnchantment)) {
                return;
            }
            ContainerEnchantment container = (ContainerEnchantment)player.field_71070_bA;
            if (stage == 0) {
                ItemStack[] newItemStacks = new ItemStack[3];
                for (int i = 0; i < 3; ++i) {
                    newItemStacks[i] = this.generateEnchantedItemStack(container, player, i);
                }
                this.newItemStacksMap.put(player.func_110124_au(), newItemStacks);
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                NBTTagCompound compoundOut = new NBTTagCompound();
                compoundOut.func_74768_a("stage", 1);
                for (int i = 0; i < 3; ++i) {
                    NBTTagCompound stackTag = new NBTTagCompound();
                    newItemStacks[i].func_77955_b(stackTag);
                    compoundOut.func_74782_a("stack" + i, (NBTBase)stackTag);
                }
                CompressedStreamTools.func_74799_a((NBTTagCompound)compoundOut, (OutputStream)byteOut);
                FMLProxyPacket packetSend = new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])byteOut.toByteArray()), "EnchantView");
                this.channel.sendTo(packetSend, player);
            } else if (stage == 2) {
                int slot = compoundIn.func_74762_e("slot");
                this.enchantItem(container, player, slot);
                this.newItemStacksMap.put(player.func_110124_au(), new ItemStack[3]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandEnchantViewExists());
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveEnchantmentsListFromServer(byte[] payload) {
        this.askingForEnchantments = false;
        NBTTagCompound compound = null;
        try {
            compound = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(payload));
        }
        catch (IOException ioe) {
            this.throwException("Error receiving enchanments list from server.", ioe, false);
            return;
        }
        if (compound.func_74762_e("stage") != 1) {
            this.throwException("Error receiving enchanments list from server.", new RuntimeException(), false);
        }
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound stackTag = compound.func_74775_l("stack" + i);
            this.newItemStacks[i] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void requestEnchantmentListFromServer(int windowId) {
        this.askingForEnchantments = true;
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("stage", 0);
        compound.func_74768_a("windowId", windowId);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)dataOut);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error receiving enchanments list from server.");
        }
        FMLProxyPacket payload = new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])dataOut.toByteArray()), "EnchantView");
        this.channel.sendToServer(payload);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendAcceptEnchantment(int windowId, int slot) {
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("stage", 2);
        compound.func_74768_a("windowId", windowId);
        compound.func_74768_a("slot", slot);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)dataOut);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error receiving enchanments list from server.");
        }
        FMLProxyPacket payload = new FMLProxyPacket(Unpooled.wrappedBuffer((byte[])dataOut.toByteArray()), "EnchantView");
        this.channel.sendToServer(payload);
    }
}

