/*
 * Decompiled with CFR 0.152.
 */
package com.apothecary;

import com.apothecary.AlchemyRecipes;
import com.apothecary.BlockBrewery;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityBrewery
extends TileEntity
implements IInventory {
    private ItemStack[] brewItemStacks = new ItemStack[5];
    public int brewBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int brewCookTime = 0;
    private String field_145958_o;
    private String customName;

    public int func_70302_i_() {
        return this.brewItemStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.brewItemStacks[i];
    }

    public void setInventorySlotContainers(int i, ItemStack itemstack) {
        this.brewItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.brewItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.brewItemStacks.length) continue;
            this.brewItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.brewBurnTime = nbttagcompound.func_74765_d("BurnTime");
        this.brewCookTime = nbttagcompound.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityBrewery.getItemBurnTime(this.brewItemStacks[1]);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("BurnTime", (short)this.brewBurnTime);
        nbttagcompound.func_74777_a("CookTime", (short)this.brewCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.brewItemStacks.length; ++i) {
            if (this.brewItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.brewItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getCookProgressScaled(int i) {
        return this.brewCookTime * i / 400;
    }

    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 400;
        }
        return this.brewBurnTime * i / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.brewBurnTime > 0;
    }

    public void func_145845_h() {
        boolean flag = this.brewBurnTime > 0;
        boolean flag1 = false;
        if (this.brewBurnTime > 0) {
            --this.brewBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.brewBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.brewBurnTime = TileEntityBrewery.getItemBurnTime(this.brewItemStacks[2]);
                if (this.brewBurnTime > 0) {
                    flag1 = true;
                    if (this.brewItemStacks[2] != null) {
                        if (this.brewItemStacks[2].field_77994_a == 0) {
                            this.brewItemStacks[2] = new ItemStack(this.brewItemStacks[2].func_77973_b().func_77664_n());
                        } else {
                            --this.brewItemStacks[2].field_77994_a;
                        }
                        if (this.brewItemStacks[2].field_77994_a == 0) {
                            this.brewItemStacks[2] = null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.brewCookTime;
                if (this.brewCookTime == 400) {
                    this.brewCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.brewCookTime = 0;
            }
            if (flag != this.brewBurnTime > 0) {
                flag1 = true;
                BlockBrewery.updateFurnaceBlockState(this.brewBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.brewItemStacks[0] == null) {
            return false;
        }
        if (this.brewItemStacks[1] != null && this.brewItemStacks[0] != null && this.brewItemStacks[4] != null && this.brewItemStacks[1] != null && this.brewItemStacks[0] != null) {
            ItemStack itemstack = AlchemyRecipes.getBrewingResult(this.brewItemStacks[0], this.brewItemStacks[1].func_77973_b(), this.brewItemStacks[4].func_77973_b());
            if (itemstack == null) {
                return false;
            }
            if (this.brewItemStacks[3] == null) {
                return true;
            }
            if (!this.brewItemStacks[3].func_77969_a(itemstack)) {
                return false;
            }
            if (this.brewItemStacks[3].field_77994_a < this.func_70297_j_() && this.brewItemStacks[3].field_77994_a < this.brewItemStacks[3].func_77976_d()) {
                return true;
            }
            return this.brewItemStacks[3].field_77994_a < itemstack.func_77976_d();
        }
        if (this.brewItemStacks[1] != null && this.brewItemStacks[0] != null && this.brewItemStacks[4] == null) {
            ItemStack itemstack = AlchemyRecipes.getBrewingResult(this.brewItemStacks[0], this.brewItemStacks[1].func_77973_b());
            if (itemstack == null) {
                return false;
            }
            if (this.brewItemStacks[3] == null) {
                return true;
            }
            if (!this.brewItemStacks[3].func_77969_a(itemstack)) {
                return false;
            }
            if (this.brewItemStacks[3].field_77994_a < this.func_70297_j_() && this.brewItemStacks[3].field_77994_a < this.brewItemStacks[3].func_77976_d()) {
                return true;
            }
            return this.brewItemStacks[3].field_77994_a < itemstack.func_77976_d();
        }
        return false;
    }

    public void smeltItem() {
        int i;
        ItemStack itemstack;
        if (!this.canSmelt()) {
            return;
        }
        if (this.brewItemStacks[4] != null && this.brewItemStacks[1] != null && this.brewItemStacks[0] != null) {
            itemstack = AlchemyRecipes.getBrewingResult(this.brewItemStacks[0], this.brewItemStacks[1].func_77973_b(), this.brewItemStacks[4].func_77973_b());
            if (this.brewItemStacks[3] == null) {
                this.brewItemStacks[3] = itemstack.func_77946_l();
            } else if (this.brewItemStacks[3].func_77973_b() == itemstack.func_77973_b()) {
                this.brewItemStacks[3].field_77994_a += itemstack.field_77994_a;
            }
            for (i = 0; i < 2; ++i) {
                if (this.brewItemStacks[i].field_77994_a <= 0) {
                    this.brewItemStacks[i] = new ItemStack(this.brewItemStacks[i].func_77973_b().func_77664_n());
                } else {
                    --this.brewItemStacks[i].field_77994_a;
                }
                if (this.brewItemStacks[i].field_77994_a > 0) continue;
                this.brewItemStacks[i] = null;
            }
            if (this.brewItemStacks[4].field_77994_a <= 0) {
                this.brewItemStacks[4] = new ItemStack(this.brewItemStacks[4].func_77973_b().func_77664_n());
            } else {
                --this.brewItemStacks[4].field_77994_a;
            }
            if (this.brewItemStacks[4].field_77994_a <= 0) {
                this.brewItemStacks[4] = null;
            }
        }
        if (this.brewItemStacks[4] == null && this.brewItemStacks[1] != null && this.brewItemStacks[0] != null) {
            itemstack = AlchemyRecipes.getBrewingResult(this.brewItemStacks[0], this.brewItemStacks[1].func_77973_b());
            if (this.brewItemStacks[3] == null) {
                this.brewItemStacks[3] = itemstack.func_77946_l();
            } else if (this.brewItemStacks[3].func_77973_b() == itemstack.func_77973_b()) {
                this.brewItemStacks[3].field_77994_a += itemstack.field_77994_a;
            }
            for (i = 0; i < 2; ++i) {
                if (this.brewItemStacks[i].field_77994_a <= 0) {
                    this.brewItemStacks[i] = new ItemStack(this.brewItemStacks[i].func_77973_b().func_77664_n());
                } else {
                    --this.brewItemStacks[i].field_77994_a;
                }
                if (this.brewItemStacks[i].field_77994_a > 0) continue;
                this.brewItemStacks[i] = null;
            }
        }
    }

    private static int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        Item i = itemstack.func_77973_b();
        if (i == Items.field_151075_bm) {
            return 400;
        }
        return GameRegistry.getFuelValue((ItemStack)itemstack);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.brewItemStacks[i] != null) {
            if (this.brewItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.brewItemStacks[i];
                this.brewItemStacks[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.brewItemStacks[i].func_77979_a(j);
            if (this.brewItemStacks[i].field_77994_a == 0) {
                this.brewItemStacks[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.brewItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String getInvName() {
        return "Alchemical Brewery";
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    public ItemStack func_70304_b(int i) {
        if (this.brewItemStacks[i] != null) {
            ItemStack itemstack = this.brewItemStacks[i];
            this.brewItemStacks[i] = null;
            return itemstack;
        }
        return null;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean func_94041_b(int par1, ItemStack itemstack) {
        return par1 == 3 ? false : (par1 == 2 ? TileEntityBrewery.isItemFuel(itemstack) : true);
    }

    public String func_145825_b() {
        return "Alchemical Brewery";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145951_a(String p_145951_1_) {
        this.field_145958_o = p_145951_1_;
    }

    public static boolean isItemFuel(ItemStack p_145954_0_) {
        return TileEntityBrewery.getItemBurnTime(p_145954_0_) > 0;
    }
}

