/*
 * Decompiled with CFR 0.152.
 */
package com.lithial.me.handlers.utils;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class OpenGlHelper {
    private Minecraft mc;

    public static Vec3 closestLinePartToPoint(Vec3 start, Vec3 end, Vec3 point) {
        if (end == null || start == null || point == null) {
            return null;
        }
        Vec3 u = Vec3.func_72443_a((double)(end.field_72450_a - start.field_72450_a), (double)(end.field_72448_b - start.field_72448_b), (double)(end.field_72449_c - start.field_72449_c));
        Vec3 v = Vec3.func_72443_a((double)(point.field_72450_a - start.field_72450_a), (double)(point.field_72448_b - start.field_72448_b), (double)(point.field_72449_c - start.field_72449_c));
        u = u.func_72432_b();
        double s = u.func_72430_b(v);
        return Vec3.func_72443_a((double)(start.field_72450_a + u.field_72450_a * s), (double)(start.field_72448_b + u.field_72448_b * s), (double)(start.field_72449_c + u.field_72449_c * s));
    }

    public static double distanceFromLine(Vec3 start, Vec3 end, Vec3 point) {
        double totalDist = 0.0;
        Vec3 closestPoint = OpenGlHelper.closestLinePartToPoint(start, end, point);
        if (closestPoint != null) {
            totalDist = Math.sqrt((closestPoint.field_72450_a - point.field_72450_a) * (closestPoint.field_72450_a - point.field_72450_a) + (closestPoint.field_72448_b - point.field_72448_b) * (closestPoint.field_72448_b - point.field_72448_b) + (closestPoint.field_72449_c - point.field_72449_c) * (closestPoint.field_72449_c - point.field_72449_c));
        }
        return totalDist;
    }

    public static Vec3 calculatePlaneNormal(Vec3 plane_p1, Vec3 plane_p2, Vec3 plane_p3) {
        double x1 = plane_p1.field_72450_a;
        double x2 = plane_p2.field_72450_a;
        double x3 = plane_p3.field_72450_a;
        double y1 = plane_p1.field_72448_b;
        double y2 = plane_p2.field_72448_b;
        double y3 = plane_p3.field_72448_b;
        double z1 = plane_p1.field_72449_c;
        double z2 = plane_p2.field_72449_c;
        double z3 = plane_p3.field_72449_c;
        double a = y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2);
        double b = z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2);
        double c = x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2);
        return Vec3.func_72443_a((double)a, (double)b, (double)c);
    }

    public static Vec3 lineIntersectPlane(Vec3 line_p1, Vec3 line_p2, Vec3 plane_p1, Vec3 plane_p2, Vec3 plane_p3, boolean inLimits) {
        Vec3 lineDir = Vec3.func_72443_a((double)(line_p2.field_72450_a - line_p1.field_72450_a), (double)(line_p2.field_72448_b - line_p1.field_72448_b), (double)(line_p2.field_72449_c - line_p1.field_72449_c));
        Vec3 planeNormal = OpenGlHelper.calculatePlaneNormal(plane_p1, plane_p2, plane_p3);
        Vec3 diffPoint = Vec3.func_72443_a((double)(plane_p1.field_72450_a - line_p1.field_72450_a), (double)(plane_p1.field_72448_b - line_p1.field_72448_b), (double)(plane_p1.field_72449_c - line_p1.field_72449_c));
        double denom = lineDir.func_72430_b(planeNormal);
        if (denom == 0.0) {
            return null;
        }
        double dist = diffPoint.func_72430_b(planeNormal);
        dist /= denom;
        if (inLimits && (dist < 0.0 || dist > 1.0)) {
            return null;
        }
        return Vec3.func_72443_a((double)(line_p1.field_72450_a + (line_p2.field_72450_a - line_p1.field_72450_a) * dist), (double)(line_p1.field_72448_b + (line_p2.field_72448_b - line_p1.field_72448_b) * dist), (double)(line_p1.field_72449_c + (line_p2.field_72449_c - line_p1.field_72449_c) * dist));
    }

    public static Vec3 lineIntersectsQuad(Vec3 line_p1, Vec3 line_p2, Vec3 sq_p1, Vec3 sq_p2, Vec3 sq_p3, Vec3 sq_p4) {
        Vec3 intersectionPoint = OpenGlHelper.lineIntersectPlane(line_p1, line_p2, sq_p1, sq_p2, sq_p3, true);
        Vec3[] otherPoints = new Vec3[]{sq_p2, sq_p3, sq_p4};
        if (intersectionPoint == null) {
            return null;
        }
        double maxDistX = 0.0;
        double maxDistY = 0.0;
        double maxDistZ = 0.0;
        for (Vec3 altPoint : otherPoints) {
            double p_maxDistX = Math.abs(sq_p1.field_72450_a - altPoint.field_72450_a);
            double p_maxDistY = Math.abs(sq_p1.field_72448_b - altPoint.field_72448_b);
            double p_maxDistZ = Math.abs(sq_p1.field_72449_c - altPoint.field_72449_c);
            if (maxDistX < p_maxDistX) {
                maxDistX = p_maxDistX;
            }
            if (maxDistY < p_maxDistY) {
                maxDistY = p_maxDistY;
            }
            if (!(maxDistZ < p_maxDistZ)) continue;
            maxDistZ = p_maxDistZ;
        }
        for (Vec3 p : otherPoints) {
            double diffX = Math.abs(p.field_72450_a - intersectionPoint.field_72450_a);
            double diffY = Math.abs(p.field_72448_b - intersectionPoint.field_72448_b);
            double diffZ = Math.abs(p.field_72449_c - intersectionPoint.field_72449_c);
            if (!(diffX > maxDistX) && !(diffY > maxDistY) && !(diffZ > maxDistZ)) continue;
            return null;
        }
        return intersectionPoint;
    }

    public static Vec3 lineIntersectionEntity(Vec3 line_p1, Vec3 line_p2, Entity entity) {
        Vec3 side4;
        Vec3 side3;
        Vec3 side2;
        AxisAlignedBB cb = entity.field_70121_D;
        Vec3 side1 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72337_e, (double)cb.field_72339_c);
        Vec3 result = OpenGlHelper.lineIntersectsQuad(line_p1, line_p2, side1, side2 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72338_b, (double)cb.field_72339_c), side3 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72338_b, (double)cb.field_72339_c), side4 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72337_e, (double)cb.field_72339_c));
        if (result != null) {
            return result;
        }
        side1 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72337_e, (double)cb.field_72334_f);
        result = OpenGlHelper.lineIntersectsQuad(line_p1, line_p2, side1, side2 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72338_b, (double)cb.field_72334_f), side3 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72338_b, (double)cb.field_72339_c), side4 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72337_e, (double)cb.field_72339_c));
        if (result != null) {
            return result;
        }
        side1 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72337_e, (double)cb.field_72334_f);
        result = OpenGlHelper.lineIntersectsQuad(line_p1, line_p2, side1, side2 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72338_b, (double)cb.field_72334_f), side3 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72338_b, (double)cb.field_72334_f), side4 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72337_e, (double)cb.field_72334_f));
        if (result != null) {
            return result;
        }
        side1 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72337_e, (double)cb.field_72334_f);
        result = OpenGlHelper.lineIntersectsQuad(line_p1, line_p2, side1, side2 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72338_b, (double)cb.field_72334_f), side3 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72338_b, (double)cb.field_72339_c), side4 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72337_e, (double)cb.field_72339_c));
        if (result != null) {
            return result;
        }
        side1 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72337_e, (double)cb.field_72334_f);
        result = OpenGlHelper.lineIntersectsQuad(line_p1, line_p2, side1, side2 = Vec3.func_72443_a((double)cb.field_72336_d, (double)cb.field_72337_e, (double)cb.field_72339_c), side3 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72337_e, (double)cb.field_72339_c), side4 = Vec3.func_72443_a((double)cb.field_72340_a, (double)cb.field_72337_e, (double)cb.field_72334_f));
        if (result != null) {
            return result;
        }
        return null;
    }

    public static double vecMagDiff(Vec3 p1, Vec3 p2) {
        return Math.sqrt((p1.field_72450_a - p2.field_72450_a) * (p1.field_72450_a - p2.field_72450_a) + (p1.field_72448_b - p2.field_72448_b) * (p1.field_72448_b - p2.field_72448_b) + (p1.field_72449_c - p2.field_72449_c) * (p1.field_72449_c - p2.field_72449_c));
    }

    public double approxDistAlongLine(Vec3 start, Vec3 end, Vec3 point) {
        Vec3 closestPoint = OpenGlHelper.closestLinePartToPoint(start, end, point);
        double dist = 0.0;
        if (closestPoint != null) {
            if (Math.abs(end.field_72450_a - start.field_72450_a) > dist) {
                dist = Math.abs(end.field_72450_a - start.field_72450_a);
            }
            if (Math.abs(end.field_72448_b - start.field_72448_b) > dist) {
                dist = Math.abs(end.field_72448_b - start.field_72448_b);
            }
            if (Math.abs(end.field_72449_c - start.field_72449_c) > dist) {
                dist = Math.abs(end.field_72449_c - start.field_72449_c);
            }
        }
        return dist;
    }
}

