/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import cpw.mods.fml.common.registry.GameRegistry;
import mekanism.common.Mekanism;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.inventory.container.ContainerBioGenerator;
import mekanism.generators.common.inventory.container.ContainerGasGenerator;
import mekanism.generators.common.inventory.container.ContainerHeatGenerator;
import mekanism.generators.common.inventory.container.ContainerSolarGenerator;
import mekanism.generators.common.inventory.container.ContainerWindTurbine;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindTurbine;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GeneratorsCommonProxy {
    public void registerSpecialTileEntities() {
        GameRegistry.registerTileEntity(TileEntityAdvancedSolarGenerator.class, (String)"AdvancedSolarGenerator");
        GameRegistry.registerTileEntity(TileEntitySolarGenerator.class, (String)"SolarGenerator");
        GameRegistry.registerTileEntity(TileEntityBioGenerator.class, (String)"BioGenerator");
        GameRegistry.registerTileEntity(TileEntityHeatGenerator.class, (String)"HeatGenerator");
        GameRegistry.registerTileEntity(TileEntityGasGenerator.class, (String)"GasGenerator");
        GameRegistry.registerTileEntity(TileEntityWindTurbine.class, (String)"WindTurbine");
    }

    public void registerRenderInformation() {
    }

    public void loadConfiguration() {
        MekanismGenerators.advancedSolarGeneration = Mekanism.configuration.get("generation", "AdvancedSolarGeneration", 300.0).getDouble(300.0);
        MekanismGenerators.bioGeneration = Mekanism.configuration.get("generation", "BioGeneration", 350.0).getDouble(350.0);
        MekanismGenerators.heatGeneration = Mekanism.configuration.get("generation", "HeatGeneration", 150.0).getDouble(150.0);
        MekanismGenerators.heatGenerationLava = Mekanism.configuration.get("generation", "HeatGenerationLava", 5.0).getDouble(5.0);
        MekanismGenerators.heatGenerationNether = Mekanism.configuration.get("generation", "HeatGenerationNether", 100.0).getDouble(100.0);
        MekanismGenerators.solarGeneration = Mekanism.configuration.get("generation", "SolarGeneration", 50.0).getDouble(50.0);
        this.loadWindConfiguration();
        if (Mekanism.configuration.hasChanged()) {
            Mekanism.configuration.save();
        }
    }

    private void loadWindConfiguration() {
        if (Mekanism.configuration.hasKey("generation", "WindGeneration")) {
            double legacyWindGeneration = Mekanism.configuration.get("generation", "WindGeneration", 60.0).getDouble(60.0);
            double windGenerationMax = legacyWindGeneration * 8.0;
            Mekanism.configuration.getCategory("generation").remove((Object)"WindGeneration");
            MekanismGenerators.windGenerationMin = Mekanism.configuration.get("generation", "WindGenerationMin", legacyWindGeneration).getDouble(legacyWindGeneration);
            MekanismGenerators.windGenerationMax = Mekanism.configuration.get("generation", "WindGenerationMax", windGenerationMax).getDouble(windGenerationMax);
        } else {
            MekanismGenerators.windGenerationMin = Mekanism.configuration.get("generation", "WindGenerationMin", 60.0).getDouble(60.0);
            MekanismGenerators.windGenerationMax = Mekanism.configuration.get("generation", "WindGenerationMax", 480.0).getDouble(480.0);
        }
        int minY = Mekanism.configuration.get("generation", "WindGenerationMinY", 24).getInt(24);
        int maxY = Mekanism.configuration.get("generation", "WindGenerationMaxY", 255).getInt(255);
        MekanismGenerators.windGenerationMinY = minY;
        MekanismGenerators.windGenerationMaxY = Math.max(minY + 1, maxY);
    }

    public Object getClientGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Container getServerGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        switch (ID) {
            case 0: {
                return new ContainerHeatGenerator(player.field_71071_by, (TileEntityHeatGenerator)tileEntity);
            }
            case 1: {
                return new ContainerSolarGenerator(player.field_71071_by, (TileEntitySolarGenerator)tileEntity);
            }
            case 3: {
                return new ContainerGasGenerator(player.field_71071_by, (TileEntityGasGenerator)tileEntity);
            }
            case 4: {
                return new ContainerBioGenerator(player.field_71071_by, (TileEntityBioGenerator)tileEntity);
            }
            case 5: {
                return new ContainerWindTurbine(player.field_71071_by, (TileEntityWindTurbine)tileEntity);
            }
        }
        return null;
    }
}

