/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.ISustainedData;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.Mekanism;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.block.BlockGenerator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2API")})
public class ItemBlockGenerator
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
ISustainedInventory,
ISustainedTank,
IEnergyContainerItem {
    public Block metaBlock;

    public ItemBlockGenerator(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public int func_77647_b(int i) {
        return i;
    }

    public IIcon func_77617_a(int i) {
        return this.metaBlock.func_149691_a(2, i);
    }

    public String func_77667_c(ItemStack itemstack) {
        if (BlockGenerator.GeneratorType.getFromMetadata(itemstack.func_77960_j()) == null) {
            return "KillMe!";
        }
        return this.func_77658_a() + "." + BlockGenerator.GeneratorType.getFromMetadata((int)itemstack.func_77960_j()).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        BlockGenerator.GeneratorType type = BlockGenerator.GeneratorType.getFromMetadata(itemstack.func_77960_j());
        if (!Keyboard.isKeyDown((int)42)) {
            list.add(MekanismUtils.localize((String)"tooltip.hold") + " " + EnumColor.INDIGO + "shift" + EnumColor.GREY + " " + MekanismUtils.localize((String)"tooltip.forDetails") + ".");
            list.add(MekanismUtils.localize((String)"tooltip.hold") + " " + EnumColor.AQUA + "shift" + EnumColor.GREY + " and " + EnumColor.AQUA + Keyboard.getKeyName((int)MekanismKeyHandler.modeSwitchKey.func_151463_i()) + EnumColor.GREY + " " + MekanismUtils.localize((String)"tooltip.forDesc") + ".");
        } else if (!Keyboard.isKeyDown((int)MekanismKeyHandler.modeSwitchKey.func_151463_i())) {
            list.add(EnumColor.BRIGHT_GREEN + MekanismUtils.localize((String)"tooltip.storedEnergy") + ": " + EnumColor.GREY + MekanismUtils.getEnergyDisplay((double)this.getEnergy(itemstack)));
            if (this.hasTank(itemstack) && this.getFluidStack(itemstack) != null) {
                list.add(EnumColor.PINK + FluidRegistry.getFluidName((FluidStack)this.getFluidStack(itemstack)) + ": " + EnumColor.GREY + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
            }
            list.add(EnumColor.AQUA + MekanismUtils.localize((String)"tooltip.inventory") + ": " + EnumColor.GREY + LangUtils.transYesNo((this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0 ? 1 : 0) != 0));
        } else {
            list.addAll(MekanismUtils.splitLines((String)type.getDescription()));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place;
        block11: {
            place = true;
            Block block = world.func_147439_a(x, y, z);
            if (stack.func_77960_j() == BlockGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR.meta) {
                if (!block.isReplaceable((IBlockAccess)world, x, y, z)) {
                    return false;
                }
                for (int xPos = -1; xPos <= 1; ++xPos) {
                    for (int zPos = -1; zPos <= 1; ++zPos) {
                        if (world.func_147437_c(x + xPos, y + 2, z + zPos) && y + 2 <= 255) continue;
                        place = false;
                        break block11;
                    }
                }
            } else if (stack.func_77960_j() == BlockGenerator.GeneratorType.WIND_TURBINE.meta) {
                if (!block.isReplaceable((IBlockAccess)world, x, y, z)) {
                    return false;
                }
                for (int yPos = y + 1; yPos <= y + 4; ++yPos) {
                    if (world.func_147437_c(x, yPos, z) && yPos <= 255) continue;
                    place = false;
                    break;
                }
            }
        }
        if (place && super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_147438_o(x, y, z);
            tileEntity.electricityStored = this.getEnergy(stack);
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (tileEntity instanceof ISustainedData && stack.field_77990_d != null) {
                ((ISustainedData)tileEntity).readSustainedData(stack);
            }
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getFluidStack(stack) != null) {
                ((ISustainedTank)tileEntity).setFluidStack(this.getFluidStack(stack), new Object[]{stack});
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="IC2API")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.canSend(itemStack);
    }

    @Optional.Method(modid="IC2API")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2API")
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2API")
    public double getMaxCharge(ItemStack itemStack) {
        return 0.0;
    }

    @Optional.Method(modid="IC2API")
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Optional.Method(modid="IC2API")
    public double getTransferLimit(ItemStack itemStack) {
        return 0.0;
    }

    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_150295_c("Items", 10);
        }
        return null;
    }

    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        if (fluidStack == null || fluidStack.amount == 0 || fluidStack.fluidID == 0) {
            return;
        }
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    public FluidStack getFluidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            if (itemStack.field_77990_d.func_74764_b("fluidTank")) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank"));
            }
        }
        return null;
    }

    public boolean hasTank(Object ... data) {
        return data[0] instanceof ItemStack && ((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank && ((ItemStack)data[0]).func_77960_j() == 2;
    }

    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    public double getMaxEnergy(ItemStack itemStack) {
        return BlockGenerator.GeneratorType.getFromMetadata((int)itemStack.func_77960_j()).maxEnergy;
    }

    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    public boolean canReceive(ItemStack itemStack) {
        return false;
    }

    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * Mekanism.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * Mekanism.TO_TE);
        }
        return 0;
    }

    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * Mekanism.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * Mekanism.TO_TE);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * Mekanism.TO_TE);
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * Mekanism.TO_TE);
    }

    public boolean isMetadataSpecific(ItemStack itemStack) {
        return true;
    }

    @Optional.Method(modid="IC2API")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager((IEnergizedItem)this);
    }
}

