/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.List;
import java.util.Random;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.IActiveState;
import mekanism.common.IBoundingBlock;
import mekanism.common.ISpecialBounds;
import mekanism.common.ISustainedData;
import mekanism.common.ISustainedInventory;
import mekanism.common.ISustainedTank;
import mekanism.common.ItemAttacher;
import mekanism.common.Mekanism;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.client.GeneratorsClientProxy;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindTurbine;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")
public class BlockGenerator
extends BlockContainer
implements ISpecialBounds,
IPeripheralProvider {
    public Random machineRand = new Random();

    public BlockGenerator() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a((CreativeTabs)Mekanism.tabMekanism);
    }

    public void func_149651_a(IIconRegister register) {
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onNeighborChange(block);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(entityliving.field_70125_A);
        int change = 3;
        if (!GeneratorType.getFromMetadata((int)world.func_72805_g((int)x, (int)y, (int)z)).hasModel && tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
            if (height >= 65) {
                change = 1;
            } else if (height <= -65) {
                change = 0;
            }
        }
        if (change != 0 && change != 1) {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        tileEntity.setFacing((short)change);
        tileEntity.redstone = world.func_72864_z(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onPlace();
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof IActiveState && !(tileEntity instanceof TileEntitySolarGenerator) && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return 15;
        }
        return 0;
    }

    public int func_149692_a(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item i, CreativeTabs creativetabs, List list) {
        list.add(new ItemStack(i, 1, 0));
        list.add(new ItemStack(i, 1, 1));
        list.add(new ItemStack(i, 1, 3));
        list.add(new ItemStack(i, 1, 4));
        list.add(new ItemStack(i, 1, 5));
        list.add(new ItemStack(i, 1, 6));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_147438_o(x, y, z);
        if (MekanismUtils.isActive((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            float xRandom = (float)x + 0.5f;
            float yRandom = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float zRandom = (float)z + 0.5f;
            float iRandom = 0.52f;
            float jRandom = random.nextFloat() * 0.6f - 0.3f;
            if (tileEntity.facing == 4) {
                switch (GeneratorType.getFromMetadata(metadata)) {
                    case HEAT_GENERATOR: {
                        world.func_72869_a("smoke", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom - jRandom), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom - jRandom), 0.0, 0.0, 0.0);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_72869_a("smoke", (double)x + 0.25, (double)y + 0.2, (double)z + 0.5, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            } else if (tileEntity.facing == 5) {
                switch (GeneratorType.getFromMetadata(metadata)) {
                    case HEAT_GENERATOR: {
                        world.func_72869_a("smoke", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom - jRandom), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom - jRandom), 0.0, 0.0, 0.0);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_72869_a("smoke", (double)x + 0.75, (double)y + 0.2, (double)z + 0.5, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            } else if (tileEntity.facing == 2) {
                switch (GeneratorType.getFromMetadata(metadata)) {
                    case HEAT_GENERATOR: {
                        world.func_72869_a("smoke", (double)(xRandom - jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", (double)(xRandom - jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_72869_a("smoke", (double)x + 0.5, (double)y + 0.2, (double)z + 0.25, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            } else if (tileEntity.facing == 3) {
                switch (GeneratorType.getFromMetadata(metadata)) {
                    case HEAT_GENERATOR: {
                        world.func_72869_a("smoke", (double)(xRandom - jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
                        world.func_72869_a("flame", (double)(xRandom - jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
                        break;
                    }
                    case BIO_GENERATOR: {
                        world.func_72869_a("smoke", (double)x + 0.5, (double)y + 0.2, (double)z + 0.75, 0.0, 0.0, 0.0);
                        break;
                    }
                }
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == GeneratorType.ADVANCED_SOLAR_GENERATOR.meta) {
            boolean canPlace = super.func_149742_c(world, x, y, z);
            boolean nonAir = false;
            nonAir |= world.func_147437_c(x, y, z);
            for (int xPos = -1; xPos <= 2; ++xPos) {
                for (int zPos = -1; zPos <= 2; ++zPos) {
                    nonAir |= world.func_147437_c(x + xPos, y + 2, z + zPos);
                }
            }
            return !nonAir && canPlace;
        }
        if (world.func_72805_g(x, y, z) == GeneratorType.WIND_TURBINE.meta) {
            boolean canPlace = super.func_149742_c(world, x, y, z);
            boolean nonAir = false;
            for (int yPos = y + 1; yPos <= y + 4; ++yPos) {
                nonAir |= world.func_147437_c(x, yPos, z);
            }
            return !nonAir && canPlace;
        }
        return super.func_149742_c(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)tileEntity).onBreak();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int facing, float playerX, float playerY, float playerZ) {
        if (ItemAttacher.canAttach((ItemStack)entityplayer.func_71045_bC())) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (entityplayer.func_71045_bC() != null && ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|tools") && entityplayer.func_71045_bC().func_77973_b() instanceof IToolWrench && !entityplayer.func_71045_bC().func_77977_a().contains("omniwrench")) {
            if (entityplayer.func_70093_af()) {
                this.dismantleBlock(world, x, y, z, false);
                return true;
            }
            ((IToolWrench)entityplayer.func_71045_bC().func_77973_b()).wrenchUsed(entityplayer, x, y, z);
            int change = 0;
            switch (tileEntity.facing) {
                case 3: {
                    change = 5;
                    break;
                }
                case 5: {
                    change = 2;
                    break;
                }
                case 2: {
                    change = 4;
                    break;
                }
                case 4: {
                    change = 3;
                }
            }
            tileEntity.setFacing((short)change);
            world.func_147459_d(x, y, z, (Block)this);
            return true;
        }
        if (metadata == 3 && entityplayer.func_71045_bC() != null && entityplayer.func_71045_bC().func_77969_a(new ItemStack(MekanismGenerators.Generator, 1, 2)) && ((TileEntityBasicBlock)world.func_147438_o((int)x, (int)y, (int)z)).facing != facing) {
            return false;
        }
        if (tileEntity != null && !entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)MekanismGenerators.instance, GeneratorType.getFromMetadata((int)metadata).guiId, world, x, y, z);
            return true;
        }
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        GeneratorType type = GeneratorType.getFromMetadata(metadata);
        if (type != null) {
            return type.create();
        }
        return null;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return GeneratorsClientProxy.GENERATOR_RENDER_ID;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == GeneratorType.SOLAR_GENERATOR.meta) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.65f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && this.canHarvestBlock(player, world.func_72805_g(x, y, z))) {
            TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_147438_o(x, y, z);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_147468_f(x, y, z);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_147438_o(x, y, z);
        ItemStack itemStack = new ItemStack(MekanismGenerators.Generator, 1, world.func_72805_g(x, y, z));
        if (tileEntity == null) {
            return null;
        }
        IEnergizedItem electricItem = (IEnergizedItem)itemStack.func_77973_b();
        electricItem.setEnergy(itemStack, tileEntity.electricityStored);
        ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
        inventory.setInventory(tileEntity.getInventory(new Object[0]), new Object[]{itemStack});
        if (tileEntity instanceof ISustainedData) {
            ((ISustainedData)tileEntity).writeSustainedData(itemStack);
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(new Object[]{itemStack}) && tileEntity instanceof ISustainedTank && ((ISustainedTank)tileEntity).getFluidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setFluidStack(((ISustainedTank)tileEntity).getFluidStack(new Object[0]), new Object[]{itemStack});
        }
        return itemStack;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z);
        world.func_147468_f(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity != null && MekanismUtils.useIC2()) {
            ((TileEntityElectricBlock)tileEntity).register();
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int metadata = world.func_72805_g(x, y, z);
        return metadata != GeneratorType.SOLAR_GENERATOR.meta && metadata != GeneratorType.ADVANCED_SOLAR_GENERATOR.meta && metadata != GeneratorType.WIND_TURBINE.meta;
    }

    public void setRenderBounds(Block block, int metadata) {
        if (metadata == GeneratorType.SOLAR_GENERATOR.meta) {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.65f, 1.0f);
        } else {
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean doDefaultBoundSetting(int metadata) {
        return true;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        ForgeDirection[] valid = new ForgeDirection[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof IPeripheral) {
            return (IPeripheral)te;
        }
        return null;
    }

    public static enum GeneratorType {
        HEAT_GENERATOR(0, "HeatGenerator", 0, 160000.0, TileEntityHeatGenerator.class, true),
        SOLAR_GENERATOR(1, "SolarGenerator", 1, 96000.0, TileEntitySolarGenerator.class, true),
        GAS_GENERATOR(3, "GasGenerator", 3, Mekanism.FROM_H2 * 100.0, TileEntityGasGenerator.class, true),
        BIO_GENERATOR(4, "BioGenerator", 4, 160000.0, TileEntityBioGenerator.class, true),
        ADVANCED_SOLAR_GENERATOR(5, "AdvancedSolarGenerator", 1, 200000.0, TileEntityAdvancedSolarGenerator.class, true),
        WIND_TURBINE(6, "WindTurbine", 5, 200000.0, TileEntityWindTurbine.class, true);

        public int meta;
        public String name;
        public int guiId;
        public double maxEnergy;
        public Class<? extends TileEntity> tileEntityClass;
        public boolean hasModel;

        private GeneratorType(int i, String s, int j, double k, Class<? extends TileEntity> tileClass, boolean model) {
            this.meta = i;
            this.name = s;
            this.guiId = j;
            this.maxEnergy = k;
            this.tileEntityClass = tileClass;
            this.hasModel = model;
        }

        public static GeneratorType getFromMetadata(int meta) {
            for (GeneratorType type : GeneratorType.values()) {
                if (type.meta != meta) continue;
                return type;
            }
            return null;
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                Mekanism.logger.error("Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String getDescription() {
            return MekanismUtils.localize((String)("tooltip." + this.name));
        }

        public ItemStack getStack() {
            return new ItemStack(MekanismGenerators.Generator, 1, this.meta);
        }

        public String toString() {
            return Integer.toString(this.meta);
        }
    }
}

