/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.common.ISustainedData;
import mekanism.common.Mekanism;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityHeatGenerator
extends TileEntityGenerator
implements IFluidHandler,
ISustainedData {
    public FluidTank lavaTank = new FluidTank(24000);

    public TileEntityHeatGenerator() {
        super("HeatGenerator", 160000.0, MekanismGenerators.heatGeneration * 2.0);
        this.inventory = new ItemStack[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge((int)1, (TileEntityElectricBlock)this);
            if (this.inventory[0] != null) {
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0]);
                if (this.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                    this.lavaTank.fill(FluidContainerUtils.extractFluid((FluidTank)this.lavaTank, (ItemStack)this.inventory[0], (Fluid)FluidRegistry.LAVA), true);
                } else if (fluid != null) {
                    if (fluid != null && fluid.fluidID == FluidRegistry.LAVA.getID() && (this.lavaTank.getFluid() == null || this.lavaTank.getFluid().amount + fluid.amount <= this.lavaTank.getCapacity())) {
                        this.lavaTank.fill(fluid, true);
                        if (this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]) != null) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                        } else {
                            --this.inventory[0].field_77994_a;
                        }
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                } else {
                    int fuelNeeded;
                    int fuel = this.getFuel(this.inventory[0]);
                    if (fuel > 0 && fuel <= (fuelNeeded = this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0))) {
                        this.lavaTank.fill(new FluidStack(FluidRegistry.LAVA, fuel), true);
                        if (this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]) != null) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                        } else {
                            --this.inventory[0].field_77994_a;
                        }
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = null;
                        }
                    }
                }
            }
            this.setEnergy(this.electricityStored + this.getBoost());
            if (this.canOperate()) {
                this.setActive(true);
                this.lavaTank.drain(10, true);
                this.setEnergy(this.electricityStored + MekanismGenerators.heatGeneration);
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return this.getFuel(itemstack) > 0 || FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack) != null && FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack).fluidID == FluidRegistry.LAVA.getID();
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.MAX_ELECTRICITY && this.lavaTank.getFluid() != null && this.lavaTank.getFluid().amount >= 10 && MekanismUtils.canFunction((TileEntity)this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("lavaTank")) {
            this.lavaTank.readFromNBT(nbtTags.func_74775_l("lavaTank"));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        if (this.lavaTank.getFluid() != null) {
            nbtTags.func_74782_a("lavaTank", (NBTBase)this.lavaTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        if (slotID == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        return false;
    }

    public double getBoost() {
        int lavaBoost = 0;
        double netherBoost = 0.0;
        if (this.isLava(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
            ++lavaBoost;
        }
        if (this.isLava(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
            ++lavaBoost;
        }
        if (this.isLava(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            ++lavaBoost;
        }
        if (this.isLava(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
            ++lavaBoost;
        }
        if (this.isLava(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
            ++lavaBoost;
        }
        if (this.isLava(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
            ++lavaBoost;
        }
        if (this.field_145850_b.field_73011_w.field_76574_g == -1) {
            netherBoost = MekanismGenerators.heatGenerationNether;
        }
        return MekanismGenerators.heatGenerationLava * (double)lavaBoost + netherBoost;
    }

    private boolean isLava(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150353_l;
    }

    public int getFuel(ItemStack itemstack) {
        if (itemstack.func_77973_b() == Items.field_151129_at) {
            return 1000;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)itemstack) / 20;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight((int)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public int getScaledFuelLevel(int i) {
        return (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0) * i / this.lavaTank.getCapacity();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        int amount = dataStream.readInt();
        if (amount != 0) {
            this.lavaTank.setFluid(new FluidStack(FluidRegistry.LAVA, amount));
        } else {
            this.lavaTank.setFluid(null);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.lavaTank.getFluid() != null) {
            data.add(this.lavaTank.getFluid().amount);
        } else {
            data.add(0);
        }
        return data;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getFuel", "getFuelNeeded"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0};
            }
            case 5: {
                return new Object[]{this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0)};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.fluidID == FluidRegistry.LAVA.getID() && from != ForgeDirection.getOrientation((int)this.facing)) {
            return this.lavaTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.LAVA && from != ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.getOrientation((int)this.facing)) {
            return PipeUtils.EMPTY;
        }
        return new FluidTankInfo[]{this.lavaTank.getInfo()};
    }

    public void writeSustainedData(ItemStack itemStack) {
        if (this.lavaTank.getFluid() != null) {
            itemStack.field_77990_d.func_74782_a("lavaTank", (NBTBase)this.lavaTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
    }

    public void readSustainedData(ItemStack itemStack) {
        this.lavaTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("lavaTank")));
    }
}

