/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.config;

import bspkrs.treecapitator.EnchantmentTreecapitating;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.config.Configuration;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.nbt.NBTTagCompound;

public final class TCSettings {
    private static final boolean allowDebugLoggingDefault = false;
    public static boolean allowDebugLogging = false;
    private static final boolean allowAutoAxeDetectionDefault = true;
    public static boolean allowAutoAxeDetection = true;
    private static final boolean allowAutoTreeDetectionDefault = true;
    public static boolean allowAutoTreeDetection = true;
    private static final boolean allowItemDamageDefault = true;
    public static boolean allowItemDamage = true;
    private static final boolean allowMoreBlocksThanDamageDefault = false;
    public static boolean allowMoreBlocksThanDamage = false;
    private static final float damageIncreaseAmountDefault = 1.0f;
    public static float damageIncreaseAmount = 1.0f;
    private static final float damageMultiplierDefault = 1.0f;
    public static float damageMultiplier = 1.0f;
    private static final boolean destroyLeavesDefault = true;
    public static boolean destroyLeaves = true;
    private static final boolean disableCreativeDropsDefault = false;
    public static boolean disableCreativeDrops = false;
    private static final boolean disableInCreativeDefault = false;
    public static boolean disableInCreative = false;
    private static final boolean enabledDefault = true;
    public static boolean enabled = true;
    private static final boolean enableEnchantmentModeDefault = false;
    public static boolean enableEnchantmentMode = false;
    private static final int enchantmentIDDefault = 187;
    public static int enchantmentID = 187;
    private static final int enchantmentWeight = 5;
    private static final int increaseDamageEveryXBlocksDefault = 8;
    public static int increaseDamageEveryXBlocks = 8;
    private static final int maxNumberOfBlocksInTreeDefault = -1;
    public static int maxNumberOfBlocksInTree = -1;
    private static final boolean needItemDefault = true;
    public static boolean needItem = true;
    private static final boolean requireItemInAxeListForEnchantDefault = true;
    public static boolean requireItemInAxeListForEnchant = true;
    private static final boolean shearLeavesDefault = false;
    public static boolean shearLeaves = false;
    private static final boolean shearVinesDefault = false;
    public static boolean shearVines = false;
    private static final String sneakActionDefault = "disable";
    public static String sneakAction = "disable";
    private static final boolean stackDropsDefault = false;
    public static boolean stackDrops = false;
    private static final boolean itemsDropInPlaceDefault = true;
    public static boolean itemsDropInPlace = true;
    private static final boolean useIncreasingItemDamageDefault = false;
    public static boolean useIncreasingItemDamage = false;
    private static final boolean useStrictBlockPairingDefault = true;
    public static boolean useStrictBlockPairing = true;
    private static final boolean allowSmartTreeDetectionDefault = true;
    public static boolean allowSmartTreeDetection = true;
    private static final float breakSpeedModifierDefault = 0.256f;
    public static float breakSpeedModifier = 0.256f;
    private static final int maxHorLogBreakDistDefault = 16;
    public static int maxHorLogBreakDist = 16;
    private static final int maxHorLeafBreakDistDefault = 4;
    public static int maxHorLeafBreakDist = 4;
    private static final int maxLeafIDDistDefault = 1;
    public static int maxLeafIDDist = 1;
    private static final int maxVerLogBreakDistDefault = -1;
    public static int maxVerLogBreakDist = -1;
    private static final int minLeavesToIDDefault = 3;
    public static int minLeavesToID = 3;
    private static final boolean onlyDestroyUpwardsDefault = true;
    public static boolean onlyDestroyUpwards = true;
    private static final boolean requireLeafDecayCheckDefault = true;
    public static boolean requireLeafDecayCheck = true;
    private static final boolean useAdvancedTopLogLogicDefault = true;
    public static boolean useAdvancedTopLogLogic = true;
    public static final String multiMineModIDDefault = "AS_MultiMine";
    public static String multiMineModID = "AS_MultiMine";
    public static final boolean userConfigOverridesIMCDefault = false;
    public static boolean userConfigOverridesIMC = false;
    public static final boolean saveIMCConfigsToFileDefault = true;
    public static boolean saveIMCConfigsToFile = true;
    private static final boolean treeHeightDecidesBreakSpeedDefault = true;
    public static boolean treeHeightDecidesBreakSpeed = true;
    private static final float treeHeightModifierDefault = 2.0f;
    public static float treeHeightModifier = 2.0f;
    private static final boolean allowOreDictionaryLookupDefault = false;
    public static boolean allowOreDictionaryLookup = false;
    private static final String oreDictionaryLogStringsDefault = "logWood, woodRubber,";
    public static String oreDictionaryLogStrings = "logWood, woodRubber,";
    private static final String oreDictionaryLeafStringsDefault = "treeLeaves,";
    public static String oreDictionaryLeafStrings = "treeLeaves,";
    private static final String blockIDBlacklistDefault = "";
    public static String blockIDBlacklist = "";
    private static final String itemIDBlacklistDefault = "";
    public static String itemIDBlacklist = "";
    public static Enchantment treecapitating;
    private static TCSettings instance;

    public static TCSettings instance() {
        if (instance == null) {
            new TCSettings();
        }
        return instance;
    }

    private TCSettings() {
        instance = this;
    }

    public void handleEnchantmentID(int id) {
        if (id >= 0 && id < 256 && enableEnchantmentMode) {
            if (Enchantment.field_77331_b[enchantmentID] != null) {
                Enchantment.field_77331_b[TCSettings.enchantmentID] = null;
            }
            enchantmentID = id;
            treecapitating = new EnchantmentTreecapitating(enchantmentID, 5);
            treecapitating.func_77322_b("treecapitating");
        }
    }

    public void readFromNBT(NBTTagCompound ntc) {
        enabled = ntc.func_74767_n("enabled");
        allowItemDamage = ntc.func_74767_n("allowItemDamage");
        allowMoreBlocksThanDamage = ntc.func_74767_n("allowMoreBlocksThanDamage");
        allowSmartTreeDetection = ntc.func_74767_n("allowSmartTreeDetection");
        allowAutoTreeDetection = ntc.func_74767_n("allowAutoTreeDetection");
        allowAutoAxeDetection = ntc.func_74767_n("allowAutoAxeDetection");
        treeHeightDecidesBreakSpeed = ntc.func_74767_n("treeHeightDecidesBreakSpeed");
        treeHeightModifier = ntc.func_74760_g("treeHeightModifier");
        breakSpeedModifier = ntc.func_74760_g("breakSpeedModifier");
        damageIncreaseAmount = ntc.func_74760_g("damageIncreaseAmount");
        damageMultiplier = ntc.func_74760_g("damageMultiplier");
        destroyLeaves = ntc.func_74767_n("destroyLeaves");
        disableCreativeDrops = ntc.func_74767_n("disableCreativeDrops");
        disableInCreative = ntc.func_74767_n("disableInCreative");
        enableEnchantmentMode = ntc.func_74767_n("enableEnchantmentMode");
        allowOreDictionaryLookup = ntc.func_74767_n("allowOreDictionaryLookup");
        oreDictionaryLogStrings = ntc.func_74779_i("oreDictionaryLogStrings");
        oreDictionaryLeafStrings = ntc.func_74779_i("oreDictionaryLeafStrings");
        this.handleEnchantmentID(ntc.func_74762_e("enchantmentID"));
        increaseDamageEveryXBlocks = ntc.func_74762_e("increaseDamageEveryXBlocks");
        maxHorLogBreakDist = ntc.func_74762_e("maxHorLogBreakDist");
        maxHorLeafBreakDist = ntc.func_74762_e("maxHorLeafBreakDist");
        maxLeafIDDist = ntc.func_74762_e("maxLeafIDDist");
        maxNumberOfBlocksInTree = ntc.func_74762_e("maxNumberOfBlocksInTree");
        maxVerLogBreakDist = ntc.func_74762_e("maxVerLogBreakDist");
        minLeavesToID = ntc.func_74762_e("minLeavesToID");
        needItem = ntc.func_74767_n("needItem");
        onlyDestroyUpwards = ntc.func_74767_n("onlyDestroyUpwards");
        requireItemInAxeListForEnchant = ntc.func_74767_n("requireItemInAxeListForEnchant");
        requireLeafDecayCheck = ntc.func_74767_n("requireLeafDecayCheck");
        shearLeaves = ntc.func_74767_n("shearLeaves");
        shearVines = ntc.func_74767_n("shearVines");
        sneakAction = ntc.func_74779_i("sneakAction");
        stackDrops = ntc.func_74767_n("stackDrops");
        itemsDropInPlace = ntc.func_74767_n("itemsDropInPlace");
        useAdvancedTopLogLogic = ntc.func_74767_n("useAdvancedTopLogLogic");
        useIncreasingItemDamage = ntc.func_74767_n("useIncreasingItemDamage");
        useStrictBlockPairing = ntc.func_74767_n("useStrictBlockPairing");
    }

    public void writeToNBT(NBTTagCompound ntc) {
        ntc.func_74757_a("enabled", enabled);
        ntc.func_74757_a("allowItemDamage", allowItemDamage);
        ntc.func_74757_a("allowMoreBlocksThanDamage", allowMoreBlocksThanDamage);
        ntc.func_74757_a("allowOreDictionaryLookup", allowOreDictionaryLookup);
        ntc.func_74757_a("allowSmartTreeDetection", allowSmartTreeDetection);
        ntc.func_74757_a("allowAutoTreeDetection", allowAutoTreeDetection);
        ntc.func_74757_a("allowAutoAxeDetection", allowAutoAxeDetection);
        ntc.func_74757_a("treeHeightDecidesBreakSpeed", treeHeightDecidesBreakSpeed);
        ntc.func_74776_a("treeHeightModifier", treeHeightModifier);
        ntc.func_74776_a("breakSpeedModifier", breakSpeedModifier);
        ntc.func_74776_a("damageIncreaseAmount", damageIncreaseAmount);
        ntc.func_74776_a("damageMultiplier", damageMultiplier);
        ntc.func_74757_a("destroyLeaves", destroyLeaves);
        ntc.func_74757_a("disableCreativeDrops", disableCreativeDrops);
        ntc.func_74757_a("disableInCreative", disableInCreative);
        ntc.func_74757_a("enableEnchantmentMode", enableEnchantmentMode);
        ntc.func_74768_a("enchantmentID", enchantmentID);
        ntc.func_74768_a("increaseDamageEveryXBlocks", increaseDamageEveryXBlocks);
        ntc.func_74768_a("maxHorLogBreakDist", maxHorLogBreakDist);
        ntc.func_74768_a("maxHorLeafBreakDist", maxHorLeafBreakDist);
        ntc.func_74768_a("maxNumberOfBlocksInTree", maxNumberOfBlocksInTree);
        ntc.func_74768_a("maxLeafIDDist", maxLeafIDDist);
        ntc.func_74768_a("maxVerLogBreakDist", maxVerLogBreakDist);
        ntc.func_74768_a("minLeavesToID", minLeavesToID);
        ntc.func_74757_a("needItem", needItem);
        ntc.func_74757_a("onlyDestroyUpwards", onlyDestroyUpwards);
        ntc.func_74778_a("oreDictionaryLogStrings", oreDictionaryLogStrings);
        ntc.func_74778_a("oreDictionaryLeafStrings", oreDictionaryLeafStrings);
        ntc.func_74757_a("requireItemInAxeListForEnchant", requireItemInAxeListForEnchant);
        ntc.func_74757_a("requireLeafDecayCheck", requireLeafDecayCheck);
        ntc.func_74757_a("shearLeaves", shearLeaves);
        ntc.func_74757_a("shearVines", shearVines);
        ntc.func_74778_a("sneakAction", sneakAction);
        ntc.func_74757_a("stackDrops", stackDrops);
        ntc.func_74757_a("itemsDropInPlace", itemsDropInPlace);
        ntc.func_74757_a("useAdvancedTopLogLogic", useAdvancedTopLogLogic);
        ntc.func_74757_a("useIncreasingItemDamage", useIncreasingItemDamage);
        ntc.func_74757_a("useStrictBlockPairing", useStrictBlockPairing);
    }

    public void syncConfiguration(Configuration config) {
        config.moveProperty("general_settings.miscellaneous_settings", "sneakAction", "general_settings.tree_chop_behavior_settings");
        ArrayList<String> orderedKeys = new ArrayList<String>();
        allowDebugLogging = config.getBoolean("allowDebugLogging", "general_settings.miscellaneous_settings", false, "[Global] Set to true if you want Treecapitator to log info about what it's doing, false to disable.\nIf you are having an issue with the mod, set this option to true and post the resulting log to the\nTreecapitator Minecraftforum.net thread along with a detailed description of the issue.", "bspkrs.tc.configgui.allowDebugLogging");
        orderedKeys.add("allowDebugLogging");
        disableCreativeDrops = config.getBoolean("disableCreativeDrops", "general_settings.miscellaneous_settings", false, "[Global] Flag to disable drops in Creative mode", "bspkrs.tc.configgui.disableCreativeDrops");
        orderedKeys.add("disableCreativeDrops");
        disableInCreative = config.getBoolean("disableInCreative", "general_settings.miscellaneous_settings", false, "[Global] Flag to disable tree chopping in Creative mode", "bspkrs.tc.configgui.disableInCreative");
        orderedKeys.add("disableInCreative");
        allowOreDictionaryLookup = config.getBoolean("allowOreDictionaryLookup", "general_settings.miscellaneous_settings", false, "[Global] When true, Treecapitator will scan the Forge Ore Dictionary for blocks with an ore name matching\none of the strings in oreDictionaryLogStrings and generate a generic tree definition for them on the fly. \nWhen false oreDictionaryLogStrings and oreDictionaryLeafStrings will be ignored.", "bspkrs.tc.configgui.allowOreDictionaryLookup");
        orderedKeys.add("allowOreDictionaryLookup");
        oreDictionaryLogStrings = config.getString("oreDictionaryLogStrings", "general_settings.miscellaneous_settings", oreDictionaryLogStringsDefault, "[Global] The list of log type values to check for in the Forge Ore Dictionary. Entries are comma (,) separated.", "bspkrs.tc.configgui.oreDictionaryLogStrings");
        orderedKeys.add("oreDictionaryLogStrings");
        oreDictionaryLeafStrings = config.getString("oreDictionaryLeafStrings", "general_settings.miscellaneous_settings", oreDictionaryLeafStringsDefault, "[Global] The list of leaf type values to check for in the Forge Ore Dictionary. Entries are comma (,) separated.", "bspkrs.tc.configgui.oreDictionaryLeafStrings");
        orderedKeys.add("oreDictionaryLeafStrings");
        blockIDBlacklist = config.getString("blockIDBlacklist", "general_settings.miscellaneous_settings", "", "[Global] Add unique block names to this list if you want to keep them from being registered as logs. This list will override\nthe local user configuration, inter-mod communication (IMC) configuration, and the Ore Dictionary scanning feature.\nUse ',' to split block name from metadata and ';' to split entries.\nRefer to the UniqueNames.txt file in the config folder for a list of values.", "bspkrs.tc.configgui.blockIDBlacklist");
        orderedKeys.add("blockIDBlacklist");
        itemIDBlacklist = config.getString("itemIDBlacklist", "general_settings.miscellaneous_settings", "", "[Global] Add unique item names to this list if you want to keep them from being registered as axes. This list will override\nthe local user configuration and inter-mod communication (IMC) configuration.\nUse ',' to split item name from metadata and ';' to split entries.\nRefer to the UniqueNames.txt file in the config folder for a list of values.", "bspkrs.tc.configgui.itemIDBlacklist");
        orderedKeys.add("itemIDBlacklist");
        config.setCategoryLanguageKey("general_settings.miscellaneous_settings", "bspkrs.tc.configgui.ctgy.general_settings.miscellaneous_settings");
        config.setCategoryPropertyOrder("general_settings.miscellaneous_settings", orderedKeys);
        orderedKeys = new ArrayList();
        breakSpeedModifier = config.getFloat("breakSpeedModifier", "general_settings.break_speed_settings", 0.256f, 0.01f, 1.0f, "[Global, PerTree] When using an item that can chop trees, the break speed will by multiplied by this value\nTHIS OPTION IS IGNORED WHEN treeHeightDecidesBreakSpeed=true", "bspkrs.tc.configgui.breakSpeedModifier");
        orderedKeys.add("breakSpeedModifier");
        treeHeightDecidesBreakSpeed = config.getBoolean("treeHeightDecidesBreakSpeed", "general_settings.break_speed_settings", true, "[Global] When true, the log break speed is equal to original break speed / (tree height * <treeHeightModifier>)\nWhen false, the original break speed is multiplied by the breakSpeedModifier value", "bspkrs.tc.configgui.treeHeightDecidesBreakSpeed");
        orderedKeys.add("treeHeightDecidesBreakSpeed");
        treeHeightModifier = config.getFloat("treeHeightModifier", "general_settings.break_speed_settings", 2.0f, 0.25f, 10.0f, "[Global] See description for treeHeightDecidesBreakSpeed", "bspkrs.tc.configgui.treeHeightModifier");
        orderedKeys.add("treeHeightModifier");
        config.setCategoryLanguageKey("general_settings.break_speed_settings", "bspkrs.tc.configgui.ctgy.general_settings.break_speed_settings");
        config.setCategoryPropertyOrder("general_settings.break_speed_settings", orderedKeys);
        orderedKeys = new ArrayList();
        allowAutoAxeDetection = config.getBoolean("allowAutoAxeDetection", "general_settings.item_settings", true, "[Global] This setting controls whether or not Treecapitator will automatically detect axe-type items. This is\ndone by checking the effectiveness of the tool against logs.\nSet to true to enable this feature, false to disable.", "bspkrs.tc.configgui.allowAutoAxeDetection");
        orderedKeys.add("allowAutoAxeDetection");
        needItem = config.getBoolean("needItem", "general_settings.item_settings", true, "[Global] Whether you need an item from the axeIDList to chop down a tree. Disabling will let you chop \ntrees with any item.", "bspkrs.tc.configgui.needItem");
        orderedKeys.add("needItem");
        allowItemDamage = config.getBoolean("allowItemDamage", "general_settings.item_settings", true, "[Global] Enable to cause item damage based on number of blocks destroyed", "bspkrs.tc.configgui.allowItemDamage");
        orderedKeys.add("allowItemDamage");
        damageMultiplier = config.getFloat("damageMultiplier", "general_settings.item_settings", 1.0f, 0.1f, 50.0f, "[Global] Axes and shears will take damage this many times for each log broken. Remaining damage is \nrounded and applied to tools when a tree is finished.", "bspkrs.tc.configgui.damageMultiplier");
        orderedKeys.add("damageMultiplier");
        allowMoreBlocksThanDamage = config.getBoolean("allowMoreBlocksThanDamage", "general_settings.item_settings", false, "[Global] Enable to allow chopping down the entire tree even if your item does not have enough damage \nremaining to cover the number of blocks.", "bspkrs.tc.configgui.allowMoreBlocksThanDamage");
        orderedKeys.add("allowMoreBlocksThanDamage");
        useIncreasingItemDamage = config.getBoolean("useIncreasingItemDamage", "general_settings.item_settings", false, "[Global] Set to true to have the per-block item damage amount increase after every \nincreaseDamageEveryXBlocks blocks are broken.", "bspkrs.tc.configgui.useIncreasingItemDamage");
        orderedKeys.add("useIncreasingItemDamage");
        damageIncreaseAmount = config.getFloat("damageIncreaseAmount", "general_settings.item_settings", 1.0f, 0.1f, 100.0f, "[Global] When useIncreasingItemDamage=true the damage applied per block broken will increase by this \namount every increaseDamageEveryXBlocks blocks broken in a tree.", "bspkrs.tc.configgui.damageIncreaseAmount");
        orderedKeys.add("damageIncreaseAmount");
        increaseDamageEveryXBlocks = config.getInt("increaseDamageEveryXBlocks", "general_settings.item_settings", 8, 1, 500, "[Global] When useIncreasingItemDamage=true the damage applied per block broken will increase each time \nthis many blocks are broken in a tree.", "bspkrs.tc.configgui.increaseDamageEveryXBlocks");
        orderedKeys.add("increaseDamageEveryXBlocks");
        config.setCategoryLanguageKey("general_settings.item_settings", "bspkrs.tc.configgui.ctgy.general_settings.item_settings");
        config.setCategoryPropertyOrder("general_settings.item_settings", orderedKeys);
        orderedKeys = new ArrayList();
        allowAutoTreeDetection = config.getBoolean("allowAutoTreeDetection", "general_settings.tree_chop_behavior_settings", true, "[Global] This setting controls whether or not Treecapitator will automatically detect new trees when they are\nchopped. This is done by first checking Block.isLog() for the block broken, finding the highest connected block\nof the same type above the block broken, and checking Block.isLeaves() for the blocks around the top log. If\nenough leaf blocks are found the structure is considered a tree and is added to the TreeRegistry. Trees will\nalso be added to your local config file to allow for tweaking of settings if desired.\nSet to true to enable this feature, false to disable.", "bspkrs.tc.configgui.allowAutoTreeDetection");
        orderedKeys.add("allowAutoTreeDetection");
        allowSmartTreeDetection = config.getBoolean("allowSmartTreeDetection", "general_settings.tree_chop_behavior_settings", true, "[Global, PerTree] Set to false to disable Treecapitator Smart Tree Detection.\nSmart Tree Detection counts the number of leaf blocks that are adjacent to the\ntop-most connected log block at the x, z location of a log you've broken. If\nthere are at least minLeavesToID leaf blocks within maxLeafIDDist blocks then\nTreecapitator considers it a tree and allows chopping.\nWARNING: Disabling Smart Tree Detection will remove the only safeguard against\naccidentally destroying a log structure.  Make sure you know what you're doing!", "bspkrs.tc.configgui.allowSmartTreeDetection");
        orderedKeys.add("allowSmartTreeDetection");
        maxLeafIDDist = config.getInt("maxLeafIDDist", "general_settings.tree_chop_behavior_settings", 1, 1, 8, "[Global, PerTree] If a tree's top log is not close enough to leaf blocks, the tree will not be chopped.\nIncreasing this value will search further.  I would try to keep it at or below 3.", "bspkrs.tc.configgui.maxLeafIDDist");
        orderedKeys.add("maxLeafIDDist");
        minLeavesToID = config.getInt("minLeavesToID", "general_settings.tree_chop_behavior_settings", 3, 0, 8, "[Global, PerTree] The minimum number of leaves within maxLeafIDDist of the top log block required to identify a tree.", "bspkrs.tc.configgui.minLeavesToID");
        orderedKeys.add("minLeavesToID");
        useAdvancedTopLogLogic = config.getBoolean("useAdvancedTopLogLogic", "general_settings.tree_chop_behavior_settings", true, "[Global, PerTree] Set to false to use the older \"top log\" algorithm for finding the top log of a tree.\nThe old algorithm searches only the vertical column of blocks above the log you are chopping,\nthe newer algorithm is able to branch out to find the true top log of a tree.", "bspkrs.tc.configgui.useAdvancedTopLogLogic");
        orderedKeys.add("useAdvancedTopLogLogic");
        useStrictBlockPairing = config.getBoolean("useStrictBlockPairing", "general_settings.tree_chop_behavior_settings", true, "[Global] Set to true if you want only the log/leaf blocks listed with each log in a tree\nto break when that log type is chopped.  When set to false it will break\nany log/leaf type blocks connected to the tree, not just the types for that tree.", "bspkrs.tc.configgui.useStrictBlockPairing");
        orderedKeys.add("useStrictBlockPairing");
        destroyLeaves = config.getBoolean("destroyLeaves", "general_settings.tree_chop_behavior_settings", true, "[Global] Enabling this will make leaves be destroyed when trees are chopped.", "bspkrs.tc.configgui.destroyLeaves");
        orderedKeys.add("destroyLeaves");
        requireLeafDecayCheck = config.getBoolean("requireLeafDecayCheck", "general_settings.tree_chop_behavior_settings", true, "[Global, PerTree] When true Treecapitator will only instantly decay leaves that have actually been marked \nfor decay. Set to false if you want leaves to be destroyed regardless of their decay status \n(hint: or for \"leaf\" blocks that are not really leaves).", "bspkrs.tc.configgui.requireLeafDecayCheck");
        orderedKeys.add("requireLeafDecayCheck");
        shearLeaves = config.getBoolean("shearLeaves", "general_settings.tree_chop_behavior_settings", false, "[Global] Enabling this will cause destroyed leaves to be sheared when a shearing item is in the hotbar \n(ignored if destroyLeaves is false).", "bspkrs.tc.configgui.shearLeaves");
        orderedKeys.add("shearLeaves");
        shearVines = config.getBoolean("shearVines", "general_settings.tree_chop_behavior_settings", false, "[Global] Enabling this will shear /some/ of the vines on a tree when a shearing item is in the hotbar \n(ignored if destroyLeaves is false).", "bspkrs.tc.configgui.shearVines");
        orderedKeys.add("shearVines");
        maxNumberOfBlocksInTree = config.getInt("maxNumberOfBlocksInTree", "general_settings.tree_chop_behavior_settings", -1, -1, Integer.MAX_VALUE, "[Gloabl] The maximum number of blocks allowed in a tree to be chopped. If a tree has more blocks than this \nchopping will be canceled. Set to -1 for no limit.", "bspkrs.tc.configgui.maxNumberOfBlocksInTree");
        orderedKeys.add("maxNumberOfBlocksInTree");
        maxHorLeafBreakDist = config.getInt("maxHorLeafBreakDist", "general_settings.tree_chop_behavior_settings", 4, -1, 100, "[Global, PerTree] The maximum horizontal distance that the leaf breaking effect will travel from the tree (use -1 for no limit).", "bspkrs.tc.configgui.maxHorLeafBreakDist");
        orderedKeys.add("maxHorLeafBreakDist");
        maxHorLogBreakDist = config.getInt("maxHorLogBreakDist", "general_settings.tree_chop_behavior_settings", 16, -1, 100, "[Global, PerTree] The maximum horizontal distance that the log breaking effect will travel (use -1 for no limit).", "bspkrs.tc.configgui.maxHorLogBreakDist");
        orderedKeys.add("maxHorLogBreakDist");
        maxVerLogBreakDist = config.getInt("maxVerLogBreakDist", "general_settings.tree_chop_behavior_settings", -1, -1, 255, "[Global, PerTree] The maximum vertical distance that the log breaking effect will travel (use -1 for no limit).", "bspkrs.tc.configgui.maxVerLogBreakDist");
        orderedKeys.add("maxVerLogBreakDist");
        onlyDestroyUpwards = config.getBoolean("onlyDestroyUpwards", "general_settings.tree_chop_behavior_settings", true, "[Global, PerTree] Setting this to false will allow the chopping to move downward as well as upward (and \nblocks below the one you break will be chopped)", "bspkrs.tc.configgui.onlyDestroyUpwards");
        orderedKeys.add("onlyDestroyUpwards");
        sneakAction = config.getString("sneakAction", "general_settings.tree_chop_behavior_settings", sneakActionDefault, "[Global] Set sneakAction = \"disable\" to disable tree chopping while sneaking,\nset sneakAction = \"enable\" to only enable tree chopping while sneaking,\nset sneakAction = \"none\" to have tree chopping enabled regardless of sneaking.", new String[]{"enable", sneakActionDefault, "none"}, "bspkrs.tc.configgui.sneakAction");
        orderedKeys.add("sneakAction");
        stackDrops = config.getBoolean("stackDrops", "general_settings.tree_chop_behavior_settings", false, "[Global] Set to true to enable the stacking of dropped items, false to disable.", "bspkrs.tc.configgui.stackDrops");
        orderedKeys.add("stackDrops");
        itemsDropInPlace = config.getBoolean("itemsDropInPlace", "general_settings.tree_chop_behavior_settings", true, "[Global] Set to true to have items drop in place, false to have them drop at the player's position.", "bspkrs.tc.configgui.itemsDropInPlace");
        orderedKeys.add("itemsDropInPlace");
        config.setCategoryLanguageKey("general_settings.tree_chop_behavior_settings", "bspkrs.tc.configgui.ctgy.general_settings.tree_chop_behavior_settings");
        config.setCategoryPropertyOrder("general_settings.tree_chop_behavior_settings", orderedKeys);
        orderedKeys = new ArrayList();
        enableEnchantmentMode = config.getBoolean("enableEnchantmentMode", "general_settings.enchantment_mode_settings", false, "[Global] Toggle for whether or not to use the Treecapitating enchantment as opposed to requiring an item \nto be in the axeIDList to chop a tree.", "bspkrs.tc.configgui.enableEnchantmentMode");
        orderedKeys.add("enableEnchantmentMode");
        this.handleEnchantmentID(config.getInt("enchantmentID", "general_settings.enchantment_mode_settings", 187, 0, Enchantment.field_77331_b.length - 1, "[Global] The internal ID for the Treecapitating enchantment. Change this if the default ID is conflicting \nwith another mod.", "bspkrs.tc.configgui.enchantmentID"));
        orderedKeys.add("enchantmentID");
        requireItemInAxeListForEnchant = config.getBoolean("requireItemInAxeListForEnchant", "general_settings.enchantment_mode_settings", true, "[Global] Whether or not to check the axe ID list for an item when determining if a given item can be \nimbued with the Treecapitating enchantment.\nNOTE: when set to false, any ItemTool type item (pickaxes, shovels, etc) with a high enough \nenchantability level can get the enchantment, not just axes.", "bspkrs.tc.configgui.requireItemInAxeListForEnchant");
        orderedKeys.add("requireItemInAxeListForEnchant");
        config.setCategoryLanguageKey("general_settings.enchantment_mode_settings", "bspkrs.tc.configgui.ctgy.general_settings.enchantment_mode_settings");
        config.setCategoryPropertyOrder("general_settings.enchantment_mode_settings", orderedKeys);
        enabled = config.getBoolean("enabled", "general_settings", true, "[Global] Set to true to enable Treecapitator, false to disable.", "bspkrs.tc.configgui.enabled");
        config.setCategoryLanguageKey("general_settings", "bspkrs.tc.configgui.ctgy.general_settings");
        config.setCategoryComment("general_settings", "ATTENTION: Editing this file manually is no longer necessary UNLESS YOU ARE ADDING NEW MODS/TREES. \nOn the Mods list screen select the entry for Treecapitator, then click the Config button to modify these settings.");
        if (allowDebugLogging) {
            TCLog.configs(config, "general_settings.miscellaneous_settings");
            TCLog.configs(config, "general_settings.break_speed_settings");
            TCLog.configs(config, "general_settings.item_settings");
            TCLog.configs(config, "general_settings.tree_chop_behavior_settings");
            TCLog.configs(config, "general_settings.enchantment_mode_settings");
        }
    }
}

