/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.config;

import bspkrs.treecapitator.TreecapitatorMod;
import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.config.ConfigChangedEvent;
import bspkrs.util.config.Configuration;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TCConfigHandler {
    private static TCConfigHandler instance;
    private File fileRef;
    private Configuration config;
    private Configuration oldConfig;
    private boolean shouldRefreshRegistries = false;

    public static TCConfigHandler instance() {
        if (instance == null) {
            new TCConfigHandler();
        }
        return instance;
    }

    public static TCConfigHandler setInstance(File file) {
        new TCConfigHandler(file);
        return instance;
    }

    private TCConfigHandler() {
        instance = this;
    }

    private TCConfigHandler(File file) {
        this();
        this.fileRef = file;
        TCLog.info("Loading configuration file %s", file.getAbsolutePath());
        try {
            this.config = new Configuration(this.fileRef, "2.1");
        }
        catch (Throwable e) {
            File fileBak = new File(this.fileRef.getAbsolutePath() + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".errored");
            TCLog.severe("An exception occurred while loading your config file. This file will be renamed to %s and a new config file will be generated.", fileBak.getName());
            e.printStackTrace();
            this.fileRef.renameTo(fileBak);
            this.config = new Configuration(this.fileRef, "2.1");
        }
        if (!"2.1".equals(this.config.getLoadedConfigVersion())) {
            File fileBak = new File(this.fileRef.getAbsolutePath() + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".old");
            TCLog.warning("Your Treecapitator config file is out of date and could cause issues. The existing file will be renamed to %s and a new one will be generated.", fileBak.getName());
            TCLog.warning("Treecapitator will attempt to copy your old settings, but custom mod/tree settings will have to be migrated manually.", new Object[0]);
            this.fileRef.renameTo(fileBak);
            this.oldConfig = this.config;
            this.config = new Configuration(this.fileRef, "2.1");
        }
        this.syncConfig(true);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void setShouldRefreshRegistries(boolean bol) {
        this.shouldRefreshRegistries = bol;
    }

    public void syncConfig() {
        this.syncConfig(false);
    }

    public void syncConfig(boolean init) {
        if (!init) {
            try {
                this.config.load();
            }
            catch (Throwable e) {
                File fileBak = new File(this.fileRef.getAbsolutePath() + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".errored");
                TCLog.severe("An exception occurred while loading your config file. This file will be renamed to %s and a new config file will be generated.", fileBak.getName());
                e.printStackTrace();
                this.fileRef.renameTo(fileBak);
                this.config = new Configuration(this.fileRef, "2.1");
            }
        }
        TCSettings.instance().syncConfiguration(this.config);
        ModConfigRegistry.instance().syncConfig(this.config);
        if (this.oldConfig != null) {
            this.config.copyCategoryProps(this.oldConfig, new String[]{"general_settings.break_speed_settings", "general_settings.enchantment_mode_settings", "general_settings.item_settings", "general_settings.miscellaneous_settings", "general_settings", "general_settings.tree_chop_behavior_settings", "tree_and_mod_configs"});
            TCSettings.instance().syncConfiguration(this.config);
            ModConfigRegistry.instance().syncConfig(this.config);
            this.oldConfig = null;
        }
        if (this.shouldRefreshRegistries) {
            ModConfigRegistry.instance().applyPrioritizedModConfigs();
            TreecapitatorMod.instance.nbtManager().saveAllCurrentObjectsToLocalNBT();
        }
        this.config.save();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("Treecapitator")) {
            this.config.save();
            this.syncConfig();
        }
    }
}

