/*
 * Decompiled with CFR 0.152.
 */
package com.twinklez.hl;

import com.twinklez.hl.HorseLocator;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedProperties
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "ExtendedPlayer";
    private final EntityHorse horse;
    private int currentHealth;
    private int maxHealth;
    private Minecraft mc;

    public ExtendedProperties(EntityHorse horse) {
        this.horse = horse;
        this.currentHealth = this.maxHealth = HorseLocator.getHorseMaxHealth(Minecraft.func_71410_x());
    }

    public static final void register(EntityHorse horse) {
        horse.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ExtendedProperties(horse));
    }

    public static final ExtendedProperties get(EntityHorse horse) {
        return (ExtendedProperties)horse.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("CurrentHealth", this.currentHealth);
        properties.func_74768_a("MaxHealth", this.maxHealth);
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.currentHealth = properties.func_74762_e("CurrentHealth");
        this.maxHealth = properties.func_74762_e("MaxHealth");
    }

    public void init(Entity entity, World world) {
    }

    public void heal() {
        this.currentHealth = this.maxHealth;
    }

    public int getHealth() {
        return this.currentHealth;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }
}

