/*
 * Decompiled with CFR 0.152.
 */
package com.twinklez.hl;

import com.twinklez.hl.AbstractPacket;
import com.twinklez.hl.ExtendedProperties;
import com.twinklez.hl.HorseLocator;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class SyncEntityPropsPacket
extends AbstractPacket {
    private NBTTagCompound data;

    public SyncEntityPropsPacket() {
    }

    public SyncEntityPropsPacket(EntityHorse horse) {
        this.data = new NBTTagCompound();
        ExtendedProperties.get(horse).saveNBTData(this.data);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.data);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.data = ByteBufUtils.readTag((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        ExtendedProperties.get(HorseLocator.nhorse).loadNBTData(this.data);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

