/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.twinklez.hl.HorseLocator;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenOnlineServers;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.mco.ExceptionMcoService;
import net.minecraft.client.mco.GuiScreenClientOutdated;
import net.minecraft.client.mco.McoClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.io.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Project;

@SideOnly(value=Side.CLIENT)
public class GuiHLMainMenu
extends GuiMainMenu {
    private static final AtomicInteger field_146973_f = new AtomicInteger(0);
    private static final Logger logger = LogManager.getLogger();
    private static final Random rand = new Random();
    private float updateCounter;
    private String splashText = "missingno";
    private GuiButton buttonResetDemo;
    private int panoramaTimer;
    private DynamicTexture viewportTexture;
    private boolean field_96141_q = true;
    private static boolean field_96140_r;
    private static boolean field_96139_s;
    private final Object field_104025_t = new Object();
    private String field_92025_p;
    private String field_146972_A = field_96138_a;
    private String field_104024_v;
    private static final ResourceLocation splashTexts;
    private static final ResourceLocation minecraftTitleTextures;
    private static final ResourceLocation[] titlePanoramaPaths;
    public static final String field_96138_a;
    private int field_92024_r;
    private int field_92023_s;
    private int field_92022_t;
    private int field_92021_u;
    private int field_92020_v;
    private int field_92019_w;
    private ResourceLocation field_110351_G;
    private GuiButton minecraftRealmsButton;
    private static final String __OBFID = "CL_00001154";
    private GuiButton fmlModButton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuiHLMainMenu() {
        BufferedReader bufferedreader = null;
        try {
            String s;
            ArrayList<String> arraylist = new ArrayList<String>();
            bufferedreader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(splashTexts).func_110527_b(), Charsets.UTF_8));
            while ((s = bufferedreader.readLine()) != null) {
                if ((s = s.trim()).isEmpty()) continue;
                arraylist.add(s);
            }
            if (!arraylist.isEmpty()) {
                do {
                    this.splashText = (String)arraylist.get(rand.nextInt(arraylist.size()));
                } while (this.splashText.hashCode() == 125780783);
            }
        }
        catch (IOException ioexception1) {
        }
        finally {
            if (bufferedreader != null) {
                try {
                    bufferedreader.close();
                }
                catch (IOException ioexception) {}
            }
        }
        this.updateCounter = rand.nextFloat();
        this.field_92025_p = "";
        if (!OpenGlHelper.field_148827_a) {
            this.field_92025_p = "Old graphics card detected; this may prevent you from";
            this.field_146972_A = "playing in the far future as OpenGL 2.1 will be required.";
            this.field_104024_v = "https://help.mojang.com/customer/portal/articles/325948?ref=game";
        }
    }

    public void func_73876_c() {
        ++this.panoramaTimer;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char par1, int par2) {
    }

    private void func_130022_h() {
        this.minecraftRealmsButton.field_146125_m = true;
        this.fmlModButton.field_146120_f = 98;
        this.fmlModButton.field_146128_h = this.field_146294_l / 2 + 2;
    }

    private void addDemoButtons(int par1, int par2) {
        this.field_146292_n.add(new GuiButton(11, this.field_146294_l / 2 - 100, par1, I18n.func_135052_a((String)"menu.playdemo", (Object[])new Object[0])));
        this.buttonResetDemo = new GuiButton(12, this.field_146294_l / 2 - 100, par1 + par2 * 1, I18n.func_135052_a((String)"menu.resetdemo", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonResetDemo);
        ISaveFormat isaveformat = this.field_146297_k.func_71359_d();
        WorldInfo worldinfo = isaveformat.func_75803_c("Demo_World");
        if (worldinfo == null) {
            this.buttonResetDemo.field_146124_l = false;
        }
    }

    protected void func_146284_a(GuiButton p_146284_1_) {
        ISaveFormat isaveformat;
        WorldInfo worldinfo;
        if (p_146284_1_.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiOptions((GuiScreen)this, this.field_146297_k.field_71474_y));
        }
        if (p_146284_1_.field_146127_k == 5) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLanguage((GuiScreen)this, this.field_146297_k.field_71474_y, this.field_146297_k.func_135016_M()));
        }
        if (p_146284_1_.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectWorld((GuiScreen)this));
        }
        if (p_146284_1_.field_146127_k == 2) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiMultiplayer((GuiScreen)this));
        }
        if (p_146284_1_.field_146127_k == 14 && this.minecraftRealmsButton.field_146125_m) {
            this.func_140005_i();
        }
        if (p_146284_1_.field_146127_k == 4) {
            this.field_146297_k.func_71400_g();
        }
        if (p_146284_1_.field_146127_k == 6) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiModList((GuiScreen)this));
        }
        if (p_146284_1_.field_146127_k == 11) {
            this.field_146297_k.func_71371_a("Demo_World", "Demo_World", DemoWorldServer.field_73071_a);
        }
        if (p_146284_1_.field_146127_k == 12 && (worldinfo = (isaveformat = this.field_146297_k.func_71359_d()).func_75803_c("Demo_World")) != null) {
            GuiYesNo guiyesno = GuiSelectWorld.func_146623_a((GuiScreen)this, (String)worldinfo.func_76065_j(), (int)12);
            this.field_146297_k.func_147108_a((GuiScreen)guiyesno);
        }
    }

    private void func_140005_i() {
        Session session = this.field_146297_k.func_110432_I();
        McoClient mcoclient = new McoClient(session.func_111286_b(), session.func_111285_a(), "1.7.2", Minecraft.func_71410_x().func_110437_J());
        try {
            if (mcoclient.func_148695_c().booleanValue()) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenClientOutdated((GuiScreen)this));
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiScreenOnlineServers((GuiScreen)this));
            }
        }
        catch (ExceptionMcoService exceptionmcoservice) {
            logger.error("Couldn't connect to realms");
        }
        catch (IOException ioexception) {
            logger.error("Couldn't connect to realms");
        }
    }

    public void func_73878_a(boolean par1, int par2) {
        if (par1 && par2 == 12) {
            ISaveFormat isaveformat = this.field_146297_k.func_71359_d();
            isaveformat.func_75800_d();
            isaveformat.func_75802_e("Demo_World");
            this.field_146297_k.func_147108_a((GuiScreen)this);
        } else if (par2 == 13) {
            if (par1) {
                try {
                    Class<?> oclass = Class.forName("java.awt.Desktop");
                    Object object = oclass.getMethod("getDesktop", new Class[0]).invoke((Object)null, new Object[0]);
                    oclass.getMethod("browse", URI.class).invoke(object, new URI(this.field_104024_v));
                }
                catch (Throwable throwable) {
                    logger.error("Couldn't open link", throwable);
                }
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    private void drawPanorama(int par1, int par2, float par3) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Project.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2884);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        int b0 = 8;
        for (int k = 0; k < b0 * b0; ++k) {
            GL11.glPushMatrix();
            float f1 = ((float)(k % b0) / (float)b0 - 0.5f) / 64.0f;
            float f2 = ((float)(k / b0) / (float)b0 - 0.5f) / 64.0f;
            float f3 = 0.0f;
            GL11.glTranslatef((float)f1, (float)f2, (float)f3);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)(((float)this.panoramaTimer + par3) / 400.0f)) * 25.0f + 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(-((float)this.panoramaTimer + par3) * 0.1f), (float)0.0f, (float)1.0f, (float)0.0f);
            for (int l = 0; l < 6; ++l) {
                GL11.glPushMatrix();
                if (l == 1) {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (l == 2) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (l == 3) {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (l == 4) {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                if (l == 5) {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                this.field_146297_k.func_110434_K().func_110577_a(titlePanoramaPaths[l]);
                tessellator.func_78382_b();
                tessellator.func_78384_a(0xFFFFFF, 255 / (k + 1));
                float f4 = 0.0f;
                tessellator.func_78374_a(-1.0, -1.0, 1.0, (double)(0.0f + f4), (double)(0.0f + f4));
                tessellator.func_78374_a(1.0, -1.0, 1.0, (double)(1.0f - f4), (double)(0.0f + f4));
                tessellator.func_78374_a(1.0, 1.0, 1.0, (double)(1.0f - f4), (double)(1.0f - f4));
                tessellator.func_78374_a(-1.0, 1.0, 1.0, (double)(0.0f + f4), (double)(1.0f - f4));
                tessellator.func_78381_a();
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2929);
    }

    private void rotateAndBlurSkybox(float par1) {
        this.field_146297_k.func_110434_K().func_110577_a(this.field_110351_G);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        GL11.glDisable((int)3008);
        int b0 = 3;
        for (int i = 0; i < b0; ++i) {
            tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f / (float)(i + 1));
            int j = this.field_146294_l;
            int k = this.field_146295_m;
            float f1 = (float)(i - b0 / 2) / 256.0f;
            tessellator.func_78374_a((double)j, (double)k, (double)this.field_73735_i, (double)(0.0f + f1), 1.0);
            tessellator.func_78374_a((double)j, 0.0, (double)this.field_73735_i, (double)(1.0f + f1), 1.0);
            tessellator.func_78374_a(0.0, 0.0, (double)this.field_73735_i, (double)(1.0f + f1), 0.0);
            tessellator.func_78374_a(0.0, (double)k, (double)this.field_73735_i, (double)(0.0f + f1), 0.0);
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)3008);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    private void renderSkybox(int par1, int par2, float par3) {
        this.field_146297_k.func_147110_a().func_147609_e();
        GL11.glViewport((int)0, (int)0, (int)256, (int)256);
        this.drawPanorama(par1, par2, par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.rotateAndBlurSkybox(par3);
        this.field_146297_k.func_147110_a().func_147610_a(true);
        GL11.glViewport((int)0, (int)0, (int)this.field_146297_k.field_71443_c, (int)this.field_146297_k.field_71440_d);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        float f1 = this.field_146294_l > this.field_146295_m ? 120.0f / (float)this.field_146294_l : 120.0f / (float)this.field_146295_m;
        float f2 = (float)this.field_146295_m * f1 / 256.0f;
        float f3 = (float)this.field_146294_l * f1 / 256.0f;
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        int k = this.field_146294_l;
        int l = this.field_146295_m;
        tessellator.func_78374_a(0.0, (double)l, (double)this.field_73735_i, (double)(0.5f - f2), (double)(0.5f + f3));
        tessellator.func_78374_a((double)k, (double)l, (double)this.field_73735_i, (double)(0.5f - f2), (double)(0.5f - f3));
        tessellator.func_78374_a((double)k, 0.0, (double)this.field_73735_i, (double)(0.5f + f2), (double)(0.5f - f3));
        tessellator.func_78374_a(0.0, 0.0, (double)this.field_73735_i, (double)(0.5f + f2), (double)(0.5f + f3));
        tessellator.func_78381_a();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        GL11.glDisable((int)3008);
        this.renderSkybox(par1, par2, par3);
        GL11.glEnable((int)3008);
        Tessellator tessellator = Tessellator.field_78398_a;
        int short1 = 274;
        int k = this.field_146294_l / 2 - short1 / 2;
        int b0 = 30;
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -2130706433, 0xFFFFFF);
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, 0, Integer.MIN_VALUE);
        this.field_146297_k.func_110434_K().func_110577_a(minecraftTitleTextures);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if ((double)this.updateCounter < 1.0E-4) {
            this.func_73729_b(k + 0, b0 + 0, 0, 0, 99, 44);
            this.func_73729_b(k + 99, b0 + 0, 129, 0, 27, 44);
            this.func_73729_b(k + 99 + 26, b0 + 0, 126, 0, 3, 44);
            this.func_73729_b(k + 99 + 26 + 3, b0 + 0, 99, 0, 26, 44);
            this.func_73729_b(k + 155, b0 + 0, 0, 45, 155, 44);
        } else {
            this.func_73729_b(k + 0, b0 + 0, 0, 0, 155, 44);
            this.func_73729_b(k + 155, b0 + 0, 0, 45, 155, 44);
        }
        tessellator.func_78378_d(-1);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.field_146294_l / 2 + 90), (float)70.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71386_F() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
        f1 = f1 * 100.0f / (float)(this.field_146289_q.func_78256_a(this.splashText) + 32);
        GL11.glScalef((float)f1, (float)f1, (float)f1);
        this.func_73732_a(this.field_146289_q, this.splashText, 0, -8, -256);
        GL11.glPopMatrix();
        String s = "Minecraft 1.7.2\n" + HorseLocator.getInfo();
        if (this.field_146297_k.func_71355_q()) {
            s = s + " Demo";
        }
        List brandings = Lists.reverse((List)FMLCommonHandler.instance().getBrandings(true));
        for (int i = 0; i < brandings.size(); ++i) {
            String brd = (String)brandings.get(i);
            if (Strings.isNullOrEmpty((String)brd)) continue;
            this.func_73731_b(this.field_146289_q, brd, 2, this.field_146295_m - (10 + i * (this.field_146289_q.field_78288_b + 1)), 0xFFFFFF);
        }
        ForgeHooksClient.renderMainMenu((GuiMainMenu)this, (FontRenderer)this.field_146289_q, (int)this.field_146294_l, (int)this.field_146295_m);
        String s1 = "Copyright Mojang AB. Do not distribute!";
        this.func_73731_b(this.field_146289_q, s1, this.field_146294_l - this.field_146289_q.func_78256_a(s1) - 2, this.field_146295_m - 10, -1);
        if (this.field_92025_p != null && this.field_92025_p.length() > 0) {
            GuiHLMainMenu.func_73734_a((int)(this.field_92022_t - 2), (int)(this.field_92021_u - 2), (int)(this.field_92020_v + 2), (int)(this.field_92019_w - 1), (int)0x55200000);
            this.func_73731_b(this.field_146289_q, this.field_92025_p, this.field_92022_t, this.field_92021_u, -1);
            this.func_73731_b(this.field_146289_q, this.field_146972_A, (this.field_146294_l - this.field_92024_r) / 2, ((GuiButton)this.field_146292_n.get((int)0)).field_146129_i - 12, -1);
        }
        super.func_73863_a(par1, par2, par3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        Object object = this.field_104025_t;
        Object object2 = this.field_104025_t;
        synchronized (object2) {
            if (this.field_92025_p.length() > 0 && par1 >= this.field_92022_t && par1 <= this.field_92020_v && par2 >= this.field_92021_u && par2 <= this.field_92019_w) {
                GuiConfirmOpenLink guiconfirmopenlink = new GuiConfirmOpenLink((GuiScreen)this, this.field_104024_v, 13, true);
                guiconfirmopenlink.func_146358_g();
                this.field_146297_k.func_147108_a((GuiScreen)guiconfirmopenlink);
            }
        }
    }

    static {
        splashTexts = new ResourceLocation("texts/splashes.txt");
        minecraftTitleTextures = new ResourceLocation("textures/gui/title/minecraft.png");
        titlePanoramaPaths = new ResourceLocation[]{new ResourceLocation("textures/gui/title/background/panorama_0.png"), new ResourceLocation("textures/gui/title/background/panorama_1.png"), new ResourceLocation("textures/gui/title/background/panorama_2.png"), new ResourceLocation("textures/gui/title/background/panorama_3.png"), new ResourceLocation("textures/gui/title/background/panorama_4.png"), new ResourceLocation("textures/gui/title/background/panorama_5.png")};
        field_96138_a = "Please click " + EnumChatFormatting.UNDERLINE + "here" + EnumChatFormatting.RESET + " for more information.";
    }
}

