/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import info.jbcs.minecraft.chisel.ChiselBlocks;
import info.jbcs.minecraft.chisel.ChiselModCompatibility;
import info.jbcs.minecraft.chisel.ChiselWorldGenerator;
import info.jbcs.minecraft.chisel.CommonProxy;
import info.jbcs.minecraft.chisel.Crafting;
import info.jbcs.minecraft.chisel.StepSoundEx;
import info.jbcs.minecraft.chisel.carving.Carving;
import info.jbcs.minecraft.chisel.client.gui.GuiChisel;
import info.jbcs.minecraft.chisel.entity.EntityBallOMoss;
import info.jbcs.minecraft.chisel.entity.EntityCloudInABottle;
import info.jbcs.minecraft.chisel.entity.EntitySmashingRock;
import info.jbcs.minecraft.chisel.inventory.ContainerChisel;
import info.jbcs.minecraft.chisel.inventory.InventoryChiselSelection;
import info.jbcs.minecraft.chisel.item.ItemBallOMoss;
import info.jbcs.minecraft.chisel.item.ItemChisel;
import info.jbcs.minecraft.chisel.item.ItemCloudInABottle;
import info.jbcs.minecraft.chisel.item.ItemSmashingRock;
import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="chisel", name="Chisel", version="1.5.4g")
public class Chisel {
    public static ItemChisel chisel;
    public static ItemCloudInABottle itemCloudInABottle;
    public static ItemBallOMoss itemBallOMoss;
    public static ItemSmashingRock smashingRock;
    public static CreativeTabs tabChisel;
    public static boolean multipartLoaded;
    public static boolean configExists;
    public static boolean oldPillars;
    public static boolean disableCTM;
    public static double concreteVelocity;
    public static int particlesTickrate;
    public static boolean blockDescriptions;
    public static boolean ghostCloud;
    public static final StepSoundEx soundHolystoneFootstep;
    public static final StepSoundEx soundTempleFootstep;
    public static final StepSoundEx soundMetalFootstep;
    static Configuration config;
    public static int RenderEldritchId;
    public static int RenderCTMId;
    public static int RenderCarpetId;
    @Mod.Instance(value="chisel")
    public static Chisel instance;
    @SidedProxy(clientSide="info.jbcs.minecraft.chisel.ClientProxy", serverSide="info.jbcs.minecraft.chisel.CommonProxy")
    public static CommonProxy proxy;
    public static boolean chiselStoneToCobbleBricks;
    public static boolean enableChiseling;

    public static boolean featureEnabled(String feature) {
        return config.get("features", feature, true).getBoolean(true);
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping m : event.get()) {
            if (!m.name.startsWith("null.") || m.name.length() != 6 || m.type != GameRegistry.Type.BLOCK) continue;
            m.setAction(FMLMissingMappingsEvent.Action.WARN);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        configExists = configFile.exists();
        config = new Configuration(configFile);
        config.load();
        tabChisel = new CreativeTabs("tabChisel"){

            public Item func_78016_d() {
                return chisel;
            }
        };
        chisel = (ItemChisel)new ItemChisel(Carving.chisel).func_111206_d("chisel:chisel").func_77637_a(CreativeTabs.field_78040_i);
        GameRegistry.registerItem((Item)chisel, (String)"chisel");
        if (Chisel.featureEnabled("cloud")) {
            itemCloudInABottle = (ItemCloudInABottle)new ItemCloudInABottle().func_111206_d("Chisel:cloudinabottle").func_77637_a(CreativeTabs.field_78040_i);
            EntityRegistry.registerModEntity(EntityCloudInABottle.class, (String)"CloudInABottle", (int)1, (Object)this, (int)40, (int)1, (boolean)true);
            GameRegistry.registerItem((Item)itemCloudInABottle, (String)"chisel.cloudinabottle");
        }
        if (Chisel.featureEnabled("ballOfMoss")) {
            itemBallOMoss = (ItemBallOMoss)new ItemBallOMoss().func_111206_d("Chisel:ballomoss").func_77637_a(CreativeTabs.field_78040_i);
            EntityRegistry.registerModEntity(EntityBallOMoss.class, (String)"BallOMoss", (int)2, (Object)this, (int)40, (int)1, (boolean)true);
            GameRegistry.registerItem((Item)itemBallOMoss, (String)"ballomoss");
        }
        if (Chisel.featureEnabled("smashingRock")) {
            smashingRock = (ItemSmashingRock)new ItemSmashingRock().func_111206_d("Chisel:smashingrock").func_77637_a(CreativeTabs.field_78040_i);
            EntityRegistry.registerModEntity(EntitySmashingRock.class, (String)"SmashingRock", (int)2, (Object)this, (int)40, (int)1, (boolean)true);
            GameRegistry.registerItem((Item)smashingRock, (String)"smashingrock");
        }
        concreteVelocity = config.get("general", "concreteVelocity", 0.45, "Traversing concrete roads, players will acceleration to this velocity. For reference, normal running speed is about 0.28. Set to 0 to disable acceleration.").getDouble(0.45);
        particlesTickrate = config.get("client", "particleTickrate", 1, "Particle tick rate. Greater value = less particles.").getInt(1);
        oldPillars = config.get("client", "pillarOldGraphics", false, "Use old pillar textures").getBoolean(false);
        disableCTM = !config.get("client", "connectedTextures", true, "Enable connected textures").getBoolean(true);
        blockDescriptions = config.get("cslient", "tooltipsUseBlockDescriptions", true, "Make variations of blocks have the same name, and use the description in tooltip to distinguish them.").getBoolean(true);
        chiselStoneToCobbleBricks = config.get("general", "chiselStoneToCobbleBricks", true, "Chisel stone to cobblestone and bricks by left-click.").getBoolean(true);
        enableChiseling = config.get("general", "enableChiselingLeftClicking", false, "Change blocks to another block using the Chisel and left-click.").getBoolean(false);
        ghostCloud = config.get("general", "doesCloudRenderLikeGhost", true).getBoolean(true);
        ChiselBlocks.load();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Crafting.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, new IGuiHandler(){

            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                return new ContainerChisel(player.field_71071_by, new InventoryChiselSelection(null));
            }

            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                return new GuiChisel(player.field_71071_by, new InventoryChiselSelection(null));
            }
        });
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ChiselWorldGenerator(ChiselBlocks.blockMarble, 32, config.get("worldgen", "marbleAmount", 8, "Amount of marble to generate in the world; use 0 for none").getInt(8)), (int)1000);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ChiselWorldGenerator(ChiselBlocks.blockLimestone, 32, config.get("worldgen", "limestoneAmount", 4, "Amount of limestone to generate in the world; use 0 for none").getInt(4)), (int)1000);
        proxy.init();
        config.save();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        new ChiselModCompatibility().postInit(event);
    }

    static {
        multipartLoaded = false;
        soundHolystoneFootstep = new StepSoundEx("chisel:holystone", "chisel:holystone", "chisel:holystone", 1.0f);
        soundTempleFootstep = new StepSoundEx("dig.stone", "chisel:temple-footstep", "dig.stone", 1.0f);
        soundMetalFootstep = new StepSoundEx("chisel:metal", "chisel:metal", "chisel:metal", 1.0f);
    }
}

