/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel.carving;

import info.jbcs.minecraft.chisel.carving.CarvingGroup;
import info.jbcs.minecraft.chisel.carving.CarvingVariation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class Carving {
    HashMap<String, CarvingGroup> carvingGroupsByName = new HashMap();
    HashMap<String, CarvingGroup> carvingGroupsByOre = new HashMap();
    HashMap<String, CarvingGroup> carvingGroupsByVariation = new HashMap();
    public static Carving chisel = new Carving();
    public static Carving needle = new Carving();

    String key(Item item, int metadata) {
        return Item.field_150901_e.func_148750_c((Object)item) + "|" + metadata;
    }

    String key(Block block, int metadata) {
        return Block.field_149771_c.func_148750_c((Object)block) + "|" + metadata;
    }

    public boolean isVariationOfSameClass(Block target, int metadata1, Block block2, int metadata2) {
        CarvingGroup group1 = this.carvingGroupsByVariation.get(this.key(target, metadata1));
        if (group1 == null) {
            return false;
        }
        CarvingGroup group2 = this.carvingGroupsByVariation.get(this.key(block2, metadata2));
        if (group2 == null) {
            return false;
        }
        return group1 == group2 || group1.className.equals(group2.className) && !group1.className.isEmpty();
    }

    public CarvingVariation[] getVariations(Block block, int metadata) {
        CarvingGroup group = this.getGroup(block, metadata);
        if (group == null) {
            return null;
        }
        CarvingVariation[] res = group.variations.toArray(new CarvingVariation[group.variations.size()]);
        return res;
    }

    public String getOre(Block block, int metadata) {
        CarvingGroup group = this.getGroup(block, metadata);
        if (group == null) {
            return null;
        }
        return group.oreName;
    }

    public ArrayList<ItemStack> getItems(ItemStack chiseledItem) {
        ArrayList ores;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int damage = chiseledItem.func_77960_j();
        CarvingGroup group = this.getGroup(Block.func_149634_a((Item)chiseledItem.func_77973_b()), damage);
        if (group == null) {
            return items;
        }
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        if (group.variations != null) {
            for (CarvingVariation v : group.variations) {
                String key = Block.func_149682_b((Block)v.block) + "|" + v.damage;
                if (mapping.containsKey(key)) continue;
                mapping.put(key, 1);
                items.add(new ItemStack(v.block, 1, v.damage));
            }
        }
        if (group.oreName != null && (ores = OreDictionary.getOres((String)group.oreName)) != null) {
            for (ItemStack stack : ores) {
                String key = Item.func_150891_b((Item)stack.func_77973_b()) + "|" + stack.func_77960_j();
                if (mapping.containsKey(key)) continue;
                mapping.put(key, 2);
                items.add(stack);
            }
        }
        return items;
    }

    public CarvingGroup getGroup(Block block, int metadata) {
        int i;
        if (block.equals(Blocks.field_150348_b)) {
            block = Blocks.field_150417_aV;
        }
        if ((i = OreDictionary.getOreID((String)block.func_149739_a())) < 1) {
            return null;
        }
        CarvingGroup res = this.carvingGroupsByVariation.get(this.key(block, metadata));
        if (res != null) {
            return res;
        }
        return null;
    }

    CarvingGroup getGroup(String name) {
        CarvingGroup group = this.carvingGroupsByName.get(name);
        if (group == null) {
            group = new CarvingGroup(name);
            group.className = name;
            this.carvingGroupsByName.put(name, group);
        }
        return group;
    }

    public CarvingVariation addVariation(String name, Block block, int metadata, int order) {
        CarvingGroup group = this.getGroup(name);
        CarvingGroup blockGroup = this.carvingGroupsByVariation.get(this.key(block, metadata));
        if (blockGroup != null || blockGroup == group) {
            return null;
        }
        CarvingVariation variation = new CarvingVariation(block, metadata, order);
        group.variations.add(variation);
        Collections.sort(group.variations);
        this.carvingGroupsByVariation.put(this.key(block, metadata), group);
        return variation;
    }

    public void registerOre(String name, String oreName) {
        CarvingGroup group = this.getGroup(name);
        this.carvingGroupsByOre.put(oreName, group);
        group.oreName = oreName;
    }

    public void setGroupClass(String name, String className) {
        CarvingGroup group = this.getGroup(name);
        group.className = className;
    }

    public void setVariationSound(String name, String sound) {
        CarvingGroup group = this.getGroup(name);
        group.sound = sound;
    }

    public String getVariationSound(Block block, int metadata) {
        return this.getVariationSound(Item.func_150898_a((Block)block), metadata);
    }

    public String getVariationSound(Item item, int metadata) {
        CarvingGroup blockGroup = this.carvingGroupsByVariation.get(this.key(item, metadata));
        if (blockGroup == null || blockGroup.sound == null) {
            return "chisel:chisel";
        }
        return blockGroup.sound;
    }
}

