/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import info.jbcs.minecraft.utilities.Drawing;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class BlockMarblePaneRenderer
implements ISimpleBlockRenderingHandler {
    public static int id;
    PaneRenderer paneRenderer = new PaneRenderer();

    public BlockMarblePaneRenderer() {
        id = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks renderer) {
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
        renderer.func_147782_a(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625);
        Drawing.drawBlock(block, meta, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block b, int modelId, RenderBlocks renderer) {
        boolean isolatedBottom;
        BlockPane block = (BlockPane)b;
        Tessellator tessellator = Tessellator.field_78398_a;
        int worldHeight = world.func_72800_K();
        tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
        float f = 1.0f;
        int i1 = block.func_149720_d(world, x, y, z);
        float f1 = (float)(i1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(i1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(i1 & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f6 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f6;
        }
        tessellator.func_78386_a(f * f1, f * f2, f * f3);
        int meta = world.func_72805_g(x, y, z);
        IIcon iconPane = block.func_149691_a(2, meta);
        IIcon iconTop = block.func_149691_a(1, meta);
        IIcon iconSide = block.func_149691_a(0, meta);
        if (iconPane == null || iconTop == null || iconSide == null) {
            return false;
        }
        this.paneRenderer.set(x, y, z, iconPane, iconTop, iconSide);
        boolean connectsNorth = block.func_150098_a(world.func_147439_a(x, y, z - 1));
        boolean connectsSouth = block.func_150098_a(world.func_147439_a(x, y, z + 1));
        boolean connectsWest = block.func_150098_a(world.func_147439_a(x - 1, y, z));
        boolean connectsEast = block.func_150098_a(world.func_147439_a(x + 1, y, z));
        boolean connectsTop = block.func_150098_a(world.func_147439_a(x, y + 1, z));
        boolean connectsBottom = block.func_150098_a(world.func_147439_a(x, y - 1, z));
        boolean connectsTopNorth = block.func_150098_a(world.func_147439_a(x, y + 1, z - 1));
        boolean connectsTopSouth = block.func_150098_a(world.func_147439_a(x, y + 1, z + 1));
        boolean connectsTopWest = block.func_150098_a(world.func_147439_a(x - 1, y + 1, z));
        boolean connectsTopEast = block.func_150098_a(world.func_147439_a(x + 1, y + 1, z));
        boolean connectsBottomNorth = block.func_150098_a(world.func_147439_a(x, y - 1, z - 1));
        boolean connectsBottomSouth = block.func_150098_a(world.func_147439_a(x, y - 1, z + 1));
        boolean connectsBottomWest = block.func_150098_a(world.func_147439_a(x - 1, y - 1, z));
        boolean connectsBottomEast = block.func_150098_a(world.func_147439_a(x + 1, y - 1, z));
        boolean isolatedTop = !connectsTopNorth && !connectsTopSouth && !connectsTopWest && !connectsTopEast;
        boolean bl = isolatedBottom = !connectsBottomNorth && !connectsBottomSouth && !connectsBottomWest && !connectsBottomEast;
        if (!(connectsNorth || connectsSouth || connectsWest || connectsEast)) {
            connectsEast = true;
            connectsWest = true;
            connectsSouth = true;
            connectsNorth = true;
        }
        int connections = 0;
        if (connectsNorth) {
            this.paneRenderer.renderNorthPane();
            if (!connectsBottom || !connectsBottomNorth && !isolatedBottom) {
                this.paneRenderer.renderVerticalNS(-3.0E-4, 0.0, 0.5, 0.5, 0.0);
            }
            if (!connectsTop || !connectsTopNorth && !isolatedTop) {
                this.paneRenderer.renderVerticalNS(1.0003, 0.0, 0.5, 0.5, 0.0);
            }
            ++connections;
        }
        if (connectsSouth) {
            this.paneRenderer.renderSouthPane();
            if (!connectsBottom || !connectsBottomSouth && !isolatedBottom) {
                this.paneRenderer.renderVerticalNS(-4.0E-4, 0.5, 1.0, 1.0, 0.5);
            }
            if (!connectsTop || !connectsTopSouth && !isolatedTop) {
                this.paneRenderer.renderVerticalNS(1.0004, 0.5, 1.0, 1.0, 0.5);
            }
            ++connections;
        }
        if (connectsWest) {
            this.paneRenderer.renderWestPane();
            if (!connectsBottom || !connectsBottomWest && !isolatedBottom) {
                this.paneRenderer.renderVerticalWE(-1.0E-4, 0.0, 0.5, 0.5, 0.0);
            }
            if (!connectsTop || !connectsTopWest && !isolatedTop) {
                this.paneRenderer.renderVerticalWE(1.0001, 0.0, 0.5, 0.5, 0.0);
            }
            ++connections;
        }
        if (connectsEast) {
            this.paneRenderer.renderEastPane();
            if (!connectsBottom || !connectsBottomEast && !isolatedBottom) {
                this.paneRenderer.renderVerticalWE(-2.0E-4, 0.5, 1.0, 1.0, 0.5);
            }
            if (!connectsTop || !connectsTopEast && !isolatedTop) {
                this.paneRenderer.renderVerticalWE(1.0002, 0.5, 1.0, 1.0, 0.5);
            }
            ++connections;
        }
        if (connections == 1) {
            if (connectsNorth) {
                this.paneRenderer.renderHorizontalNS(0.5, 1.0, 0.0);
            }
            if (connectsSouth) {
                this.paneRenderer.renderHorizontalNS(0.5, 0.0, 1.0);
            }
            if (connectsEast) {
                this.paneRenderer.renderHorizontalWE(0.5, 0.0, 1.0);
            }
            if (connectsWest) {
                this.paneRenderer.renderHorizontalWE(0.5, 1.0, 0.0);
            }
        } else if (connections == 4) {
            this.paneRenderer.renderHorizontalNS(0.0, 1.0, 0.0);
            this.paneRenderer.renderHorizontalNS(1.0, 0.0, 1.0);
            this.paneRenderer.renderHorizontalWE(0.0, 0.0, 1.0);
            this.paneRenderer.renderHorizontalWE(1.0, 1.0, 0.0);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int renderId) {
        return false;
    }

    public int getRenderId() {
        return id;
    }

    class PaneRenderer {
        Tessellator tessellator;
        double i0u0;
        double i0uh;
        double i0u1;
        double i0v0;
        double i0v1;
        double i1u0;
        double i1u1;
        double i1v0;
        double i1vh;
        double i1v1;
        double i1v;
        double i2u0;
        double i2u1;
        double i2v0;
        double i2v1;
        double i2v;
        double x0;
        double xh;
        double x1;
        double xp0;
        double xp1;
        double z0;
        double zh;
        double z1;
        double zp0;
        double zp1;
        double y0;
        double y1;

        PaneRenderer() {
        }

        void set(double x, double y, double z, IIcon icon, IIcon icon1, IIcon icon2) {
            this.tessellator = Tessellator.field_78398_a;
            this.i0u0 = icon.func_94209_e();
            this.i0uh = icon.func_94214_a(8.0);
            this.i0u1 = icon.func_94212_f();
            this.i0v0 = icon.func_94206_g();
            this.i0v1 = icon.func_94210_h();
            this.i1u0 = icon1.func_94214_a(7.0);
            this.i1u1 = icon1.func_94214_a(9.0);
            this.i1v0 = icon1.func_94206_g();
            this.i1vh = icon1.func_94207_b(8.0);
            this.i1v1 = icon1.func_94210_h();
            this.i1v = this.i1v1 - this.i1v0;
            this.i2u0 = icon2.func_94214_a(7.0);
            this.i2u1 = icon2.func_94214_a(9.0);
            this.i2v0 = icon2.func_94206_g();
            this.i2v1 = icon2.func_94210_h();
            this.i2v = this.i2v1 - this.i2v0;
            this.x0 = x;
            this.xh = this.x0 + 0.5;
            this.x1 = x + 1.0;
            this.xp0 = this.x0 + 0.5 - 0.0625;
            this.xp1 = this.x0 + 0.5 + 0.0625;
            this.z0 = z;
            this.zh = this.z0 + 0.5;
            this.z1 = z + 1.0;
            this.zp0 = this.z0 + 0.5 - 0.0625;
            this.zp1 = this.z0 + 0.5 + 0.0625;
            this.y0 = y;
            this.y1 = y + 1.0;
        }

        public void renderNorthPane() {
            this.tessellator.func_78374_a(this.xh, this.y1, this.z0, this.i0uh, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y0, this.z0, this.i0uh, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y0, this.zh, this.i0u0, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y1, this.zh, this.i0u0, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y1, this.zh, this.i0u0, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y0, this.zh, this.i0u0, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y0, this.z0, this.i0uh, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y1, this.z0, this.i0uh, this.i0v0);
        }

        public void renderSouthPane() {
            this.tessellator.func_78374_a(this.xh, this.y1, this.zh, this.i0u1, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y0, this.zh, this.i0u1, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y0, this.z1, this.i0uh, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y1, this.z1, this.i0uh, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y1, this.z1, this.i0uh, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y0, this.z1, this.i0uh, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y0, this.zh, this.i0u1, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y1, this.zh, this.i0u1, this.i0v0);
        }

        public void renderWestPane() {
            this.tessellator.func_78374_a(this.x0, this.y1, this.zh, this.i0uh, this.i0v0);
            this.tessellator.func_78374_a(this.x0, this.y0, this.zh, this.i0uh, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y0, this.zh, this.i0u0, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y1, this.zh, this.i0u0, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y1, this.zh, this.i0u0, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y0, this.zh, this.i0u0, this.i0v1);
            this.tessellator.func_78374_a(this.x0, this.y0, this.zh, this.i0uh, this.i0v1);
            this.tessellator.func_78374_a(this.x0, this.y1, this.zh, this.i0uh, this.i0v0);
        }

        public void renderEastPane() {
            this.tessellator.func_78374_a(this.xh, this.y1, this.zh, this.i0u1, this.i0v0);
            this.tessellator.func_78374_a(this.xh, this.y0, this.zh, this.i0u1, this.i0v1);
            this.tessellator.func_78374_a(this.x1, this.y0, this.zh, this.i0uh, this.i0v1);
            this.tessellator.func_78374_a(this.x1, this.y1, this.zh, this.i0uh, this.i0v0);
            this.tessellator.func_78374_a(this.x1, this.y1, this.zh, this.i0uh, this.i0v0);
            this.tessellator.func_78374_a(this.x1, this.y0, this.zh, this.i0uh, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y0, this.zh, this.i0u1, this.i0v1);
            this.tessellator.func_78374_a(this.xh, this.y1, this.zh, this.i0u1, this.i0v0);
        }

        public void renderVerticalNS(double y, double zoff0, double zoff1, double v0, double v1) {
            this.tessellator.func_78374_a(this.xp0, this.y0 + y, this.z0 + zoff0, this.i1u0, this.i1v0 + this.i1v * v0);
            this.tessellator.func_78374_a(this.xp0, this.y0 + y, this.z0 + zoff1, this.i1u0, this.i1v0 + this.i1v * v1);
            this.tessellator.func_78374_a(this.xp1, this.y0 + y, this.z0 + zoff1, this.i1u1, this.i1v0 + this.i1v * v1);
            this.tessellator.func_78374_a(this.xp1, this.y0 + y, this.z0 + zoff0, this.i1u1, this.i1v0 + this.i1v * v0);
            this.tessellator.func_78374_a(this.xp0, this.y0 + y, this.z0 + zoff1, this.i1u0, this.i1v0 + this.i1v * v1);
            this.tessellator.func_78374_a(this.xp0, this.y0 + y, this.z0 + zoff0, this.i1u0, this.i1v0 + this.i1v * v0);
            this.tessellator.func_78374_a(this.xp1, this.y0 + y, this.z0 + zoff0, this.i1u1, this.i1v0 + this.i1v * v0);
            this.tessellator.func_78374_a(this.xp1, this.y0 + y, this.z0 + zoff1, this.i1u1, this.i1v0 + this.i1v * v1);
        }

        public void renderVerticalWE(double y, double xoff0, double xoff1, double v0, double v1) {
            this.tessellator.func_78374_a(this.x0 + xoff0, this.y0 + y, this.zp1, this.i1u1, this.i1v0 + this.i1v * v0);
            this.tessellator.func_78374_a(this.x0 + xoff1, this.y0 + y, this.zp1, this.i1u1, this.i1v0 + this.i1v * v1);
            this.tessellator.func_78374_a(this.x0 + xoff1, this.y0 + y, this.zp0, this.i1u0, this.i1v0 + this.i1v * v1);
            this.tessellator.func_78374_a(this.x0 + xoff0, this.y0 + y, this.zp0, this.i1u0, this.i1v0 + this.i1v * v0);
            this.tessellator.func_78374_a(this.x0 + xoff1, this.y0 + y, this.zp1, this.i1u1, this.i1v0 + this.i1v * v1);
            this.tessellator.func_78374_a(this.x0 + xoff0, this.y0 + y, this.zp1, this.i1u1, this.i1v0 + this.i1v * v0);
            this.tessellator.func_78374_a(this.x0 + xoff0, this.y0 + y, this.zp0, this.i1u0, this.i1v0 + this.i1v * v0);
            this.tessellator.func_78374_a(this.x0 + xoff1, this.y0 + y, this.zp0, this.i1u0, this.i1v0 + this.i1v * v1);
        }

        public void renderHorizontalNS(double zoff, double v0, double v1) {
            this.tessellator.func_78374_a(this.xp0, this.y1, this.z0 + zoff, this.i2u0, this.i2v0 + this.i2v * v1);
            this.tessellator.func_78374_a(this.xp0, this.y0, this.z0 + zoff, this.i2u0, this.i2v0 + this.i2v * v0);
            this.tessellator.func_78374_a(this.xp1, this.y0, this.z0 + zoff, this.i2u1, this.i2v0 + this.i2v * v0);
            this.tessellator.func_78374_a(this.xp1, this.y1, this.z0 + zoff, this.i2u1, this.i2v0 + this.i2v * v1);
            this.tessellator.func_78374_a(this.xp1, this.y1, this.z0 + zoff, this.i2u1, this.i2v0 + this.i2v * v1);
            this.tessellator.func_78374_a(this.xp1, this.y0, this.z0 + zoff, this.i2u1, this.i2v0 + this.i2v * v0);
            this.tessellator.func_78374_a(this.xp0, this.y0, this.z0 + zoff, this.i2u0, this.i2v0 + this.i2v * v0);
            this.tessellator.func_78374_a(this.xp0, this.y1, this.z0 + zoff, this.i2u0, this.i2v0 + this.i2v * v1);
        }

        public void renderHorizontalWE(double xoff, double v0, double v1) {
            this.tessellator.func_78374_a(this.x0 + xoff, this.y1, this.zp0, this.i2u0, this.i2v0 + this.i2v * v1);
            this.tessellator.func_78374_a(this.x0 + xoff, this.y0, this.zp0, this.i2u0, this.i2v0 + this.i2v * v0);
            this.tessellator.func_78374_a(this.x0 + xoff, this.y0, this.zp1, this.i2u1, this.i2v0 + this.i2v * v0);
            this.tessellator.func_78374_a(this.x0 + xoff, this.y1, this.zp1, this.i2u1, this.i2v0 + this.i2v * v1);
            this.tessellator.func_78374_a(this.x0 + xoff, this.y1, this.zp1, this.i2u1, this.i2v0 + this.i2v * v1);
            this.tessellator.func_78374_a(this.x0 + xoff, this.y0, this.zp1, this.i2u1, this.i2v0 + this.i2v * v0);
            this.tessellator.func_78374_a(this.x0 + xoff, this.y0, this.zp0, this.i2u0, this.i2v0 + this.i2v * v0);
            this.tessellator.func_78374_a(this.x0 + xoff, this.y1, this.zp0, this.i2u0, this.i2v0 + this.i2v * v1);
        }
    }
}

